/* LanguageTool, a natural language style checker
 * Copyright (C) 2022 Sohaib Afifi, Taha Zerrouki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

package org.languagetool.tools;

public class ArabicConstants {
  private ArabicConstants() {
    // restrict instantiation
  }

  // Harakat
  public static final char FATHATAN = '\u064b';
  public static final char DAMMATAN = '\u064C';
  public static final char KASRATAN = '\u064D';
  public static final char FATHA = '\u064E';
  public static final char DAMMA = '\u064F';
  public static final char KASRA = '\u0650';
  public static final char SHADDA = '\u0651';
  public static final char SUKUN = '\u0652';
  public static final char MADDAH_ABOVE = '\u0653';

  // letters
  public static final char COMMA = '\u060C';
  public static final char SEMICOLON = '\u061B';
  public static final char QUESTION = '\u061F';
  public static final char HAMZA = '\u0621';
  public static final char ALEF_MADDA = '\u0622';
  public static final char ALEF_HAMZA_ABOVE = '\u0623';
  public static final char WAW_HAMZA = '\u0624';
  public static final char ALEF_HAMZA_BELOW = '\u0625';
  public static final char YEH_HAMZA = '\u0626';
  public static final char ALEF = '\u0627';
  public static final char BEH = '\u0628';
  public static final char TEH_MARBUTA = '\u0629';
  public static final char TEH = '\u062a';
  public static final char THEH = '\u062b';
  public static final char JEEM = '\u062c';
  public static final char HAH = '\u062d';
  public static final char KHAH = '\u062e';
  public static final char DAL = '\u062f';
  public static final char THAL = '\u0630';
  public static final char REH = '\u0631';
  public static final char ZAIN = '\u0632';
  public static final char SEEN = '\u0633';
  public static final char SHEEN = '\u0634';
  public static final char SAD = '\u0635';
  public static final char DAD = '\u0636';
  public static final char TAH = '\u0637';
  public static final char ZAH = '\u0638';
  public static final char AIN = '\u0639';
  public static final char GHAIN = '\u063a';
  public static final char TATWEEL = '\u0640';
  public static final char FEH = '\u0641';
  public static final char QAF = '\u0642';
  public static final char KAF = '\u0643';
  public static final char LAM = '\u0644';
  public static final char MEEM = '\u0645';
  public static final char NOON = '\u0646';
  public static final char HEH = '\u0647';
  public static final char WAW = '\u0648';
  public static final char ALEF_AKSURA = '\u0649';
  public static final char YEH = '\u064a';
  public static final char MADDA_ABOVE = '\u0653';
  public static final char HAMZA_ABOVE = '\u0654';
  public static final char HAMZA_BELOW = '\u0655';

  // digit
  public static final char ZERO = '\u0660';
  public static final char ONE = '\u0661';
  public static final char TWO = '\u0662';
  public static final char THREE = '\u0663';
  public static final char FOUR = '\u0664';
  public static final char FIVE = '\u0665';
  public static final char SIX = '\u0666';
  public static final char SEVEN = '\u0667';
  public static final char EIGHT = '\u0668';
  public static final char NINE = '\u0669';

  // Arabic Symbol
  public static final char PERCENT = '\u066a';
  public static final char DECIMAL = '\u066b';
  public static final char THOUSANDS = '\u066c';
  public static final char STAR = '\u066d';
  public static final char MINI_ALEF = '\u0670';
  public static final char ALEF_WASLA = '\u0671';
  public static final char FULL_STOP = '\u06d4';
  public static final char BYTE_ORDER_MARK = '\ufeff';

}