/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.LanguageWithModel;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.ar.ArabicCommaWhitespaceRule;
import org.languagetool.rules.ar.ArabicConfusionProbabilityRule;
import org.languagetool.rules.ar.ArabicDarjaRule;
import org.languagetool.rules.ar.ArabicDiacriticsRule;
import org.languagetool.rules.ar.ArabicDoublePunctuationRule;
import org.languagetool.rules.ar.ArabicHomophonesRule;
import org.languagetool.rules.ar.ArabicHunspellSpellerRule;
import org.languagetool.rules.ar.ArabicInflectedOneWordReplaceRule;
import org.languagetool.rules.ar.ArabicQuestionMarkWhitespaceRule;
import org.languagetool.rules.ar.ArabicRedundancyRule;
import org.languagetool.rules.ar.ArabicSemiColonWhitespaceRule;
import org.languagetool.rules.ar.ArabicSimpleReplaceRule;
import org.languagetool.rules.ar.ArabicTransVerbRule;
import org.languagetool.rules.ar.ArabicWordCoherencyRule;
import org.languagetool.rules.ar.ArabicWordRepeatRule;
import org.languagetool.rules.ar.ArabicWordinessRule;
import org.languagetool.rules.ar.ArabicWrongWordInContextRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ar.ArabicHybridDisambiguator;
import org.languagetool.tagging.ar.ArabicTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tokenizers.ArabicWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;

public class Arabic
extends LanguageWithModel {
    public String getName() {
        return "Arabic";
    }

    public String getShortCode() {
        return "ar";
    }

    public String[] getCountries() {
        return new String[]{"", "SA", "DZ", "BH", "EG", "IQ", "JO", "KW", "LB", "LY", "MA", "OM", "QA", "SD", "SY", "TN", "AE", "YE"};
    }

    public Disambiguator createDefaultDisambiguator() {
        return new ArabicHybridDisambiguator();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new ArabicWordTokenizer();
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new ArabicTagger();
    }

    public Synthesizer createDefaultSynthesizer() {
        return ArabicSynthesizer.INSTANCE;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Taha Zerrouki"), new Contributor("Sohaib Afifi")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u00ab", "\ufd3e", "\"", "'"), Arrays.asList("]", ")", "}", "\u00bb", "\ufd3f", "\"", "'")), new CommaWhitespaceRule(messages, true), new LongSentenceRule(messages, userConfig, 50), new ArabicHunspellSpellerRule(messages, userConfig), new ArabicCommaWhitespaceRule(messages), new ArabicQuestionMarkWhitespaceRule(messages), new ArabicSemiColonWhitespaceRule(messages), new ArabicDoublePunctuationRule(messages), new ArabicWordRepeatRule(messages), new ArabicSimpleReplaceRule(messages), new ArabicDiacriticsRule(messages), new ArabicDarjaRule(messages), new ArabicHomophonesRule(messages), new ArabicRedundancyRule(messages), new ArabicWordCoherencyRule(messages), new ArabicWordinessRule(messages), new ArabicWrongWordInContextRule(messages, (Language)this), new ArabicTransVerbRule(messages), new ArabicInflectedOneWordReplaceRule(messages)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) {
        return Collections.singletonList(new ArabicConfusionProbabilityRule(messages, languageModel, (Language)this));
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new ArabicHunspellSpellerRule(messages);
    }
}

