/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.ar.ArabicTagManager;
import org.languagetool.tools.ArabicNumbersWords;

public class ArabicNumberPhraseFilter
extends RuleFilter {
    private static final ArabicTagManager tagmanager = new ArabicTagManager();
    private final ArabicSynthesizer synthesizer = new ArabicSynthesizer((Language)new Arabic());

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        List<String> suggestionList;
        String previousWord = arguments.getOrDefault("previous", "");
        int previousWordPos = ArabicNumberPhraseFilter.getPreviousPos(arguments);
        String inflectArg = arguments.getOrDefault("inflect", "");
        String nextWord = arguments.getOrDefault("next", "");
        int nextWordPos = ArabicNumberPhraseFilter.getNextPos(arguments, patternTokens.length);
        ArrayList<String> numWordTokens = new ArrayList<String>();
        int startPos = previousWordPos > 0 ? previousWordPos + 1 : 0;
        int endPos = nextWordPos > 0 ? Integer.min(nextWordPos, patternTokens.length) : patternTokens.length + nextWordPos;
        for (int i = startPos; i < endPos; ++i) {
            numWordTokens.add(patternTokens[i].getToken().trim());
        }
        String numPhrase = String.join((CharSequence)" ", numWordTokens);
        boolean feminine = false;
        boolean attached = false;
        String inflection = ArabicNumberPhraseFilter.getInflectedCase(patternTokens, previousWordPos, inflectArg);
        if (nextWord.isEmpty()) {
            suggestionList = ArabicNumberPhraseFilter.prepareSuggestion(numPhrase, previousWord, null, feminine, attached, inflection);
        } else {
            AnalyzedTokenReadings nextWordToken = null;
            if (endPos > 0 && endPos < patternTokens.length) {
                nextWordToken = patternTokens[endPos];
            }
            suggestionList = this.prepareSuggestionWithUnits(numPhrase, previousWord, nextWordToken, feminine, attached, inflection);
        }
        RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        if (!suggestionList.isEmpty()) {
            for (String sug : suggestionList) {
                newMatch.addSuggestedReplacement(sug);
            }
        }
        return newMatch;
    }

    private static String getInflectedCase(AnalyzedTokenReadings[] patternTokens, int previousPos, String inflect) {
        String firstWord;
        if (!Objects.equals(inflect, "")) {
            return inflect;
        }
        if (previousPos >= 0 && previousPos < patternTokens.length) {
            AnalyzedTokenReadings previousToken = patternTokens[previousPos];
            for (AnalyzedToken tk : patternTokens[previousPos]) {
                if (tk.getPOSTag() == null || !tk.getPOSTag().startsWith("PR")) continue;
                return "jar";
            }
        }
        if ((firstWord = patternTokens[previousPos + 1].getToken()).startsWith("\u0628") || firstWord.startsWith("\u0644") || firstWord.startsWith("\u0643")) {
            return "jar";
        }
        return "";
    }

    private static boolean getFemininCase(AnalyzedTokenReadings[] patternTokens, int nextPos) {
        for (AnalyzedToken tk : patternTokens[nextPos]) {
            if (!tagmanager.isFeminin(tk.getPOSTag())) continue;
            return true;
        }
        return false;
    }

    public static List<String> prepareSuggestion(String numPhrase, String previousWord, AnalyzedTokenReadings nextWord, boolean feminin, boolean attached, String inflection) {
        List<String> tmpsuggestionList = ArabicNumbersWords.getSuggestionsNumericPhrase(numPhrase, feminin, attached, inflection);
        ArrayList<String> suggestionList = new ArrayList<String>();
        if (!tmpsuggestionList.isEmpty()) {
            for (String sug : tmpsuggestionList) {
                if (previousWord.isEmpty()) continue;
                suggestionList.add(previousWord + " " + sug);
            }
        }
        return suggestionList;
    }

    public List<String> prepareSuggestionWithUnits(String numPhrase, String previousWord, AnalyzedTokenReadings nextWord, boolean feminin, boolean attached, String inflection) {
        String defaultUnit = "\u062f\u064a\u0646\u0627\u0631";
        List<Map<String, String>> tmpsuggestionList = ArabicNumbersWords.getSuggestionsNumericPhraseWithUnits(numPhrase, defaultUnit, feminin, attached, inflection);
        ArrayList<String> suggestionList = new ArrayList<String>();
        if (!tmpsuggestionList.isEmpty()) {
            for (Map<String, String> sugMap : tmpsuggestionList) {
                String sug = sugMap.get("phrase");
                List<String> inflectedUnitList = this.inflectUnit(nextWord, sugMap);
                for (String unit : inflectedUnitList) {
                    StringBuilder tmp = new StringBuilder();
                    if (!previousWord.isEmpty()) {
                        tmp.append(previousWord + " ");
                    }
                    tmp.append(sug);
                    if (unit != null && !unit.isEmpty()) {
                        tmp.append(" " + unit);
                    }
                    suggestionList.add(tmp.toString());
                }
            }
        }
        return suggestionList;
    }

    private List<String> inflectUnit(AnalyzedTokenReadings unit, Map<String, String> sugMap) {
        if (unit == null) {
            return null;
        }
        String inflection = sugMap.getOrDefault("unitInflection", "");
        String number = sugMap.getOrDefault("unitNumber", "");
        String inflected = unit.getToken() + "{" + inflection + "+" + number + "}";
        ArrayList<String> tmpList = new ArrayList<String>();
        ArrayList<String> inflectedList = new ArrayList<String>();
        for (AnalyzedToken tk : unit) {
            String postag = tk.getPOSTag();
            if (!tagmanager.isNoun(postag) || tagmanager.isDefinite(postag) || tagmanager.hasPronoun(postag)) continue;
            postag = inflection.equals("jar") ? tagmanager.setMajrour(postag) : (inflection.equals("raf3") ? tagmanager.setMarfou3(postag) : (inflection.equals("nasb") ? tagmanager.setMansoub(postag) : tagmanager.setMarfou3(postag)));
            postag = number.equals("one") ? tagmanager.setSingle(postag) : (number.equals("two") ? tagmanager.setDual(postag) : (number.equals("plural") ? tagmanager.setPlural(postag) : tagmanager.setSingle(postag)));
            if (number.equals("one") && inflection.equals("nasb")) {
                postag = tagmanager.setTanwin(postag);
            }
            if (tmpList.contains(postag)) continue;
            tmpList.add(postag);
            List<String> syhthesizedList = Arrays.asList(this.synthesizer.synthesize(tk, postag));
            if (syhthesizedList == null || syhthesizedList.isEmpty()) continue;
            inflectedList.addAll(syhthesizedList);
        }
        return inflectedList;
    }

    private static int getPreviousPos(Map<String, String> args) {
        int previousWordPos = 0;
        if (args.get("previousPos") != null) {
            try {
                if (args.get("previousPos") != null) {
                    previousWordPos = Integer.valueOf(args.get("previousPos")) - 1;
                }
            }
            catch (NumberFormatException e) {
                previousWordPos = -1;
            }
        }
        return previousWordPos;
    }

    private static int getNextPos(Map<String, String> args, int size) {
        int nextPos = 0;
        try {
            nextPos = Integer.parseInt(args.getOrDefault("nextPos", "0"));
            if (nextPos < 0) {
                nextPos = size + nextPos;
            }
        }
        catch (NumberFormatException e) {
            nextPos = 0;
        }
        return nextPos;
    }
}

