/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ar;

import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArabicTagManager {
    private static final int NOUN_TAG_LENGTH = 12;
    private static final int NOUN_FLAG_POS_WORDTYPE = 0;
    private static final int NOUN_FLAG_POS_CATEGORY = 1;
    private static final int NOUN_FLAG_POS_GENDER = 4;
    private static final int NOUN_FLAG_POS_NUMBER = 5;
    private static final int NOUN_FLAG_POS_CASE = 6;
    private static final int NOUN_FLAG_POS_INFLECT_MARK = 7;
    private static final int NOUN_FLAG_POS_CONJ = 9;
    private static final int NOUN_FLAG_POS_JAR = 10;
    private static final int NOUN_FLAG_POS_PRONOUN = 11;
    private static final int VERB_TAG_LENGTH = 15;
    private static final int VERB_FLAG_POS_WORDTYPE = 0;
    private static final int VERB_FLAG_POS_CATEGORY = 1;
    private static final int VERB_FLAG_POS_TRANS = 2;
    private static final int VERB_FLAG_POS_GENDER = 4;
    private static final int VERB_FLAG_POS_NUMBER = 5;
    private static final int VERB_FLAG_POS_PERSON = 6;
    private static final int VERB_FLAG_POS_INFLECT_MARK = 7;
    private static final int VERB_FLAG_POS_TENSE = 8;
    private static final int VERB_FLAG_POS_VOICE = 9;
    private static final int VERB_FLAG_POS_CASE = 10;
    private static final int VERB_FLAG_POS_CONJ = 12;
    private static final int VERB_FLAG_POS_ISTIQBAL = 13;
    private static final int VERB_FLAG_POS_PRONOUN = 14;
    private static final int PARTICLE_TAG_LENGTH = 11;
    private static final int PARTICLE_FLAG_POS_WORDTYPE = 0;
    private static final int PARTICLE_FLAG_POS_CATEGORY = 1;
    private static final int PARTICLE_FLAG_POS_OPTION = 2;
    private static final int PARTICLE_FLAG_POS_GENDER = 4;
    private static final int PARTICLE_FLAG_POS_NUMBER = 5;
    private static final int PARTICLE_FLAG_POS_CASE = 6;
    private static final int PARTICLE_FLAG_POS_CONJ = 8;
    private static final int PARTICLE_FLAG_POS_JAR = 9;
    private static final int PARTICLE_FLAG_POS_PRONOUN = 10;
    private final HashMap<String, Integer> mapFlagPos = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(ArabicTagManager.class);

    public ArabicTagManager() {
        this.loadHashmap();
    }

    public String modifyPosTag(String postag, List<String> tags) {
        for (String tg : tags) {
            if ((postag = this.addTag(postag, tg)) != null) continue;
            return null;
        }
        return postag;
    }

    public String addTag(String postag, String flagString) {
        String[] flagTuple = flagString.split(";");
        String flag = "";
        String flagType = "";
        if (flagTuple.length == 1) {
            flag = flagTuple[0];
        }
        if (flagTuple.length >= 2) {
            flagType = flagTuple[0];
            flag = flagTuple[1];
        }
        return this.addTag(postag, flagType, flag);
    }

    public String addTag(String postag, String flagType, String flag) {
        switch (flag) {
            case "W": {
                postag = this.setFlag(postag, "CONJ", 'W');
                break;
            }
            case "K": {
                if (this.isNoun(postag)) {
                    if (this.isMajrour(postag)) {
                        postag = this.setFlag(postag, "JAR", 'K');
                        break;
                    }
                    return null;
                }
                return null;
            }
            case "B": {
                if (this.isNoun(postag)) {
                    if (this.isMajrour(postag)) {
                        postag = this.setFlag(postag, "JAR", 'B');
                        break;
                    }
                    return null;
                }
                return null;
            }
            case "L": {
                if (this.isNoun(postag)) {
                    if (this.isMajrour(postag)) {
                        postag = this.setFlag(postag, "JAR", 'L');
                        break;
                    }
                    return null;
                }
                postag = this.setFlag(postag, "ISTIQBAL", 'L');
                break;
            }
            case "D": {
                if (this.isUnAttachedNoun(postag)) {
                    postag = this.setFlag(postag, "PRONOUN", 'L');
                    break;
                }
                return null;
            }
            case "S": {
                if (this.isFutureTense(postag)) {
                    postag = this.setFlag(postag, "ISTIQBAL", 'S');
                    break;
                }
                return null;
            }
        }
        if (flagType.equals("PRONOUN") && !flag.isEmpty() && !flag.equals("D")) {
            postag = this.setFlag(postag, flagType, flag.charAt(0));
        }
        return postag;
    }

    public boolean isMajrour(String postag) {
        char flag = this.getFlag(postag, "CASE");
        return flag == 'I' || flag == '-';
    }

    public String setJar(String postag, String jar) {
        int myflag = 0;
        if (this.isMajrour(postag)) {
            if (jar.equals("\u0628") || jar.equals("B")) {
                myflag = 66;
            } else if (jar.equals("\u0644") || jar.equals("L")) {
                myflag = 76;
            } else if (jar.equals("\u0643") || jar.equals("K")) {
                myflag = 75;
            } else if (jar.equals("-") || jar.isEmpty()) {
                myflag = 45;
            }
            if (myflag != 0) {
                postag = this.setFlag(postag, "JAR", (char)myflag);
            }
        }
        return postag;
    }

    public String setDefinite(String postag, String flag) {
        int myflag = 0;
        if (this.isNoun(postag) && this.isUnAttachedNoun(postag)) {
            if (flag.equals("\u0627\u0644") || flag.equals("L") || flag.equals("\u0644\u0644") || flag.equals("D")) {
                myflag = 76;
            } else if (flag.equals("-") || flag.isEmpty()) {
                myflag = 45;
            }
            if (myflag != 0) {
                postag = this.setFlag(postag, "PRONOUN", (char)myflag);
            }
        }
        return postag;
    }

    public String unifyPronounTag(String postag) {
        char flag = this.getFlag(postag, "PRONOUN");
        if (this.isAttached(postag)) {
            postag = this.setFlag(postag, "PRONOUN", 'H');
        }
        return postag;
    }

    public String setConjunction(String postag, String flag) {
        int myflag = 0;
        if (flag.equals("\u0648") || flag.equals("W") || flag.equals("\u0641") || flag.equals("F")) {
            myflag = 87;
        } else if (flag.equals("-") || flag.isEmpty()) {
            myflag = 45;
        }
        if (myflag != 0 && (this.isNoun(postag) || this.isVerb(postag))) {
            postag = this.setFlag(postag, "CONJ", (char)myflag);
        }
        return postag;
    }

    public String setPronoun(String postag, String flag) {
        char myflag = '\u0000';
        if (flag.equals("\u0647") || flag.equals("H")) {
            myflag = 'H';
        }
        if (myflag != '\u0000' && (this.isNoun(postag) || this.isVerb(postag))) {
            postag = this.setFlag(postag, "PRONOUN", myflag);
        }
        return postag;
    }

    public boolean isFutureTense(String postag) {
        return this.isVerb(postag) && this.getFlag(postag, "TENSE") == 'f';
    }

    public boolean isUnAttachedNoun(String postag) {
        return this.isNoun(postag) && this.getFlag(postag, "PRONOUN") != 'H' && !postag.endsWith("X");
    }

    public boolean isAttached(String postag) {
        return (this.isNoun(postag) || this.isVerb(postag)) && this.getFlag(postag, "PRONOUN") == 'H';
    }

    public boolean isStopWord(String postag) {
        return postag.startsWith("P");
    }

    public boolean isNoun(String postag) {
        return postag != null && postag.startsWith("N");
    }

    public boolean isDual(String postag) {
        return postag != null && this.getFlag(postag, "NUMBER") == '2';
    }

    public boolean isVerb(String postag) {
        return postag != null && postag.startsWith("V");
    }

    public boolean isAdj(String postag) {
        return postag != null && postag.startsWith("NA");
    }

    public boolean isMasdar(String postag) {
        return postag != null && postag.startsWith("NM");
    }

    public boolean isDefinite(String postag) {
        return this.isNoun(postag) && this.getFlag(postag, "PRONOUN") == 'L';
    }

    public boolean isFeminin(String postag) {
        return this.isNoun(postag) && this.getFlag(postag, "GENDER") == 'F';
    }

    public boolean isBreak(String postag) {
        return this.isStopWord(postag) && !this.hasConjunction(postag) || this.isNoun(postag) && !this.hasJar(postag) && !this.hasConjunction(postag) || this.isVerb(postag) && !this.hasConjunction(postag);
    }

    public boolean hasJar(String postag) {
        return this.isNoun(postag) && this.getFlag(postag, "JAR") != '-';
    }

    public boolean hasPronoun(String postag) {
        return this.getFlag(postag, "PRONOUN") == 'H';
    }

    public boolean hasConjunction(String postag) {
        char flag = this.getFlag(postag, "CONJ");
        return this.isNoun(postag) && flag != '-' || this.isVerb(postag) && flag != '-' || this.isStopWord(postag) && flag != 'W';
    }

    public String getDefinitePrefix(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        if (this.isNoun(postag) && this.getFlag(postag, "PRONOUN") == 'L') {
            if (this.hasJar(postag) && this.getJarPrefix(postag).equals("\u0644")) {
                return "\u0644";
            }
            return "\u0627\u0644";
        }
        return "";
    }

    public String getJarPrefix(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        if (this.isNoun(postag)) {
            char flag = this.getFlag(postag, "JAR");
            if (flag == 'L') {
                return "\u0644";
            }
            if (flag == 'K') {
                return "\u0643";
            }
            if (flag == 'B') {
                return "\u0628";
            }
        }
        return "";
    }

    public String getConjunctionPrefix(String postag) {
        if (this.getFlag(postag, "CONJ") == 'F') {
            return "\u0641";
        }
        if (this.getFlag(postag, "CONJ") == 'W') {
            return "\u0648";
        }
        return "";
    }

    public String getPronounSuffix(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        char flag = this.getFlag(postag, "PRONOUN");
        String suffix = "";
        switch (flag) {
            case 'b': {
                suffix = "\u0646\u064a";
                break;
            }
            case 'c': {
                suffix = "\u0646\u0627";
                break;
            }
            case 'd': {
                suffix = "\u0643";
                break;
            }
            case 'e': {
                suffix = "\u0643\u0645\u0627";
                break;
            }
            case 'f': {
                suffix = "\u0643\u0645";
                break;
            }
            case 'g': {
                suffix = "\u0643\u0646";
                break;
            }
            case 'H': {
                suffix = "\u0647";
                break;
            }
            case 'i': {
                suffix = "\u0647\u0627";
                break;
            }
            case 'j': {
                suffix = "\u0647\u0645\u0627";
                break;
            }
            case 'k': {
                suffix = "\u0647\u0645";
                break;
            }
            case 'n': {
                suffix = "\u0647\u0646";
            }
        }
        return suffix;
    }

    private int getFlagPos(String postag, String flagType) {
        return this.getFlagPos2(postag, flagType);
    }

    @Deprecated
    private int getFlagPos1(String postag, String flagType) {
        int pos = 0;
        Object key = "";
        if (this.isNoun(postag)) {
            key = "NOUN_FLAG_POS_" + flagType;
        } else if (this.isVerb(postag)) {
            key = "VERB_FLAG_POS_" + flagType;
        }
        if (((String)key).equals("NOUN_TAG_LENGTH")) {
            pos = 12;
        } else if (((String)key).equals("NOUN_FLAG_POS_WORDTYPE")) {
            pos = 0;
        } else if (((String)key).equals("NOUN_FLAG_POS_CATEGORY")) {
            pos = 1;
        } else if (((String)key).equals("NOUN_FLAG_POS_GENDER")) {
            pos = 4;
        } else if (((String)key).equals("NOUN_FLAG_POS_NUMBER")) {
            pos = 5;
        } else if (((String)key).equals("NOUN_FLAG_POS_CASE")) {
            pos = 6;
        } else if (((String)key).equals("NOUN_FLAG_POS_INFLECT_MARK")) {
            pos = 7;
        } else if (((String)key).equals("NOUN_FLAG_POS_CONJ")) {
            pos = 9;
        } else if (((String)key).equals("NOUN_FLAG_POS_JAR")) {
            pos = 10;
        } else if (((String)key).equals("NOUN_FLAG_POS_PRONOUN")) {
            pos = 11;
        } else if (((String)key).equals("VERB_TAG_LENGTH")) {
            pos = 15;
        } else if (((String)key).equals("VERB_FLAG_POS_WORDTYPE")) {
            pos = 0;
        } else if (((String)key).equals("VERB_FLAG_POS_CATEGORY")) {
            pos = 1;
        } else if (((String)key).equals("VERB_FLAG_POS_TRANS")) {
            pos = 2;
        } else if (((String)key).equals("VERB_FLAG_POS_GENDER")) {
            pos = 4;
        } else if (((String)key).equals("VERB_FLAG_POS_NUMBER")) {
            pos = 5;
        } else if (((String)key).equals("VERB_FLAG_POS_PERSON")) {
            pos = 6;
        } else if (((String)key).equals("VERB_FLAG_POS_INFLECT_MARK")) {
            pos = 7;
        } else if (((String)key).equals("VERB_FLAG_POS_TENSE")) {
            pos = 8;
        } else if (((String)key).equals("VERB_FLAG_POS_VOICE")) {
            pos = 9;
        } else if (((String)key).equals("VERB_FLAG_POS_CASE")) {
            pos = 10;
        } else if (((String)key).equals("VERB_FLAG_POS_CONJ")) {
            pos = 12;
        } else if (((String)key).equals("VERB_FLAG_POS_ISTIQBAL")) {
            pos = 13;
        } else if (((String)key).equals("VERB_FLAG_POS_PRONOUN")) {
            pos = 14;
        } else if (((String)key).equals("PARTICLE_TAG_LENGTH")) {
            pos = 11;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_WORDTYPE")) {
            pos = 0;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_CATEGORY")) {
            pos = 1;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_GENDER")) {
            pos = 4;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_NUMBER")) {
            pos = 5;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_CASE")) {
            pos = 6;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_CONJ")) {
            pos = 8;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_JAR")) {
            pos = 9;
        } else if (((String)key).equals("PARTICLE_FLAG_POS_PRONOUN")) {
            pos = 10;
        }
        return pos;
    }

    public char getFlag(String postag, String flagType) {
        int pos = this.getFlagPos(postag, flagType);
        if (pos < postag.length()) {
            return postag.charAt(pos);
        }
        return '-';
    }

    public String setFlag(String postag, String flagType, char flag) {
        StringBuilder tmp = new StringBuilder(postag);
        try {
            tmp.setCharAt(this.getFlagPos(postag, flagType), flag);
        }
        catch (StringIndexOutOfBoundsException e) {
            int pos = this.getFlagPos(postag, flagType);
            logger.debug("ArabicTagmanager:Exception: pos flag" + Integer.toString(pos) + "flagtype:" + flagType + " postag:" + tmp + " len:" + tmp.length());
        }
        return tmp.toString();
    }

    private void loadHashmap() {
        this.mapFlagPos.put("None", 0);
        this.mapFlagPos.put("NOUN_TAG_LENGTH", 12);
        this.mapFlagPos.put("NOUN_WORDTYPE", 0);
        this.mapFlagPos.put("NOUN_CATEGORY", 1);
        this.mapFlagPos.put("NOUN_GENDER", 4);
        this.mapFlagPos.put("NOUN_NUMBER", 5);
        this.mapFlagPos.put("NOUN_CASE", 6);
        this.mapFlagPos.put("NOUN_INFLECT_MARK", 7);
        this.mapFlagPos.put("NOUN_CONJ", 9);
        this.mapFlagPos.put("NOUN_JAR", 10);
        this.mapFlagPos.put("NOUN_PRONOUN", 11);
        this.mapFlagPos.put("VERB_TAG_LENGTH", 15);
        this.mapFlagPos.put("VERB_WORDTYPE", 0);
        this.mapFlagPos.put("VERB_CATEGORY", 1);
        this.mapFlagPos.put("VERB_TRANS", 2);
        this.mapFlagPos.put("VERB_GENDER", 4);
        this.mapFlagPos.put("VERB_NUMBER", 5);
        this.mapFlagPos.put("VERB_PERSON", 6);
        this.mapFlagPos.put("VERB_INFLECT_MARK", 7);
        this.mapFlagPos.put("VERB_TENSE", 8);
        this.mapFlagPos.put("VERB_VOICE", 9);
        this.mapFlagPos.put("VERB_CASE", 10);
        this.mapFlagPos.put("VERB_CONJ", 12);
        this.mapFlagPos.put("VERB_ISTIQBAL", 13);
        this.mapFlagPos.put("VERB_PRONOUN", 14);
        this.mapFlagPos.put("PARTICLE_TAG_LENGTH", 11);
        this.mapFlagPos.put("PARTICLE_WORDTYPE", 0);
        this.mapFlagPos.put("PARTICLE_CATEGORY", 1);
        this.mapFlagPos.put("PARTICLE_OPTION", 2);
        this.mapFlagPos.put("PARTICLE_CONJ", 8);
        this.mapFlagPos.put("PARTICLE_JAR", 9);
        this.mapFlagPos.put("PARTICLE_PRONOUN", 10);
    }

    private int getFlagPos2(String tagString, String flagType) {
        int pos = 0;
        Object key = "";
        if (this.isNoun(tagString)) {
            key = "NOUN_" + flagType;
        } else if (this.isVerb(tagString)) {
            key = "VERB_" + flagType;
        } else if (this.isStopWord(tagString)) {
            key = "PARTICLE_" + flagType;
        }
        try {
            pos = this.mapFlagPos.get(key);
        }
        catch (NullPointerException e) {
            pos = 0;
        }
        return pos;
    }

    public String setProcleticFlags(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        String newposTag = postag;
        if (this.isVerb(postag)) {
            newposTag = this.setFlag(newposTag, "CONJ", '-');
            newposTag = this.setFlag(newposTag, "ISTIQBAL", '-');
        } else if (this.isNoun(postag)) {
            newposTag = this.setFlag(newposTag, "CONJ", '-');
            newposTag = this.setFlag(newposTag, "JAR", '-');
            if (this.isDefinite(postag)) {
                newposTag = this.setFlag(newposTag, "PRONOUN", '-');
            }
        } else if (this.isStopWord(postag)) {
            newposTag = this.setFlag(newposTag, "CONJ", '-');
            newposTag = this.setFlag(newposTag, "JAR", '-');
        } else {
            return postag;
        }
        return newposTag;
    }

    public String mergePosTag(String sourcePosTag, String targetPosTag) {
        String tmp = sourcePosTag;
        if (sourcePosTag == null || sourcePosTag.isEmpty()) {
            return targetPosTag;
        }
        if (targetPosTag == null || targetPosTag.isEmpty()) {
            return sourcePosTag;
        }
        if (this.isNoun(sourcePosTag) && this.isNoun(targetPosTag)) {
            if (sourcePosTag.length() != targetPosTag.length()) {
                return sourcePosTag;
            }
            tmp = this.setFlag(sourcePosTag, "CATEGORY", this.getFlag(targetPosTag, "CATEGORY"));
            return tmp;
        }
        if (this.isVerb(sourcePosTag) && this.isVerb(targetPosTag)) {
            if (sourcePosTag.length() != targetPosTag.length()) {
                return sourcePosTag;
            }
            tmp = this.setFlag(tmp, "CATEGORY", this.getFlag(targetPosTag, "CATEGORY"));
            tmp = this.setFlag(tmp, "TRANS", this.getFlag(targetPosTag, "TRANS"));
            return tmp;
        }
        if (this.isStopWord(sourcePosTag) && this.isStopWord(targetPosTag)) {
            if (sourcePosTag.length() != targetPosTag.length()) {
                return sourcePosTag;
            }
            tmp = this.setFlag(tmp, "CATEGORY", this.getFlag(targetPosTag, "CATEGORY"));
            tmp = this.setFlag(tmp, "OPTION", this.getFlag(targetPosTag, "OPTION"));
            return tmp;
        }
        tmp = targetPosTag;
        if (this.isStopWord(sourcePosTag) && (this.isVerb(targetPosTag) || this.isNoun(targetPosTag)) || (this.isVerb(sourcePosTag) || this.isNoun(sourcePosTag)) && this.isStopWord(targetPosTag)) {
            if (this.hasPronoun(sourcePosTag)) {
                tmp = this.setFlag(tmp, "PRONOUN", this.getFlag(sourcePosTag, "PRONOUN"));
            }
            return tmp;
        }
        if (this.isVerb(sourcePosTag) && this.isNoun(targetPosTag) || this.isNoun(sourcePosTag) && this.isVerb(targetPosTag)) {
            if (this.hasPronoun(sourcePosTag)) {
                tmp = this.setFlag(tmp, "PRONOUN", this.getFlag(sourcePosTag, "PRONOUN"));
            }
            tmp = this.setFlag(tmp, "CONJ", this.getFlag(sourcePosTag, "CONJ"));
            return tmp;
        }
        return targetPosTag;
    }

    public String setSingle(String postag) {
        return this.setFlag(postag, "NUMBER", '1');
    }

    public String setDual(String postag) {
        return this.setFlag(postag, "NUMBER", '2');
    }

    public String setPlural(String postag) {
        return this.setFlag(postag, "NUMBER", '3');
    }

    public String setMajrour(String postag) {
        if (this.isNoun(postag)) {
            if (this.isDual(postag)) {
                return this.setFlag(postag, "CASE", 'A');
            }
            return this.setFlag(postag, "CASE", 'I');
        }
        return postag;
    }

    public String setMarfou3(String postag) {
        return this.setFlag(postag, "CASE", 'U');
    }

    public String setMansoub(String postag) {
        return this.setFlag(postag, "CASE", 'A');
    }

    public String setTanwin(String postag) {
        return this.setFlag(postag, "PRONOUN", 'n');
    }
}

