/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.tools.ArabicNumbersWordsConstants;
import org.languagetool.tools.ArabicStringTools;
import org.languagetool.tools.ArabicUnitsHelper;

public class ArabicNumbersWords {
    public static String numberToArabicWords(String n) {
        return ArabicNumbersWords.numberToArabicWords(n, false);
    }

    public static String numberToArabicWords(String number, boolean isFeminine) {
        return ArabicNumbersWords.numberToArabicWords(new BigInteger(number), isFeminine);
    }

    public static String numberToArabicWords(String number, boolean isFeminine, boolean isAttached, String inflectionCase) {
        return ArabicNumbersWords.numberToArabicWords(new BigInteger(number), isFeminine, isAttached, inflectionCase);
    }

    public static String numberToArabicWords(BigInteger number, boolean isFeminine) {
        return ArabicNumbersWords.convertToArabic(number, isFeminine).trim();
    }

    public static String numberToArabicWords(BigInteger number, boolean isFeminine, boolean isAttached, String inflectionCase) {
        return ArabicNumbersWords.convertToArabic(number, isFeminine, isAttached, inflectionCase).trim();
    }

    private static String convertToArabic(BigInteger number, boolean isFeminine) {
        return ArabicNumbersWords.convertToArabic(number, isFeminine, false, "");
    }

    private static String convertToArabic(BigInteger number, boolean isFeminine, boolean isAttached, String inflectionCase) {
        if (number.equals(BigInteger.ZERO)) {
            return "\u0635\u0641\u0631";
        }
        if (number.equals(BigInteger.ONE)) {
            return "\u0648\u0627\u062d\u062f";
        }
        if (number.equals(new BigInteger("2"))) {
            return ArabicNumbersWords.getDigitInflectedStatus(2, 0, false, false, inflectionCase);
        }
        BigDecimal tempNumber = new BigDecimal(number);
        StringBuilder result = new StringBuilder();
        int group = 0;
        while (tempNumber.compareTo(BigDecimal.ONE) >= 0) {
            BigDecimal numberToProcess = tempNumber.remainder(new BigDecimal("1000"));
            tempNumber = tempNumber.divide(new BigDecimal("1000"));
            int tempValue = tempNumber.setScale(0, RoundingMode.FLOOR).intValue();
            String groupDescription = ArabicNumbersWords.processArabicGroup(numberToProcess.intValue(), group, tempValue, isFeminine, isAttached, inflectionCase);
            if (!groupDescription.isEmpty()) {
                if (group > 0) {
                    if (result.length() > 0) {
                        result.insert(0, "\u0648");
                    }
                    if (numberToProcess.intValue() != 2 && numberToProcess.remainder(new BigDecimal("100")).intValue() != 1) {
                        if (numberToProcess.compareTo(new BigDecimal("3")) >= 0 && numberToProcess.compareTo(new BigDecimal("10")) <= 0) {
                            result.insert(0, ArabicNumbersWordsConstants.arabicPluralGroups.get(group) + " ");
                        } else if (result.length() > 0) {
                            result.insert(0, ArabicNumbersWordsConstants.arabicAppendedGroup.get(group) + " ");
                        } else {
                            result.insert(0, ArabicNumbersWordsConstants.arabicGroup.get(group) + " ");
                        }
                    }
                }
                result.insert(0, groupDescription + " ");
            }
            group = (short)(group + 1);
        }
        return result.length() > 0 ? result.toString() : "";
    }

    private static String processArabicGroup(int groupNumber, int groupLevel, int remainingNumber, boolean isFeminine) {
        return ArabicNumbersWords.processArabicGroup(groupNumber, groupLevel, remainingNumber, isFeminine, false, "");
    }

    private static String processArabicGroup(int groupNumber, int groupLevel, int remainingNumber, boolean isFeminine, Boolean isAttached, String inflectionCase) {
        int tens = groupNumber % 100;
        int hundreds = groupNumber / 100;
        Object result = "";
        if (hundreds > 0) {
            result = tens == 0 && hundreds == 2 ? (groupLevel == 0 ? ArabicNumbersWords.getDigitHundredJarStatus(hundreds, inflectionCase) : ArabicNumbersWords.getDigitTwosJarStatus(0, inflectionCase, true)) : ArabicNumbersWords.getDigitHundredJarStatus(hundreds, inflectionCase);
        }
        if (tens > 0) {
            if (tens < 20) {
                if (tens == 2 && hundreds == 0 && groupLevel > 0) {
                    result = ArabicNumbersWords.getDigitTwosJarStatus(groupLevel, inflectionCase, false);
                } else {
                    if (!((String)result).isEmpty()) {
                        result = (String)result + " \u0648";
                    }
                    result = tens == 1 && groupLevel > 0 ? (String)result + ArabicNumbersWordsConstants.arabicGroup.get(groupLevel) : (!(tens != 1 && tens != 2 || groupLevel != 0 && groupLevel != -1 || hundreds != 0 || remainingNumber != 0) ? (String)result : (String)result + ArabicNumbersWords.getDigitInflectedStatus(tens, groupLevel, isFeminine, isAttached, inflectionCase));
                }
            } else {
                int ones = tens % 10;
                tens = tens / 10 - 2;
                if (ones > 0) {
                    if (!((String)result).isEmpty()) {
                        result = (String)result + " \u0648";
                    }
                    result = (String)result + ArabicNumbersWords.getDigitInflectedStatus(ones, groupLevel, isFeminine, isAttached, inflectionCase);
                }
                if (!((String)result).isEmpty()) {
                    result = (String)result + " \u0648";
                }
                result = (String)result + ArabicNumbersWords.getDigitTensJarStatus(tens, inflectionCase);
            }
        }
        return result;
    }

    private static String getDigitFeminineStatus(int digit, int groupLevel, boolean isFeminine) {
        return ArabicNumbersWords.getDigitInflectedStatus(digit, groupLevel, isFeminine, false, "");
    }

    private static String getDigitInflectedStatus(int digit, int groupLevel, boolean isFeminine, Boolean isAttached, String inflectionCase) {
        if (inflectionCase.equals("jar")) {
            if (groupLevel == -1 || groupLevel == 0) {
                if (!isFeminine) {
                    return ArabicNumbersWordsConstants.arabicJarOnes.get(digit);
                }
                return ArabicNumbersWordsConstants.arabicJarFeminineOnes.get(digit);
            }
        } else if (groupLevel == -1 || groupLevel == 0) {
            if (!isFeminine) {
                return ArabicNumbersWordsConstants.arabicOnes.get(digit);
            }
            return ArabicNumbersWordsConstants.arabicFeminineOnes.get(digit);
        }
        return ArabicNumbersWordsConstants.arabicOnes.get(digit);
    }

    private static String getDigitTensJarStatus(int digit, String inflectionCase) {
        if (inflectionCase.equals("jar") || inflectionCase.equals("jar")) {
            return ArabicNumbersWordsConstants.arabicJarTens.get(digit);
        }
        return ArabicNumbersWordsConstants.arabicTens.get(digit);
    }

    private static String getDigitHundredJarStatus(int digit, String inflectionCase) {
        if (inflectionCase.equals("jar") || inflectionCase.equals("jar")) {
            return ArabicNumbersWordsConstants.arabicJarHundreds.get(digit);
        }
        return ArabicNumbersWordsConstants.arabicHundreds.get(digit);
    }

    private static String getDigitTwosJarStatus(int digit, String inflectionCase, boolean isAppended) {
        if (!isAppended) {
            if (inflectionCase.equals("jar") || inflectionCase.equals("jar")) {
                return ArabicNumbersWordsConstants.arabicJarTwos.get(digit);
            }
            return ArabicNumbersWordsConstants.arabicTwos.get(digit);
        }
        if (inflectionCase.equals("jar")) {
            return ArabicNumbersWordsConstants.arabicJarAppendedTwos.get(digit);
        }
        return ArabicNumbersWordsConstants.arabicAppendedTwos.get(digit);
    }

    private static boolean hasNoGroup(StringBuilder word) {
        String aword = word.toString();
        return aword.equals("\u0623\u0644\u0641") || aword.equals("\u0623\u0644\u0641\u064a\u0646") || aword.equals("\u0623\u0644\u0641\u0627\u0646");
    }

    public static Integer textToNumber(String text) {
        text = ArabicStringTools.removeTashkeel(text);
        List<String> words = Arrays.asList(text.split(" "));
        return ArabicNumbersWords.textToNumber(words);
    }

    public static Integer textToNumber(List<String> words) {
        Integer total = 0;
        Integer partial = 0;
        for (String word : words) {
            if (!word.isEmpty() && !word.equals("\u0648\u0627\u062d\u062f") && (word.startsWith("\u0648") || word.startsWith("\u0641") || word.startsWith("\u0628") || word.startsWith("\u0643") || word.startsWith("\u0644"))) {
                word = word.substring(1);
            }
            if (!word.equals("\u0648\u0627\u062d\u062f") && word.startsWith("\u0648")) {
                word = word.substring(1);
            }
            if (!ArabicNumbersWords.isNumericWord(word)) continue;
            Integer actualnumber = ArabicNumbersWords.getNumericWordValue(word);
            if (actualnumber % 1000 == 0) {
                if (partial == 0) {
                    partial = 1;
                }
                total = total + partial * actualnumber;
                partial = 0;
                continue;
            }
            partial = partial + ArabicNumbersWords.getNumericWordValue(word);
        }
        total = total + partial;
        return total;
    }

    public static String getUnitForm(Integer n, String unitLemma, String inflection) {
        Map<String, String> phraseMap = ArabicNumbersWords.numberToWordsWithUnitsMap(n, unitLemma, inflection);
        return phraseMap.getOrDefault("unit", "");
    }

    public static String numberToWordsWithUnits(Integer n, String unit, String inflection) {
        Map<String, String> phraseMap = ArabicNumbersWords.numberToWordsWithUnitsMap(n, unit, inflection);
        return phraseMap.getOrDefault("all", "");
    }

    public static Map<String, String> numberToWordsWithUnitsMap(Integer n, String unit, String inflection) {
        boolean feminin = ArabicNumbersWords.isFeminin(unit);
        String unitInflection = "";
        String unitNumber = "";
        String numberPhrase = ArabicNumbersWords.numberToArabicWords(Integer.toString(n), feminin, true, inflection);
        StringBuilder phrase = new StringBuilder("");
        String newUnit = "";
        if (n.equals(0)) {
            newUnit = ArabicNumbersWords.getForm(unit, "plural", "nasb");
            unitInflection = "nasb";
            unitNumber = "plural";
            phrase.append("\u0644\u0627");
            phrase.append(" ");
            phrase.append(newUnit);
        } else if (n.equals(1)) {
            newUnit = ArabicNumbersWords.getForm(unit, "one", inflection);
            unitInflection = inflection;
            unitNumber = "one";
            phrase.append(newUnit);
            phrase.append(" ");
            phrase.append(numberPhrase);
        } else if (n.equals(2)) {
            newUnit = ArabicNumbersWords.getForm(unit, "two", inflection);
            unitInflection = inflection;
            unitNumber = "two";
            phrase.append(newUnit);
        } else if (n % 100 == 1) {
            numberPhraseHundred = ArabicNumbersWords.numberToArabicWords(Integer.toString(n - 1), feminin, true, inflection);
            String newUnitHundred = ArabicNumbersWords.getForm(unit, "one", "jar");
            String newUnitOne = ArabicNumbersWords.getForm(unit, "one", inflection);
            unitInflection = inflection;
            unitNumber = "one";
            newUnit = newUnitOne;
            phrase.append(numberPhraseHundred);
            phrase.append(" ");
            phrase.append(newUnitHundred);
            phrase.append(" ");
            phrase.append("\u0648");
            phrase.append(newUnitOne);
        } else if (n % 100 == 2) {
            numberPhraseHundred = ArabicNumbersWords.numberToArabicWords(Integer.toString(n - 2), feminin, true, inflection);
            String newUnitHundred = ArabicNumbersWords.getForm(unit, "one", "jar");
            String newUnitTwo = ArabicNumbersWords.getForm(unit, "two", inflection);
            unitInflection = inflection;
            unitNumber = "two";
            newUnit = newUnitTwo;
            phrase.append(numberPhraseHundred);
            phrase.append(" ");
            phrase.append(newUnitHundred);
            phrase.append(" ");
            phrase.append("\u0648");
            phrase.append(newUnitTwo);
        } else if (n % 100 >= 3 && n % 100 <= 10) {
            newUnit = ArabicNumbersWords.getForm(unit, "plural", "jar");
            unitInflection = "jar";
            unitNumber = "plural";
            phrase.append(numberPhrase);
            phrase.append(" ");
            phrase.append(newUnit);
        } else if (n % 100 >= 11) {
            newUnit = ArabicNumbersWords.getForm(unit, "one", "nasb");
            unitInflection = "nasb";
            unitNumber = "one";
            phrase.append(numberPhrase);
            phrase.append(" ");
            phrase.append(newUnit);
        } else if (n % 100 == 0) {
            newUnit = ArabicNumbersWords.getForm(unit, "one", "jar");
            unitInflection = "jar";
            unitNumber = "one";
            phrase.append(numberPhrase);
            phrase.append(" ");
            phrase.append(newUnit);
        } else {
            phrase.append(numberPhrase);
            phrase.append(" **");
            phrase.append(unit + "**");
        }
        HashMap<String, String> phraseMap = new HashMap<String, String>();
        phraseMap.put("all", phrase.toString());
        phraseMap.put("phrase", numberPhrase);
        phraseMap.put("unit", newUnit);
        phraseMap.put("number", String.valueOf(n));
        phraseMap.put("unitLemma", unit);
        phraseMap.put("unitNumber", unitNumber);
        phraseMap.put("unitInflection", unitInflection);
        phraseMap.put("inflection", inflection);
        phraseMap.put("feminin", String.valueOf(feminin));
        return phraseMap;
    }

    public static boolean checkNumericPhrase(String phraseInput, boolean feminin, boolean attached, String inflection) {
        String phrase = ArabicStringTools.removeTashkeel(phraseInput);
        Integer x = ArabicNumbersWords.textToNumber(phrase);
        String autoPhrase = ArabicNumbersWords.numberToArabicWords(String.valueOf(x), feminin, attached, inflection);
        autoPhrase = ArabicStringTools.removeTashkeel(autoPhrase);
        return autoPhrase.equals(phrase);
    }

    public static List<String> getSuggestionsNumericPhrase(String phraseInput, boolean feminin, boolean attached, String inflection) {
        ArrayList<String> suggestions = new ArrayList<String>();
        String phrase = ArabicStringTools.removeTashkeel(phraseInput);
        Integer x = ArabicNumbersWords.textToNumber(phrase);
        String autoPhrase = ArabicNumbersWords.numberToArabicWords(String.valueOf(x), feminin, attached, inflection);
        if (!(autoPhrase = ArabicStringTools.removeTashkeel(autoPhrase)).equals(phrase)) {
            if (inflection != null && !inflection.isEmpty()) {
                suggestions.add(autoPhrase);
            } else {
                inflection = "raf3";
                autoPhrase = ArabicNumbersWords.numberToArabicWords(String.valueOf(x), feminin, attached, inflection);
                suggestions.add(autoPhrase);
                inflection = "jar";
                autoPhrase = ArabicNumbersWords.numberToArabicWords(String.valueOf(x), feminin, attached, inflection);
                suggestions.add(autoPhrase);
            }
        }
        return suggestions;
    }

    public static List<Map<String, String>> getSuggestionsNumericPhraseWithUnits(String phraseInput, String unit, boolean feminin, boolean attached, String inflection) {
        ArrayList<Map<String, String>> suggestions = new ArrayList<Map<String, String>>();
        String phrase = ArabicStringTools.removeTashkeel(phraseInput);
        Integer x = ArabicNumbersWords.textToNumber(phrase);
        Map<String, String> autoPhraseMap = ArabicNumbersWords.numberToWordsWithUnitsMap(x, unit, inflection);
        String autoPhrase = ArabicStringTools.removeTashkeel(autoPhraseMap.getOrDefault("phrase", ""));
        if (!autoPhrase.equals(phrase)) {
            if (inflection != null && !inflection.isEmpty()) {
                suggestions.add(autoPhraseMap);
            } else {
                inflection = "raf3";
                autoPhraseMap = ArabicNumbersWords.numberToWordsWithUnitsMap(x, unit, inflection);
                suggestions.add(autoPhraseMap);
                inflection = "jar";
                autoPhraseMap = ArabicNumbersWords.numberToWordsWithUnitsMap(x, unit, inflection);
                suggestions.add(autoPhraseMap);
            }
        }
        return suggestions;
    }

    public static boolean isNumericWord(String word) {
        return ArabicNumbersWordsConstants.NUMBER_WORDS.containsKey(word);
    }

    public static Integer getNumericWordValue(String word) {
        return ArabicNumbersWordsConstants.NUMBER_WORDS.get(word);
    }

    public static boolean isFeminin(String unit) {
        return ArabicUnitsHelper.isFeminin(unit);
    }

    public static String getForm(String unit, String category, String inflection) {
        return ArabicUnitsHelper.getForm(unit, category, inflection);
    }
}

