/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.GeneralCatalan;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.ca.AccentuationCheckRule;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.ComplexAdjectiveConcordanceRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.ReflexiveVerbsRule;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ca.CatalanHybridDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ca.CatalanWordTokenizer;

public class Catalan
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private static final Language GENERAL_CATALAN = new GeneralCatalan();

    public String getName() {
        return "Catalan";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public String getShortName() {
        return "ca";
    }

    public Language getDefaultLanguageVariant() {
        return GENERAL_CATALAN;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ricard Roca"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, CatalanUnpairedBracketsRule.class, UppercaseSentenceStartRule.class, WhitespaceRule.class, LongSentenceRule.class, CatalanWordRepeatRule.class, MorfologikCatalanSpellerRule.class, CatalanUnpairedQuestionMarksRule.class, CatalanUnpairedExclamationMarksRule.class, AccentuationCheckRule.class, ComplexAdjectiveConcordanceRule.class, CatalanWrongWordInContextRule.class, ReflexiveVerbsRule.class, SimpleReplaceVerbsRule.class, SimpleReplaceRule.class);
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new CatalanTagger();
        }
        return this.tagger;
    }

    public final Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new CatalanSynthesizer();
        }
        return this.synthesizer;
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new CatalanHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public final Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new CatalanWordTokenizer();
        }
        return this.wordTokenizer;
    }
}

