/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.ca.CatalanTagger;

public class SimpleReplaceVerbsRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceVerbsRule.load((String)"/ca/replace_verbs.txt");
    private static final Locale CA_LOCALE = new Locale("CA");
    private static final String endings = "a|\u00e0|ada|ades|am|ant|ar|ara|ar\u00e0|aran|ar\u00e0s|ar\u00e9|arem|\u00e0rem|aren|ares|areu|\u00e0reu|aria|ar\u00edem|arien|aries|ar\u00edeu|\u00e0s|\u00e0ssem|assen|asses|\u00e0sseu|\u00e0ssim|assin|assis|\u00e0ssiu|at|ats|au|ava|\u00e0vem|aven|aves|\u00e0veu|e|em|en|es|\u00e9s|\u00e9ssem|essen|esses|\u00e9sseu|\u00e9ssim|essin|essis|\u00e9ssiu|eu|i|\u00ed|in|is|o|\u00efs";
    private static final Pattern desinencies_1conj_0 = Pattern.compile("(.+?)(a|\u00e0|ada|ades|am|ant|ar|ara|ar\u00e0|aran|ar\u00e0s|ar\u00e9|arem|\u00e0rem|aren|ares|areu|\u00e0reu|aria|ar\u00edem|arien|aries|ar\u00edeu|\u00e0s|\u00e0ssem|assen|asses|\u00e0sseu|\u00e0ssim|assin|assis|\u00e0ssiu|at|ats|au|ava|\u00e0vem|aven|aves|\u00e0veu|e|em|en|es|\u00e9s|\u00e9ssem|essen|esses|\u00e9sseu|\u00e9ssim|essin|essis|\u00e9ssiu|eu|i|\u00ed|in|is|o|\u00efs)");
    private static final Pattern desinencies_1conj_1 = Pattern.compile("(.+)(a|\u00e0|ada|ades|am|ant|ar|ara|ar\u00e0|aran|ar\u00e0s|ar\u00e9|arem|\u00e0rem|aren|ares|areu|\u00e0reu|aria|ar\u00edem|arien|aries|ar\u00edeu|\u00e0s|\u00e0ssem|assen|asses|\u00e0sseu|\u00e0ssim|assin|assis|\u00e0ssiu|at|ats|au|ava|\u00e0vem|aven|aves|\u00e0veu|e|em|en|es|\u00e9s|\u00e9ssem|essen|esses|\u00e9sseu|\u00e9ssim|essin|essis|\u00e9ssiu|eu|i|\u00ed|in|is|o|\u00efs)");
    private CatalanTagger tagger;
    private CatalanSynthesizer synth;

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceVerbsRule(ResourceBundle messages, Language language) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setIgnoreTaggedWords();
        this.tagger = (CatalanTagger)language.getTagger();
        this.synth = (CatalanSynthesizer)language.getSynthesizer();
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_VERBS";
    }

    public String getDescription() {
        return "Detecta verbs incorrectes i proposa suggeriments de canvi";
    }

    public String getShort() {
        return "Verb incorrecte";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Verb incorrecte.";
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            String originalTokenStr = tokenReadings.getToken();
            if (this.ignoreTaggedWords && tokenReadings.isTagged()) continue;
            String tokenString = originalTokenStr.toLowerCase(this.getLocale());
            AnalyzedTokenReadings analyzedTokenReadings = null;
            String infinitive = null;
            for (int i = 0; i < 2 && analyzedTokenReadings == null; ++i) {
                Matcher m = i == 0 ? desinencies_1conj_0.matcher(tokenString) : desinencies_1conj_1.matcher(tokenString);
                if (!m.matches()) continue;
                String lexeme = m.group(1);
                String desinence = m.group(2);
                if (desinence.startsWith("e") || desinence.startsWith("\u00e9") || desinence.startsWith("i") || desinence.startsWith("\u00ef")) {
                    if (lexeme.endsWith("c")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("\u00e7");
                    } else if (lexeme.endsWith("qu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("c");
                    } else if (lexeme.endsWith("g")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("j");
                    } else if (lexeme.endsWith("g\u00fc")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("gu");
                    } else if (lexeme.endsWith("gu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("g");
                    }
                }
                if (desinence.startsWith("\u00ef")) {
                    desinence = "i" + desinence.substring(1, desinence.length());
                }
                if (!wrongWords.containsKey(infinitive = lexeme.concat("ar"))) continue;
                List<String> wordAsArray = Arrays.asList("cant".concat(desinence));
                List<AnalyzedTokenReadings> analyzedTokenReadingsList = null;
                try {
                    analyzedTokenReadingsList = this.tagger.tag(wordAsArray);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not tag sentence: " + wordAsArray, e);
                }
                if (analyzedTokenReadingsList == null) continue;
                analyzedTokenReadings = analyzedTokenReadingsList.get(0);
            }
            if (analyzedTokenReadings == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            String[] synthesized = null;
            List<String> replacementInfinitives = wrongWords.get(infinitive);
            for (String replacementInfinitive : replacementInfinitives) {
                if (replacementInfinitive.startsWith("(")) {
                    possibleReplacements.add(replacementInfinitive);
                    continue;
                }
                String[] parts = replacementInfinitive.split(" ");
                AnalyzedToken infinitiveAsAnTkn = new AnalyzedToken(parts[0], "V.*", parts[0]);
                for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
                    try {
                        synthesized = this.synth.synthesize(infinitiveAsAnTkn, analyzedToken.getPOSTag());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not synthesize: " + infinitiveAsAnTkn + " with tag " + analyzedToken.getPOSTag(), e);
                    }
                    for (String s : synthesized) {
                        for (int j = 1; j < parts.length; ++j) {
                            s = s.concat(" ").concat(parts[j]);
                        }
                        if (possibleReplacements.contains(s)) continue;
                        possibleReplacements.add(s);
                    }
                }
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, possibleReplacements, sentence);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

