/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Catalan;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ca.CatalanSynthesizer;

public class CatalanNumberSpellerFilter
extends RuleFilter {
    private Language language = new Catalan();
    private CatalanSynthesizer synth = (CatalanSynthesizer)this.language.getSynthesizer();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        String spelledNumber;
        String strToSpell = this.getRequired("number_to_spell", arguments).replaceAll("\\.", "");
        if (this.getRequired("gender", arguments).contentEquals("feminine")) {
            strToSpell = "feminine " + strToSpell;
        }
        if (!(spelledNumber = this.synth.getSpelledNumber(strToSpell)).isEmpty() && spelledNumber.replaceAll("-i-", " ").replaceAll("-", " ").split(" ").length < 4) {
            String message = match.getMessage();
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            ruleMatch.setSuggestedReplacement(spelledNumber);
            return ruleMatch;
        }
        return null;
    }
}

