/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.loadFromPath((String[])new String[]{"/ca/replace.txt", "/ca/replace_custom.txt"});
    private static final Locale CA_LOCALE = new Locale("CA");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setIgnoreTaggedWords();
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "Detecta paraules incorrectes i proposa suggeriments de canvi";
    }

    public String getShort() {
        return "Paraula incorrecta";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        if (replacements.size() > 0) {
            return "\u00bfVol\u00edeu dir \u00ab" + replacements.get(0) + "\u00bb?";
        }
        return this.getShort();
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }
}

