/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Catalan;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceAnglicism
extends AbstractSimpleReplaceRule2 {
    private static final String FILE_NAME = "/ca/replace_anglicism.txt";
    private static final Locale CA_LOCALE = new Locale("ca");

    public SimpleReplaceAnglicism(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Catalan());
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_ANGLICISM";
    }

    public String getDescription() {
        return "Anglicismes innecessaris";
    }

    public String getShort() {
        return "Anglicisme innecessari";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public List<String> getFileNames() {
        return Arrays.asList(FILE_NAME);
    }

    public String getMessage() {
        return "Anglicisme innecessari. Considereu fer servir una altra paraula.";
    }

    public URL getUrl() {
        return null;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP") || atr.isImmunized() || atr.isIgnoredBySpeller();
    }
}

