/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Catalan;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatBeginningRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.CheckCaseRule;
import org.languagetool.rules.ca.CompoundRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.PronomFebleDuplicateRule;
import org.languagetool.rules.ca.ReplaceOperationNamesRule;
import org.languagetool.rules.ca.SimpleReplaceAdverbsMent;
import org.languagetool.rules.ca.SimpleReplaceAnglicism;
import org.languagetool.rules.ca.SimpleReplaceBalearicRule;
import org.languagetool.rules.ca.SimpleReplaceDNVColloquialRule;
import org.languagetool.rules.ca.SimpleReplaceDNVRule;
import org.languagetool.rules.ca.SimpleReplaceDNVSecondaryRule;
import org.languagetool.rules.ca.SimpleReplaceDiacriticsIEC;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;

public class ValencianCatalan
extends Catalan {
    @Override
    public String getName() {
        return "Catalan (Valencian)";
    }

    @Override
    public String[] getCountries() {
        return new String[]{"ES"};
    }

    public String getVariant() {
        return "valencia";
    }

    @Override
    @NotNull
    public Tagger createDefaultTagger() {
        return CatalanTagger.INSTANCE_VAL;
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"A parer seu<marker> ,</marker> no era veritat."), Example.fixed((String)"A parer seu<marker>,</marker> no era veritat.")), new DoublePunctuationRule(messages), new CatalanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Preus de venda al p\u00fablic. <marker>han</marker> pujat molt."), Example.fixed((String)"Preus de venda al p\u00fablic. <marker>Han</marker> pujat molt.")), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 45), new CatalanWordRepeatRule(messages, this), new MorfologikCatalanSpellerRule(messages, this, userConfig, altLanguages), new CatalanUnpairedQuestionMarksRule(messages, this), new CatalanUnpairedExclamationMarksRule(messages, this), new CatalanWrongWordInContextRule(messages), new SimpleReplaceVerbsRule(messages, this), new SimpleReplaceBalearicRule(messages), new SimpleReplaceRule(messages), new ReplaceOperationNamesRule(messages, this), new CheckCaseRule(messages, this), new CompoundRule(messages), new SimpleReplaceDNVRule(messages, this), new SimpleReplaceDNVColloquialRule(messages, this), new SimpleReplaceDNVSecondaryRule(messages, this), new SimpleReplaceDiacriticsIEC(messages), new SimpleReplaceAnglicism(messages), new PronomFebleDuplicateRule(messages), new SimpleReplaceAdverbsMent(messages), new CatalanWordRepeatBeginningRule(messages, this)});
    }

    public List<String> getDefaultEnabledRulesForVariant() {
        List<String> rules = Arrays.asList("EXIGEIX_VERBS_VALENCIANS", "EXIGEIX_ACCENTUACIO_VALENCIANA", "EXIGEIX_POSSESSIUS_U", "EXIGEIX_VERBS_EIX", "EXIGEIX_VERBS_ISC", "PER_PER_A_INFINITIU", "FINS_EL_AVL");
        return Collections.unmodifiableList(rules);
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        List<String> rules = Arrays.asList("EXIGEIX_VERBS_CENTRAL", "EXIGEIX_ACCENTUACIO_GENERAL", "EXIGEIX_POSSESSIUS_V", "EVITA_PRONOMS_VALENCIANS", "EVITA_DEMOSTRATIUS_EIXE", "VOCABULARI_VALENCIA", "EXIGEIX_US", "FINS_EL_GENERAL");
        return Collections.unmodifiableList(rules);
    }
}

