/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class CatalanWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADD_ADVERBS = new HashSet<String>();
    private static final Set<String> CONTRAST_CONJ = new HashSet<String>();
    private static final Set<String> CAUSE_CONJ = new HashSet<String>();
    private static final Set<String> EMPHASIS_ADVERBS = new HashSet<String>();
    private static final Set<String> EXPLAIN_ADVERBS = new HashSet<String>();
    private static final Set<String> PERSONAL_PRONOUNS = new HashSet<String>();
    private static final List<String> ADD_EXPRESSIONS = Arrays.asList("Aix\u00ed mateix", "A m\u00e9s a m\u00e9s");
    private static final List<String> CONTRAST_EXPRESSIONS = Arrays.asList("Aix\u00ed i tot", "D'altra banda", "Per altra part");
    private static final List<String> CAUSE_EXPRESSIONS = Arrays.asList("Ja que", "Per tal com", "Pel fet que", "Puix que");
    private static final List<String> EXCEPCIONS_START = Arrays.asList("el", "la", "els", "les", "punt", "article", "m\u00f2dul", "part", "sessi\u00f3", "unitat", "tema");

    public CatalanWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"Per\u00f2 el carrer \u00e9s tot modernista. <marker>Per\u00f2</marker> t\u00e9 nom de poeta."), Example.fixed((String)"Per\u00f2 el carrer \u00e9s tot modernista. Aix\u00ed i tot, t\u00e9 nom de poeta."));
    }

    public String getId() {
        return "CATALAN_WORD_REPEAT_BEGINNING_RULE";
    }

    public boolean isException(String token) {
        return super.isException(token) || Character.isDigit(token.charAt(0)) || EXCEPCIONS_START.contains(token.toLowerCase());
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        if (token.hasPosTag("RG") || token.hasPosTag("LOC_ADV")) {
            return true;
        }
        String tok = token.getToken();
        return ADD_ADVERBS.contains(tok) || CONTRAST_CONJ.contains(tok) || EMPHASIS_ADVERBS.contains(tok) || EXPLAIN_ADVERBS.contains(tok) || CAUSE_CONJ.contains(tok);
    }

    protected List<String> getSuggestions(AnalyzedTokenReadings token) {
        String tok = token.getToken();
        String lowerTok = tok.toLowerCase();
        if (PERSONAL_PRONOUNS.contains(lowerTok)) {
            return Arrays.asList("A m\u00e9s a m\u00e9s, " + lowerTok, "Igualment, " + lowerTok, "No sols aix\u00f3, sin\u00f3 que " + lowerTok);
        }
        if (ADD_ADVERBS.contains(tok)) {
            List<String> addSuggestions = this.getDifferentAdverbsOfSameCategory(tok, ADD_ADVERBS);
            addSuggestions.addAll(ADD_EXPRESSIONS);
            return addSuggestions;
        }
        if (CONTRAST_CONJ.contains(tok)) {
            ArrayList<String> contrastSuggestions = new ArrayList<String>();
            contrastSuggestions.addAll(CONTRAST_EXPRESSIONS);
            return contrastSuggestions;
        }
        if (EMPHASIS_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EMPHASIS_ADVERBS);
        }
        if (EXPLAIN_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EXPLAIN_ADVERBS);
        }
        if (CAUSE_CONJ.contains(tok)) {
            List<String> causeSuggestions = this.getDifferentAdverbsOfSameCategory(tok, CAUSE_CONJ);
            causeSuggestions.addAll(CAUSE_EXPRESSIONS);
            return causeSuggestions;
        }
        return Collections.emptyList();
    }

    private List<String> getDifferentAdverbsOfSameCategory(String adverb, Set<String> adverbsOfCategory) {
        return adverbsOfCategory.stream().filter(adv -> !adv.equals(adverb)).collect(Collectors.toList());
    }

    static {
        ADD_ADVERBS.add("Igualment");
        ADD_ADVERBS.add("Tamb\u00e9");
        ADD_ADVERBS.add("Addicionalment");
        CONTRAST_CONJ.add("Per\u00f2");
        CONTRAST_CONJ.add("Emper\u00f2");
        CONTRAST_CONJ.add("Mes");
        CAUSE_CONJ.add("Perqu\u00e8");
        CAUSE_CONJ.add("Car");
        EMPHASIS_ADVERBS.add("\u00d2bviamente");
        EMPHASIS_ADVERBS.add("Clarament");
        EMPHASIS_ADVERBS.add("Absolutament");
        EMPHASIS_ADVERBS.add("Definitivament");
        EXPLAIN_ADVERBS.add("Espec\u00edficament");
        EXPLAIN_ADVERBS.add("Concretament");
        EXPLAIN_ADVERBS.add("Particularment");
        EXPLAIN_ADVERBS.add("Precisament");
        PERSONAL_PRONOUNS.add("jo");
        PERSONAL_PRONOUNS.add("tu");
        PERSONAL_PRONOUNS.add("ell");
        PERSONAL_PRONOUNS.add("ella");
        PERSONAL_PRONOUNS.add("nosaltres");
        PERSONAL_PRONOUNS.add("vosaltres");
        PERSONAL_PRONOUNS.add("ells");
        PERSONAL_PRONOUNS.add("elles");
        PERSONAL_PRONOUNS.add("vost\u00e8");
        PERSONAL_PRONOUNS.add("vost\u00e8s");
        PERSONAL_PRONOUNS.add("vost\u00e9");
        PERSONAL_PRONOUNS.add("vost\u00e9s");
        PERSONAL_PRONOUNS.add("v\u00f3s");
    }
}

