/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.AbstractFindSuggestionsFilter;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;

public class FindSuggestionsFilter
extends AbstractFindSuggestionsFilter {
    protected static final String DICT_FILENAME = "/ca/ca-ES.dict";
    protected static MorfologikSpeller speller;
    public static final String[] LemmasToIgnore;
    public static final String[] LemmasToAllow;

    public FindSuggestionsFilter() throws IOException {
        if (speller == null && JLanguageTool.getDataBroker().resourceExists(DICT_FILENAME)) {
            speller = new MorfologikSpeller(DICT_FILENAME);
        }
    }

    protected Tagger getTagger() {
        return CatalanTagger.INSTANCE_CAT;
    }

    protected List<String> getSpellingSuggestions(AnalyzedTokenReadings atr) throws IOException {
        return speller.findSimilarWords(atr.getToken());
    }

    protected boolean isSuggestionException(AnalyzedTokenReadings analyzedSuggestion) {
        return analyzedSuggestion.hasAnyLemma(LemmasToIgnore) && !analyzedSuggestion.hasAnyLemma(LemmasToAllow);
    }

    static {
        LemmasToIgnore = new String[]{"enterar", "sentar", "conseguir", "alcan\u00e7ar"};
        LemmasToAllow = new String[]{"enter", "sentir"};
    }
}

