/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.rules.UnsyncStack;

public class CatalanUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> CA_START_SYMBOLS = Arrays.asList("[", "(", "{", "\u201c", "\u00ab", "\"", "'", "\u2018");
    private static final List<String> CA_END_SYMBOLS = Arrays.asList("]", ")", "}", "\u201d", "\u00bb", "\"", "'", "\u2019");
    private static final Pattern VALID_BEFORE_CLOSING_PARENTHESIS = Pattern.compile("\\d+|[a-zA-Z]", 64);
    private static final Pattern NUMBER = Pattern.compile("\\d[\\d., ]+\\d|\\d{1,2}", 64);

    public CatalanUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, CA_START_SYMBOLS, CA_END_SYMBOLS);
    }

    protected boolean isNoException(String tokenStr, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace, UnsyncStack<SymbolLocator> symbolStack) {
        boolean superException;
        if (i < 1) {
            return true;
        }
        if ((tokenStr.equals("\u2019") || tokenStr.equals("'")) && (tokens[i].hasPosTagStartingWith("N") || tokens[i].hasPosTagStartingWith("A"))) {
            return false;
        }
        boolean bl = superException = !super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace, symbolStack);
        if (superException) {
            return false;
        }
        if (("\"".equals(tokenStr) || "'".equals(tokenStr)) && NUMBER.matcher(tokens[i - 1].getToken()).matches() && !tokens[i].isWhitespaceBefore() && (i > 2 && (tokens[i - 2].getToken().contains("\u00ba") || tokens[i - 2].getToken().contains("\u00b0")) || i > 4 && (tokens[i - 4].getToken().contains("\u00ba") || tokens[i - 4].getToken().contains("\u00b0")))) {
            return false;
        }
        if (i == 1 && tokenStr.equals("\u00bb")) {
            return false;
        }
        if (i > 1 && tokenStr.equals(")")) {
            Matcher mValidBeforeClosingParenthesis;
            boolean isThereOpeningParenthesis = false;
            int k = 1;
            while (i - k > 0 && !tokens[i - k].getToken().equals(")")) {
                if (tokens[i - k].getToken().equals("(")) {
                    isThereOpeningParenthesis = true;
                    break;
                }
                ++k;
            }
            if (!isThereOpeningParenthesis && (mValidBeforeClosingParenthesis = VALID_BEFORE_CLOSING_PARENTHESIS.matcher(tokens[i - 1].getToken())).matches()) {
                return false;
            }
        }
        return true;
    }
}

