/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tools.StringTools;

public class SimpleReplaceVerbsRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceVerbsRule.loadFromPath((String)"/ca/replace_verbs.txt");
    private static final Locale CA_LOCALE = new Locale("CA");
    private static final String endings = "a|ada|ades|am|ant|ar|ara|aran|arem|aren|ares|areu|aria|arien|aries|ar\u00e0|ar\u00e0s|ar\u00e9|ar\u00edem|ar\u00edeu|assen|asses|assin|assis|at|ats|au|ava|aven|aves|e|ec|ega|eguda|egudes|eguem|eguen|eguera|egueren|egueres|egues|eguessen|eguesses|eguessin|eguessis|egueu|egui|eguin|eguis|egut|eguts|egu\u00e9|egu\u00e9rem|egu\u00e9reu|egu\u00e9s|egu\u00e9ssem|egu\u00e9sseu|egu\u00e9ssim|egu\u00e9ssiu|egu\u00ed|eix|eixem|eixen|eixent|eixeran|eixerem|eixeren|eixeres|eixereu|eixeria|eixerien|eixeries|eixer\u00e0|eixer\u00e0s|eixer\u00e9|eixer\u00edem|eixer\u00edeu|eixes|eixessen|eixesses|eixessin|eixessis|eixeu|eixi|eixia|eixien|eixies|eixin|eixis|eixo|eix\u00e9|eix\u00e9rem|eix\u00e9reu|eix\u00e9s|eix\u00e9ssem|eix\u00e9sseu|eix\u00e9ssim|eix\u00e9ssiu|eix\u00ed|eix\u00edem|eix\u00edeu|em|en|es|esc|esca|escuda|escudes|escut|escuts|esquem|esquen|esquera|esqueren|esqueres|esques|esquessen|esquesses|esquessin|esquessis|esqueu|esqui|esquin|esquis|esqu\u00e9|esqu\u00e9rem|esqu\u00e9reu|esqu\u00e9s|esqu\u00e9ssem|esqu\u00e9sseu|esqu\u00e9ssim|esqu\u00e9ssiu|esqu\u00ed|essen|esses|essin|essis|eu|i|ia|ida|ides|ien|ies|iguem|igueu|im|in|int|ir|ira|iran|irem|iren|ires|ireu|iria|irien|iries|ir\u00e0|ir\u00e0s|ir\u00e9|ir\u00edem|ir\u00edeu|is|isc|isca|isquen|isques|issen|isses|issin|issis|it|its|iu|ix|ixen|ixes|o|\u00e0|\u00e0rem|\u00e0reu|\u00e0s|\u00e0ssem|\u00e0sseu|\u00e0ssim|\u00e0ssiu|\u00e0vem|\u00e0veu|\u00e9ixer|\u00e9s|\u00e9ssem|\u00e9sseu|\u00e9ssim|\u00e9ssiu|\u00ed|\u00edem|\u00edeu|\u00edrem|\u00edreu|\u00eds|\u00edssem|\u00edsseu|\u00edssim|\u00edssiu|\u00efs";
    private static final Pattern desinencies_1conj_0 = Pattern.compile("(.+?)(a|ada|ades|am|ant|ar|ara|aran|arem|aren|ares|areu|aria|arien|aries|ar\u00e0|ar\u00e0s|ar\u00e9|ar\u00edem|ar\u00edeu|assen|asses|assin|assis|at|ats|au|ava|aven|aves|e|ec|ega|eguda|egudes|eguem|eguen|eguera|egueren|egueres|egues|eguessen|eguesses|eguessin|eguessis|egueu|egui|eguin|eguis|egut|eguts|egu\u00e9|egu\u00e9rem|egu\u00e9reu|egu\u00e9s|egu\u00e9ssem|egu\u00e9sseu|egu\u00e9ssim|egu\u00e9ssiu|egu\u00ed|eix|eixem|eixen|eixent|eixeran|eixerem|eixeren|eixeres|eixereu|eixeria|eixerien|eixeries|eixer\u00e0|eixer\u00e0s|eixer\u00e9|eixer\u00edem|eixer\u00edeu|eixes|eixessen|eixesses|eixessin|eixessis|eixeu|eixi|eixia|eixien|eixies|eixin|eixis|eixo|eix\u00e9|eix\u00e9rem|eix\u00e9reu|eix\u00e9s|eix\u00e9ssem|eix\u00e9sseu|eix\u00e9ssim|eix\u00e9ssiu|eix\u00ed|eix\u00edem|eix\u00edeu|em|en|es|esc|esca|escuda|escudes|escut|escuts|esquem|esquen|esquera|esqueren|esqueres|esques|esquessen|esquesses|esquessin|esquessis|esqueu|esqui|esquin|esquis|esqu\u00e9|esqu\u00e9rem|esqu\u00e9reu|esqu\u00e9s|esqu\u00e9ssem|esqu\u00e9sseu|esqu\u00e9ssim|esqu\u00e9ssiu|esqu\u00ed|essen|esses|essin|essis|eu|i|ia|ida|ides|ien|ies|iguem|igueu|im|in|int|ir|ira|iran|irem|iren|ires|ireu|iria|irien|iries|ir\u00e0|ir\u00e0s|ir\u00e9|ir\u00edem|ir\u00edeu|is|isc|isca|isquen|isques|issen|isses|issin|issis|it|its|iu|ix|ixen|ixes|o|\u00e0|\u00e0rem|\u00e0reu|\u00e0s|\u00e0ssem|\u00e0sseu|\u00e0ssim|\u00e0ssiu|\u00e0vem|\u00e0veu|\u00e9ixer|\u00e9s|\u00e9ssem|\u00e9sseu|\u00e9ssim|\u00e9ssiu|\u00ed|\u00edem|\u00edeu|\u00edrem|\u00edreu|\u00eds|\u00edssem|\u00edsseu|\u00edssim|\u00edssiu|\u00efs)");
    private static final Pattern desinencies_1conj_1 = Pattern.compile("(.+)(a|ada|ades|am|ant|ar|ara|aran|arem|aren|ares|areu|aria|arien|aries|ar\u00e0|ar\u00e0s|ar\u00e9|ar\u00edem|ar\u00edeu|assen|asses|assin|assis|at|ats|au|ava|aven|aves|e|ec|ega|eguda|egudes|eguem|eguen|eguera|egueren|egueres|egues|eguessen|eguesses|eguessin|eguessis|egueu|egui|eguin|eguis|egut|eguts|egu\u00e9|egu\u00e9rem|egu\u00e9reu|egu\u00e9s|egu\u00e9ssem|egu\u00e9sseu|egu\u00e9ssim|egu\u00e9ssiu|egu\u00ed|eix|eixem|eixen|eixent|eixeran|eixerem|eixeren|eixeres|eixereu|eixeria|eixerien|eixeries|eixer\u00e0|eixer\u00e0s|eixer\u00e9|eixer\u00edem|eixer\u00edeu|eixes|eixessen|eixesses|eixessin|eixessis|eixeu|eixi|eixia|eixien|eixies|eixin|eixis|eixo|eix\u00e9|eix\u00e9rem|eix\u00e9reu|eix\u00e9s|eix\u00e9ssem|eix\u00e9sseu|eix\u00e9ssim|eix\u00e9ssiu|eix\u00ed|eix\u00edem|eix\u00edeu|em|en|es|esc|esca|escuda|escudes|escut|escuts|esquem|esquen|esquera|esqueren|esqueres|esques|esquessen|esquesses|esquessin|esquessis|esqueu|esqui|esquin|esquis|esqu\u00e9|esqu\u00e9rem|esqu\u00e9reu|esqu\u00e9s|esqu\u00e9ssem|esqu\u00e9sseu|esqu\u00e9ssim|esqu\u00e9ssiu|esqu\u00ed|essen|esses|essin|essis|eu|i|ia|ida|ides|ien|ies|iguem|igueu|im|in|int|ir|ira|iran|irem|iren|ires|ireu|iria|irien|iries|ir\u00e0|ir\u00e0s|ir\u00e9|ir\u00edem|ir\u00edeu|is|isc|isca|isquen|isques|issen|isses|issin|issis|it|its|iu|ix|ixen|ixes|o|\u00e0|\u00e0rem|\u00e0reu|\u00e0s|\u00e0ssem|\u00e0sseu|\u00e0ssim|\u00e0ssiu|\u00e0vem|\u00e0veu|\u00e9ixer|\u00e9s|\u00e9ssem|\u00e9sseu|\u00e9ssim|\u00e9ssiu|\u00ed|\u00edem|\u00edeu|\u00edrem|\u00edreu|\u00eds|\u00edssem|\u00edsseu|\u00edssim|\u00edssiu|\u00efs)");
    private final CatalanTagger tagger;
    private final CatalanSynthesizer synth;

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceVerbsRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setIgnoreTaggedWords();
        this.tagger = (CatalanTagger)language.getTagger();
        this.synth = (CatalanSynthesizer)language.getSynthesizer();
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_VERBS";
    }

    public String getDescription() {
        return "Detecta verbs incorrectes i proposa suggeriments de canvi";
    }

    public String getShort() {
        return "Verb incorrecte";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Verb incorrecte.";
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            List<String> wordAsArray;
            String originalTokenStr = tokenReadings.getToken();
            if (this.ignoreTaggedWords && tokenReadings.isTagged()) continue;
            String tokenString = originalTokenStr.toLowerCase(this.getLocale());
            AnalyzedTokenReadings analyzedTokenReadings = null;
            String infinitive = null;
            for (int i = 0; i < 2 && analyzedTokenReadings == null; ++i) {
                List<AnalyzedTokenReadings> analyzedTokenReadingsList;
                Matcher m = i == 0 ? desinencies_1conj_0.matcher(tokenString) : desinencies_1conj_1.matcher(tokenString);
                if (!m.matches()) continue;
                String lexeme = m.group(1);
                String desinence = m.group(2);
                if (desinence.startsWith("e") || desinence.startsWith("\u00e9") || desinence.startsWith("i") || desinence.startsWith("\u00ef")) {
                    if (lexeme.endsWith("c")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("\u00e7");
                    } else if (lexeme.endsWith("qu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("c");
                    } else if (lexeme.endsWith("g")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("j");
                    } else if (lexeme.endsWith("g\u00fc")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("gu");
                    } else if (lexeme.endsWith("gu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("g");
                    }
                }
                if (desinence.startsWith("\u00ef")) {
                    desinence = "i" + desinence.substring(1);
                }
                if (wrongWords.containsKey(infinitive = lexeme.concat("ar")) && (analyzedTokenReadingsList = this.tagger.tag(wordAsArray = Arrays.asList("cant".concat(desinence)))).get(0).getAnalyzedToken(0).getPOSTag() != null) {
                    analyzedTokenReadings = analyzedTokenReadingsList.get(0);
                }
                if (analyzedTokenReadings == null && wrongWords.containsKey(infinitive = lexeme.concat("ir")) && (analyzedTokenReadingsList = this.tagger.tag(wordAsArray = Arrays.asList("serv".concat(desinence)))).get(0).getAnalyzedToken(0).getPOSTag() != null) {
                    analyzedTokenReadings = analyzedTokenReadingsList.get(0);
                }
                if (analyzedTokenReadings == null && lexeme.endsWith("g") && wrongWords.containsKey(infinitive = lexeme.concat("uir")) && (analyzedTokenReadingsList = this.tagger.tag(wordAsArray = Arrays.asList("serv".concat(desinence)))).get(0).getAnalyzedToken(0).getPOSTag() != null) {
                    analyzedTokenReadings = analyzedTokenReadingsList.get(0);
                }
                if (analyzedTokenReadings != null || !wrongWords.containsKey(infinitive = lexeme.concat("\u00e8ixer"))) continue;
                wordAsArray = Arrays.asList("con".concat(desinence));
                analyzedTokenReadingsList = this.tagger.tag(wordAsArray);
                if (analyzedTokenReadingsList.get(0).getAnalyzedToken(0).getPOSTag() != null) {
                    analyzedTokenReadings = analyzedTokenReadingsList.get(0);
                    continue;
                }
                List<String> wordAsArray2 = Arrays.asList("desmer".concat(desinence));
                List<AnalyzedTokenReadings> analyzedTokenReadingsList2 = this.tagger.tag(wordAsArray2);
                if (analyzedTokenReadingsList2.get(0).getAnalyzedToken(0).getPOSTag() == null) continue;
                analyzedTokenReadings = analyzedTokenReadingsList2.get(0);
            }
            if (analyzedTokenReadings == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            List<String> replacementInfinitives = wrongWords.get(infinitive);
            wordAsArray = replacementInfinitives.iterator();
            while (wordAsArray.hasNext()) {
                String replacementInfinitive = wordAsArray.next();
                if (replacementInfinitive.startsWith("(")) {
                    possibleReplacements.add(StringTools.preserveCase((String)replacementInfinitive, (String)originalTokenStr));
                    continue;
                }
                String[] parts = replacementInfinitive.split(" ");
                AnalyzedToken infinitiveAsAnTkn = new AnalyzedToken(parts[0], "V.*", parts[0]);
                for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
                    String[] synthesized;
                    try {
                        String posTag = analyzedToken.getPOSTag();
                        if (infinitiveAsAnTkn.getLemma().equals("haver")) {
                            posTag = "VA" + posTag.substring(2);
                        }
                        synthesized = this.synth.synthesize(infinitiveAsAnTkn, posTag);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not synthesize: " + infinitiveAsAnTkn + " with tag " + analyzedToken.getPOSTag(), e);
                    }
                    for (String s : synthesized) {
                        for (int j = 1; j < parts.length; ++j) {
                            s = s.concat(" ").concat(parts[j]);
                        }
                        if (possibleReplacements.contains(s)) continue;
                        possibleReplacements.add(StringTools.preserveCase((String)s, (String)originalTokenStr));
                    }
                }
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, possibleReplacements, sentence, infinitive);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

