/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class AdjustPronounsFilter
extends RuleFilter {
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord;
        ArrayList<String> replacements = new ArrayList<String>();
        List<String> actions = Arrays.asList(this.getRequired("actions", arguments).split(","));
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        String newLemma = this.getOptional("newLemma", arguments);
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        int toLeft = 0;
        boolean done = false;
        String firstVerb = "";
        String firstVerbPersonaNumber = "";
        String firstVerbPersonaNumberImperative = "";
        String replacementVerb = "";
        int firstVerbPos = 0;
        boolean inPronouns = false;
        boolean firstVerbInflected = false;
        while (!done && posWord - toLeft > 0) {
            AnalyzedTokenReadings currentTkn = tokens[posWord - toLeft];
            String currentTknStr = currentTkn.getToken();
            if (toLeft == 0 && newLemma != null) {
                AnalyzedToken at;
                String[] synthForms;
                ArrayList<String> postags = new ArrayList<String>();
                for (AnalyzedToken reading : currentTkn) {
                    if (reading.getPOSTag() == null || !reading.getPOSTag().startsWith("V")) continue;
                    postags.add(reading.getPOSTag());
                }
                String targetPostag = synth.getTargetPosTag(postags, "");
                if (!targetPostag.isEmpty() && (synthForms = synth.synthesize(at = new AnalyzedToken(currentTknStr, targetPostag, newLemma), targetPostag)) != null && synthForms.length > 0) {
                    replacementVerb = synthForms[0];
                }
            }
            boolean isVerb = currentTkn.hasPosTagStartingWith("V");
            boolean isPronoun = currentTkn.matchesPosTagRegex("P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
            if (isPronoun) {
                inPronouns = true;
            }
            boolean isInGV = currentTkn.getChunkTags().contains(new ChunkTag("GV"));
            if (isPronoun || isVerb && !inPronouns && !firstVerbInflected && (toLeft == 0 || isInGV) || isInGV && !firstVerbInflected) {
                if (isVerb) {
                    firstVerb = currentTknStr;
                    firstVerbPos = toLeft;
                    firstVerbInflected = currentTkn.matchesPosTagRegex("V.[SI].*");
                    if (firstVerbInflected) {
                        firstVerbPersonaNumber = currentTkn.readingWithTagRegex("V.[SI].*").getPOSTag().substring(4, 6);
                    }
                    if (currentTkn.matchesPosTagRegex("V.M.*")) {
                        firstVerbPersonaNumberImperative = currentTkn.readingWithTagRegex("V.M.*").getPOSTag().substring(4, 6);
                    }
                }
                ++toLeft;
                continue;
            }
            done = true;
            if (toLeft <= 0) continue;
            --toLeft;
        }
        if (posWord - toLeft == 0) {
            --toLeft;
        }
        if (!firstVerbInflected) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = posWord - toLeft; i < posWord - firstVerbPos; ++i) {
            sb.append(tokens[i].getToken());
            if (!tokens[i + 1].isWhitespaceBefore()) continue;
            sb.append(" ");
        }
        String pronounsStr = sb.toString().trim();
        sb = new StringBuilder();
        for (int i = posWord - firstVerbPos; i <= posWord; ++i) {
            if (i == posWord && !replacementVerb.isEmpty()) {
                sb.append(replacementVerb);
            } else {
                sb.append(tokens[i].getToken());
            }
            if (i + 1 >= tokens.length || !tokens[i + 1].isWhitespaceBefore()) continue;
            sb.append(" ");
        }
        String verbStr = sb.toString().trim();
        for (String action : actions) {
            String replacement = "";
            switch (action) {
                case "addPronounEn": {
                    replacement = PronomsFeblesHelper.doAddPronounEn(firstVerb, pronounsStr, verbStr, false);
                    break;
                }
                case "removePronounReflexive": {
                    replacement = PronomsFeblesHelper.doRemovePronounReflexive(firstVerb, pronounsStr, verbStr, false);
                    break;
                }
                case "replaceEmEn": {
                    replacement = PronomsFeblesHelper.doReplaceEmEn(firstVerb, pronounsStr, verbStr, false);
                    break;
                }
                case "addPronounReflexive": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexive(firstVerb, pronounsStr, verbStr, firstVerbPersonaNumber, false);
                    break;
                }
                case "addPronounReflexiveHi": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexive(firstVerb, pronounsStr, "hi " + verbStr, firstVerbPersonaNumber, false);
                    break;
                }
                case "addPronounReflexiveImperative": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexiveImperative(firstVerb, pronounsStr, verbStr, firstVerbPersonaNumberImperative);
                }
            }
            if (replacement.isEmpty()) continue;
            replacements.add(StringTools.preserveCase((String)replacement, (String)tokens[posWord - toLeft].getToken()).trim());
        }
        if (replacements.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord - toLeft].getStartPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }
}

