/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class OblidarseSugestionsFilter
extends RuleFilter {
    Language lang = Languages.getLanguageForShortCode((String)"ca");
    Pattern pApostropheNeeded = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 2);
    private static Map<String, String> addReflexiveVowel = new HashMap<String, String>();
    private static Map<String, String> addReflexiveConsonant;
    private static Map<String, String> addReflexiveEnVowel;
    private static Map<String, String> addReflexiveEnConsonant;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord;
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        String pronomPostag = tokens[posWord + 1].readingWithTagRegex("P.*").getPOSTag();
        String pronomGenderNumber = pronomPostag.substring(2, 3) + pronomPostag.substring(4, 5);
        int indexMainVerb = posWord + 2;
        while (!tokens[indexMainVerb].hasAnyLemma(new String[]{"oblidar", "descuidar", "passar"})) {
            ++indexMainVerb;
        }
        String verbPostag = tokens[posWord + 2].readingWithTagRegex("V.*").getPOSTag();
        String lemma = tokens[posWord + 2].readingWithTagRegex("V.*").getLemma();
        if (lemma.equals("passar")) {
            lemma = "descuidar";
        }
        AnalyzedToken at = new AnalyzedToken("", "", lemma);
        String[] synthForms = synth.synthesize(at, verbPostag.substring(0, 4) + pronomGenderNumber + verbPostag.substring(6, 8));
        Object newVerb = "";
        if (synthForms.length == 0) {
            return null;
        }
        newVerb = synthForms[0];
        for (int i = posWord + 3; i < indexMainVerb + 1; ++i) {
            newVerb = (String)newVerb + tokens[i].getWhitespaceBefore() + tokens[i].getToken().replace("passar", "descuidar").replace("passat", "descuidat").replace("passant", "descuidant");
        }
        boolean verbVowel = this.pApostropheNeeded.matcher((CharSequence)newVerb).matches();
        String wordAfter = "";
        if (indexMainVerb + 1 < tokens.length) {
            List<String> exceptionsList;
            AnalyzedToken wordAfterReading = tokens[indexMainVerb + 1].readingWithTagRegex("D.*|V.N.*|P[DI].*|NC.*");
            if (wordAfterReading != null) {
                wordAfter = wordAfterReading.getToken();
            }
            if ((exceptionsList = Arrays.asList("com", "de", "d'", "que")).contains(tokens[indexMainVerb + 1].getToken().toLowerCase())) {
                wordAfter = tokens[indexMainVerb + 1].getToken();
            }
        }
        Map<String, String> transform = wordAfter.isEmpty() && !wordAfter.equalsIgnoreCase("de") && !wordAfter.equalsIgnoreCase("d'") && !wordAfter.equalsIgnoreCase("que") ? (verbVowel ? addReflexiveEnVowel : addReflexiveEnConsonant) : (verbVowel ? addReflexiveVowel : addReflexiveConsonant);
        StringBuilder suggBld = new StringBuilder();
        suggBld.append(transform.get(pronomGenderNumber));
        suggBld.append((String)newVerb);
        boolean wordAfterApostrophe = false;
        int charactersAfterCorrection = 0;
        if (wordAfter.equalsIgnoreCase("el") || wordAfter.equalsIgnoreCase("els")) {
            suggBld.append(" d");
            suggBld.append(wordAfter.toLowerCase());
            charactersAfterCorrection = wordAfter.length() + 1;
        } else if (!(wordAfter.isEmpty() || wordAfter.equalsIgnoreCase("de") || wordAfter.equalsIgnoreCase("d'") || wordAfter.equalsIgnoreCase("que"))) {
            wordAfterApostrophe = this.pApostropheNeeded.matcher(wordAfter).matches();
            suggBld.append(wordAfterApostrophe ? " d'" : " de");
            charactersAfterCorrection = wordAfterApostrophe ? 1 : 0;
        }
        String replacement = StringTools.preserveCase((String)suggBld.toString(), (String)tokens[posWord].getToken());
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add(replacement);
        for (Object s : match.getSuggestedReplacements()) {
            if (charactersAfterCorrection == 1) {
                s = (String)s + " ";
            }
            replacements.add(this.lang.adaptSuggestion((String)s, tokens[posWord].getToken()));
        }
        if (replacements.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord].getStartPos(), tokens[indexMainVerb].getEndPos() + charactersAfterCorrection, match.getMessage().replace("passar", "descuidar"), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }

    private String getLanguageVariantCode(RuleMatch match) {
        PatternRule pr = (PatternRule)match.getRule();
        return pr.getLanguage().getShortCodeWithCountryAndVariant();
    }

    static {
        addReflexiveVowel.put("1S", "m'");
        addReflexiveVowel.put("2S", "t'");
        addReflexiveVowel.put("3S", "s'");
        addReflexiveVowel.put("1P", "ens ");
        addReflexiveVowel.put("2P", "us ");
        addReflexiveVowel.put("3P", "s'");
        addReflexiveConsonant = new HashMap<String, String>();
        addReflexiveConsonant.put("1S", "em ");
        addReflexiveConsonant.put("2S", "et ");
        addReflexiveConsonant.put("3S", "es ");
        addReflexiveConsonant.put("1P", "ens ");
        addReflexiveConsonant.put("2P", "us ");
        addReflexiveConsonant.put("3P", "es ");
        addReflexiveEnVowel = new HashMap<String, String>();
        addReflexiveEnVowel.put("1S", "me n'");
        addReflexiveEnVowel.put("2S", "te n'");
        addReflexiveEnVowel.put("3S", "se n'");
        addReflexiveEnVowel.put("1P", "ens n'");
        addReflexiveEnVowel.put("2P", "us n'");
        addReflexiveEnVowel.put("3P", "se n'");
        addReflexiveEnConsonant = new HashMap<String, String>();
        addReflexiveEnConsonant.put("1S", "me'n ");
        addReflexiveEnConsonant.put("2S", "te'n ");
        addReflexiveEnConsonant.put("3S", "se'n ");
        addReflexiveEnConsonant.put("1P", "ens en ");
        addReflexiveEnConsonant.put("2P", "us en ");
        addReflexiveEnConsonant.put("3P", "se'n ");
    }
}

