/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.ApostophationHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tools.StringTools;

public class SynthesizeWithDeterminerFilter
extends RuleFilter {
    private List<String> genderNumberList = Arrays.asList("MS", "FS", "MP", "FP");
    private static Map<String, Pattern> genderNumberPatterns = new HashMap<String, Pattern>();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        AnalyzedToken reading;
        CatalanSynthesizer synth = (CatalanSynthesizer)this.getSynthesizerFromRuleMatch(match);
        String lemmaFromStr = this.getRequired("lemmaFrom", arguments);
        String lemmaSelect = this.getRequired("lemmaSelect", arguments);
        boolean synthAllForms = this.getOptional("synthAllForms", arguments, "false").equalsIgnoreCase("true");
        String prepositionFromStr = this.getOptional("prepositionFrom", arguments, "");
        int lemmaFrom = this.getPosition(lemmaFromStr, patternTokens, match);
        String preposition = "";
        if (StringUtils.isNumeric((CharSequence)prepositionFromStr)) {
            int prepositionFrom = this.getPosition(prepositionFromStr, patternTokens, match);
            preposition = patternTokens[prepositionFrom].getToken().substring(0, 1).toLowerCase();
        } else if (!prepositionFromStr.isEmpty()) {
            preposition = prepositionFromStr.substring(0, 1);
        }
        ArrayList<Object> suggestions = new ArrayList<Object>();
        String originalWord = patternTokens[lemmaFrom].getToken();
        Pattern p = Pattern.compile(lemmaSelect);
        boolean isSentenceStart = this.isMatchAtSentenceStart(match.getSentence().getTokensWithoutWhitespace(), match);
        ArrayList<AnalyzedToken> potentialSuggestions = new ArrayList<AnalyzedToken>();
        AnalyzedToken originalAT = patternTokens[lemmaFrom].readingWithTagRegex(lemmaSelect);
        if (originalAT == null) {
            throw new RuntimeException("Cannot find analyzed token readings with postag " + lemmaSelect + " in sentence" + match.getSentence().getText());
        }
        potentialSuggestions.add(originalAT);
        String secondGenderNumber = "";
        if (lemmaFrom - 1 > 0 && (reading = patternTokens[lemmaFrom - 1].readingWithTagRegex("D.*")) != null) {
            secondGenderNumber = reading.getPOSTag().substring(3, 5);
        }
        for (String tag : synth.getPossibleTags()) {
            String[] synthForms;
            Matcher m = p.matcher(tag);
            if (!m.matches()) continue;
            for (String synthForm : synthForms = synth.synthesize(originalAT, tag)) {
                AnalyzedToken at = new AnalyzedToken(synthForm, tag, originalAT.getLemma());
                if (!synthAllForms && !synthForm.equalsIgnoreCase(originalWord) || potentialSuggestions.contains(at)) continue;
                if (tag.contains(secondGenderNumber) || tag.contains(secondGenderNumber.substring(1, 2) + secondGenderNumber.substring(0, 1))) {
                    potentialSuggestions.add(1, at);
                    continue;
                }
                potentialSuggestions.add(at);
            }
        }
        for (AnalyzedToken potentialSuggestion : potentialSuggestions) {
            String newForm = potentialSuggestion.getToken();
            for (String genderNumber : this.genderNumberList) {
                if (!genderNumberPatterns.get(genderNumber).matcher(potentialSuggestion.getPOSTag()).matches()) continue;
                Object suggestion = ApostophationHelper.getPrepositionAndDeterminer(newForm, genderNumber, preposition) + StringTools.preserveCase((String)newForm, (String)originalWord);
                if (isSentenceStart) {
                    suggestion = StringTools.uppercaseFirstChar((String)suggestion);
                }
                if (suggestions.contains(suggestion)) continue;
                suggestions.add(suggestion);
            }
        }
        match.addSuggestedReplacements(suggestions);
        return match;
    }

    static {
        genderNumberPatterns.put("MS", Pattern.compile("(N|A.).[MC][SN].*|V.P.*SM."));
        genderNumberPatterns.put("FS", Pattern.compile("(N|A.).[FC][SN].*|V.P.*SF."));
        genderNumberPatterns.put("MP", Pattern.compile("(N|A.).[MC][PN].*|V.P.*PM."));
        genderNumberPatterns.put("FP", Pattern.compile("(N|A.).[FC][PN].*|V.P.*PF."));
    }
}

