/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.AnalyzedGermanTokenReadings;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tools.StringTools;

public class CaseRule
extends GermanRule {
    private final GermanTagger tagger = (GermanTagger)new German().getTagger();
    private static final Set<String> nounIndicators = new HashSet<String>();
    private static final Set<String> sentenceStartExceptions;
    private static final Set<String> exceptions;
    private static final Set<String> myExceptionPhrases;
    private static final Set<String> substVerbenExceptions;

    public CaseRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_case")));
        }
    }

    public String getId() {
        return "DE_CASE";
    }

    public String getDescription() {
        return "Gro\u00dfschreibung von Nomen und substantivierten Verben";
    }

    public RuleMatch[] match(AnalyzedSentence text) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        boolean prevTokenIsDas = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean hasNounReading;
            AnalyzedGermanTokenReadings analyzedGermanToken2;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if (posToken != null && posToken.equals("SENT_START")) continue;
            if (i == 1) {
                if (!nounIndicators.contains(tokens[i].getToken().toLowerCase())) continue;
                prevTokenIsDas = true;
                continue;
            }
            if (i > 0 && (tokens[i - 1].getToken().equals("Herr") || tokens[i - 1].getToken().equals("Herrn") || tokens[i - 1].getToken().equals("Frau"))) continue;
            AnalyzedGermanTokenReadings analyzedToken = (AnalyzedGermanTokenReadings)tokens[i];
            String token = analyzedToken.getToken();
            List<AnalyzedGermanToken> readings = analyzedToken.getGermanReadings();
            boolean isBaseform = false;
            if (analyzedToken.getReadingsLength() >= 1 && analyzedToken.hasLemma(token)) {
                isBaseform = true;
            }
            if ((readings == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null || analyzedToken.hasReadingOfType(GermanToken.POSType.VERB)) && isBaseform) {
                analyzedGermanToken2 = this.tagger.lookup(token.toLowerCase());
                if (analyzedGermanToken2 != null) {
                    readings = analyzedGermanToken2.getGermanReadings();
                }
                boolean nextTokenIsPersonalPronoun = false;
                if (i < tokens.length - 1) {
                    nextTokenIsPersonalPronoun = tokens[i + 1].hasPartialPosTag("PRO:PER") || tokens[i + 1].getToken().equals("Sie");
                }
                this.potentiallyAddLowercaseMatch(ruleMatches, tokens[i], prevTokenIsDas, token, nextTokenIsPersonalPronoun);
            }
            prevTokenIsDas = nounIndicators.contains(tokens[i].getToken().toLowerCase());
            if (readings == null || (hasNounReading = analyzedToken.hasReadingOfType(GermanToken.POSType.NOMEN))) continue;
            analyzedGermanToken2 = this.tagger.lookup(token.toLowerCase());
            if (analyzedToken.getAnalyzedToken(0).getPOSTag() == null && analyzedGermanToken2 == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null && analyzedGermanToken2 != null && analyzedGermanToken2.getAnalyzedToken(0).getPOSTag() == null) continue;
            this.potentiallyAddUppercaseMatch(ruleMatches, tokens, i, analyzedToken, token);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private void potentiallyAddLowercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings tokenReadings, boolean prevTokenIsDas, String token, boolean nextTokenIsPersonalPronoun) {
        if (prevTokenIsDas && !nextTokenIsPersonalPronoun && Character.isLowerCase(token.charAt(0)) && !substVerbenExceptions.contains(token)) {
            String msg = "Substantivierte Verben werden gro\u00dfgeschrieben.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokenReadings.getStartPos(), tokenReadings.getStartPos() + token.length(), "Substantivierte Verben werden gro\u00dfgeschrieben.");
            String word = tokenReadings.getToken();
            String fixedWord = StringTools.uppercaseFirstChar((String)word);
            ruleMatch.setSuggestedReplacement(fixedWord);
            ruleMatches.add(ruleMatch);
        }
    }

    private void potentiallyAddUppercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedGermanTokenReadings analyzedToken, String token) {
        if (!(!Character.isUpperCase(token.charAt(0)) || token.length() <= 1 || sentenceStartExceptions.contains(tokens[i - 1].getToken()) || StringTools.isAllUppercase((String)token) || exceptions.contains(token) || analyzedToken.hasReadingOfType(GermanToken.POSType.PROPER_NOUN) || this.isNilReading(analyzedToken) || analyzedToken.isSentenceEnd() || (tokens[i - 1].getToken().equals("]") || tokens[i - 1].getToken().equals(")")) && (i == 4 && tokens[i - 2].getToken().equals("\u2026") || i == 6 && tokens[i - 2].getToken().equals(".")) || this.isExceptionPhrase(i, tokens))) {
            String msg = "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben");
            String word = tokens[i].getToken();
            String fixedWord = Character.toLowerCase(word.charAt(0)) + word.substring(1);
            ruleMatch.setSuggestedReplacement(fixedWord);
            ruleMatches.add(ruleMatch);
        }
    }

    private boolean isNilReading(AnalyzedGermanTokenReadings analyzedToken) {
        List<AnalyzedGermanToken> germanReadings = analyzedToken.getGermanReadings();
        return germanReadings.size() > 0 && "NIL:SUB".equals(germanReadings.get(0).getPOSTag());
    }

    private boolean isExceptionPhrase(int i, AnalyzedTokenReadings[] tokens) {
        for (String exc : myExceptionPhrases) {
            String[] parts = exc.split(" ");
            for (int j = 0; j < parts.length; ++j) {
                int startIndex;
                if (!parts[j].equals(tokens[i].getToken()) || !this.compareLists(tokens, startIndex = i - j, startIndex + parts.length - 1, parts)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareLists(AnalyzedTokenReadings[] tokens, int startIndex, int endIndex, String[] parts) {
        if (startIndex < 0) {
            return false;
        }
        int i = 0;
        for (int j = startIndex; j <= endIndex; ++j) {
            if (i >= parts.length) {
                return false;
            }
            if (!tokens[j].getToken().equals(parts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reset() {
    }

    static {
        nounIndicators.add("das");
        nounIndicators.add("sein");
        nounIndicators.add("mein");
        nounIndicators.add("dein");
        nounIndicators.add("euer");
        sentenceStartExceptions = new HashSet<String>();
        sentenceStartExceptions.add("(");
        sentenceStartExceptions.add(":");
        sentenceStartExceptions.add("\"");
        sentenceStartExceptions.add("'");
        sentenceStartExceptions.add("\u201e");
        sentenceStartExceptions.add("\u201c");
        sentenceStartExceptions.add("\u00ab");
        sentenceStartExceptions.add("\u00bb");
        exceptions = new HashSet<String>();
        exceptions.add("Hr");
        exceptions.add("Schwarz");
        exceptions.add("Genese");
        exceptions.add("Rosa");
        exceptions.add("Auftrieb");
        exceptions.add("Zuschnitt");
        exceptions.add("Geschossen");
        exceptions.add("Vortrieb");
        exceptions.add("Abtrieb");
        exceptions.add("Gesandter");
        exceptions.add("Durchfahrt");
        exceptions.add("Durchgriff");
        exceptions.add("\u00dcberfahrt");
        exceptions.add("Zeche");
        exceptions.add("Sparte");
        exceptions.add("Sparten");
        exceptions.add("Heiliger");
        exceptions.add("Reisender");
        exceptions.add("Hochdeutsch");
        exceptions.add("Pest");
        exceptions.add("Schwinge");
        exceptions.add("Verlies");
        exceptions.add("Nachfolge");
        exceptions.add("Stift");
        exceptions.add("Belange");
        exceptions.add("Geistlicher");
        exceptions.add("Jenseits");
        exceptions.add("Abends");
        exceptions.add("Abgeordneter");
        exceptions.add("Angestellter");
        exceptions.add("Abriss");
        exceptions.add("Ahne");
        exceptions.add("\u00c4hnlichem");
        exceptions.add("\u00c4hnliches");
        exceptions.add("Allerlei");
        exceptions.add("Anklang");
        exceptions.add("Anstrich");
        exceptions.add("Armes");
        exceptions.add("Aus");
        exceptions.add("Ausdr\u00fccke");
        exceptions.add("Ausw\u00fcchsen");
        exceptions.add("B\u00e4nde");
        exceptions.add("B\u00e4nden");
        exceptions.add("Beauftragter");
        exceptions.add("Belange");
        exceptions.add("besonderes");
        exceptions.add("Biss");
        exceptions.add("De");
        exceptions.add("Dr");
        exceptions.add("Durcheinander");
        exceptions.add("Eindr\u00fccke");
        exceptions.add("Erwachsener");
        exceptions.add("Fl\u00f6\u00dfe");
        exceptions.add("Folgendes");
        exceptions.add("Fort");
        exceptions.add("Fra\u00df");
        exceptions.add("F\u00fcr");
        exceptions.add("Gen\u00fcge");
        exceptions.add("Gl\u00e4ubiger");
        exceptions.add("Goldener");
        exceptions.add("Gro\u00dfe");
        exceptions.add("Gro\u00dfen");
        exceptions.add("Guten");
        exceptions.add("Hechte");
        exceptions.add("Herz\u00f6ge");
        exceptions.add("Herz\u00f6gen");
        exceptions.add("Hinfahrt");
        exceptions.add("Hundert");
        exceptions.add("Ihnen");
        exceptions.add("Ihr");
        exceptions.add("Ihre");
        exceptions.add("Ihrem");
        exceptions.add("Ihren");
        exceptions.add("Ihrer");
        exceptions.add("Ihres");
        exceptions.add("Infrarot");
        exceptions.add("Jenseits");
        exceptions.add("Jugendlicher");
        exceptions.add("J\u00fcnger");
        exceptions.add("Klaue");
        exceptions.add("Kleine");
        exceptions.add("Konditional");
        exceptions.add("Kr\u00e4he");
        exceptions.add("Kurzem");
        exceptions.add("Landwirtschaft");
        exceptions.add("Langem");
        exceptions.add("L\u00e4ngerem");
        exceptions.add("Las");
        exceptions.add("Le");
        exceptions.add("Letzt");
        exceptions.add("Letzt");
        exceptions.add("Letztere");
        exceptions.add("Letzterer");
        exceptions.add("Letzteres");
        exceptions.add("Link");
        exceptions.add("Links");
        exceptions.add("L\u00f6hne");
        exceptions.add("Luden");
        exceptions.add("Mitfahrt");
        exceptions.add("Mr");
        exceptions.add("Mrd");
        exceptions.add("Mrs");
        exceptions.add("Nachfrage");
        exceptions.add("Nachts");
        exceptions.add("N\u00e4hte");
        exceptions.add("N\u00e4hten");
        exceptions.add("Neuem");
        exceptions.add("Neues");
        exceptions.add("Nr");
        exceptions.add("Nutze");
        exceptions.add("Obdachloser");
        exceptions.add("Oder");
        exceptions.add("Patsche");
        exceptions.add("Pfiffe");
        exceptions.add("Pfiffen");
        exceptions.add("Prof");
        exceptions.add("Puste");
        exceptions.add("Sachverst\u00e4ndiger");
        exceptions.add("Sankt");
        exceptions.add("Scheine");
        exceptions.add("Schei\u00dfe");
        exceptions.add("Schuft");
        exceptions.add("Schufte");
        exceptions.add("Schuld");
        exceptions.add("Schw\u00e4rme");
        exceptions.add("Schwarzes");
        exceptions.add("Sie");
        exceptions.add("Spitz");
        exceptions.add("St");
        exceptions.add("Stereotyp");
        exceptions.add("St\u00f6re");
        exceptions.add("Tausend");
        exceptions.add("Toter");
        exceptions.add("tun");
        exceptions.add("\u00dcbrigen");
        exceptions.add("Unvorhergesehenes");
        exceptions.add("Verantwortlicher");
        exceptions.add("Verwandter");
        exceptions.add("Vielfaches");
        exceptions.add("Vorsitzender");
        exceptions.add("Weitem");
        exceptions.add("Weiteres");
        exceptions.add("Wicht");
        exceptions.add("Wichtiges");
        exceptions.add("Wider");
        exceptions.add("Wild");
        exceptions.add("Zeche");
        exceptions.add("Zusage");
        exceptions.add("Zwinge");
        exceptions.add("Erster");
        exceptions.add("Zweiter");
        exceptions.add("Dritter");
        exceptions.add("Vierter");
        exceptions.add("F\u00fcnfter");
        exceptions.add("Sechster");
        exceptions.add("Siebter");
        exceptions.add("Achter");
        exceptions.add("Neunter");
        exceptions.add("Erste");
        exceptions.add("Zweite");
        exceptions.add("Dritte");
        exceptions.add("Vierte");
        exceptions.add("F\u00fcnfte");
        exceptions.add("Sechste");
        exceptions.add("Siebte");
        exceptions.add("Achte");
        exceptions.add("Neunte");
        exceptions.add("Afrikanisch");
        exceptions.add("Altarabisch");
        exceptions.add("Altchinesisch");
        exceptions.add("Altgriechisch");
        exceptions.add("Althochdeutsch");
        exceptions.add("Altpersisch");
        exceptions.add("Amerikanisch");
        exceptions.add("Arabisch");
        exceptions.add("Chinesisch");
        exceptions.add("D\u00e4nisch");
        exceptions.add("Deutsch");
        exceptions.add("Englisch");
        exceptions.add("Finnisch");
        exceptions.add("Franz\u00f6sisch");
        exceptions.add("Fr\u00fchneuhochdeutsch");
        exceptions.add("Germanisch");
        exceptions.add("Griechisch");
        exceptions.add("Hocharabisch");
        exceptions.add("Hochchinesisch");
        exceptions.add("Hochdeutsch");
        exceptions.add("Holl\u00e4ndisch");
        exceptions.add("Italienisch");
        exceptions.add("Japanisch");
        exceptions.add("Jiddisch");
        exceptions.add("Jugoslawisch");
        exceptions.add("Koreanisch");
        exceptions.add("Kroatisch");
        exceptions.add("Lateinisch");
        exceptions.add("Luxemburgisch");
        exceptions.add("Mittelhochdeutsch");
        exceptions.add("Neuhochdeutsch");
        exceptions.add("Niederl\u00e4ndisch");
        exceptions.add("Norwegisch");
        exceptions.add("Persisch");
        exceptions.add("Polnisch");
        exceptions.add("Portugiesisch");
        exceptions.add("Russisch");
        exceptions.add("Schwedisch");
        exceptions.add("Schweizerisch");
        exceptions.add("Serbisch");
        exceptions.add("Serbokroatisch");
        exceptions.add("Slawisch");
        exceptions.add("Spanisch");
        exceptions.add("Tschechisch");
        exceptions.add("T\u00fcrkisch");
        exceptions.add("Ukrainisch");
        exceptions.add("Ungarisch");
        exceptions.add("Wei\u00dfrussisch");
        exceptions.add("Dein");
        exceptions.add("Deine");
        exceptions.add("Deinem");
        exceptions.add("Deinen");
        exceptions.add("Deiner");
        exceptions.add("Deines");
        exceptions.add("Dich");
        exceptions.add("Dir");
        exceptions.add("Du");
        exceptions.add("Euch");
        exceptions.add("Euer");
        exceptions.add("Eure");
        exceptions.add("Eurem");
        exceptions.add("Euren");
        exceptions.add("Eures");
        myExceptionPhrases = new HashSet<String>();
        myExceptionPhrases.add("ohne Wenn und Aber");
        myExceptionPhrases.add("Gro\u00dfe Koalition");
        myExceptionPhrases.add("Gro\u00dfen Koalition");
        myExceptionPhrases.add("im Gro\u00dfen und Ganzen");
        myExceptionPhrases.add("Im Gro\u00dfen und Ganzen");
        myExceptionPhrases.add("im Guten wie im Schlechten");
        myExceptionPhrases.add("Im Guten wie im Schlechten");
        myExceptionPhrases.add("Russisches Reich");
        myExceptionPhrases.add("Tel Aviv");
        myExceptionPhrases.add("Erster Weltkrieg");
        myExceptionPhrases.add("Ersten Weltkriegs");
        myExceptionPhrases.add("Ersten Weltkrieges");
        myExceptionPhrases.add("Erstem Weltkrieg");
        myExceptionPhrases.add("Zweiter Weltkrieg");
        myExceptionPhrases.add("Zweiten Weltkriegs");
        myExceptionPhrases.add("Zweiten Weltkrieges");
        myExceptionPhrases.add("Zweitem Weltkrieg");
        myExceptionPhrases.add("Vielfaches");
        myExceptionPhrases.add("Ausw\u00e4rtiges Amt");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amt");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amts");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amtes");
        myExceptionPhrases.add("B\u00fcrgerliches Gesetzbuch");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuch");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuchs");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuches");
        myExceptionPhrases.add("Haute Couture");
        myExceptionPhrases.add("aus dem Nichts");
        myExceptionPhrases.add("Kleiner B\u00e4r");
        myExceptionPhrases.add("Zehn Gebote");
        myExceptionPhrases.add("R\u00f6mische Reich Deutscher Nation");
        myExceptionPhrases.add("ein absolutes Muss");
        myExceptionPhrases.add("ein Muss");
        substVerbenExceptions = new HashSet<String>();
        substVerbenExceptions.add("einen");
        substVerbenExceptions.add("geh\u00f6ren");
        substVerbenExceptions.add("bedeutet");
        substVerbenExceptions.add("erm\u00f6glicht");
        substVerbenExceptions.add("sollen");
        substVerbenExceptions.add("werden");
        substVerbenExceptions.add("d\u00fcrfen");
        substVerbenExceptions.add("m\u00fcssen");
        substVerbenExceptions.add("so");
        substVerbenExceptions.add("ist");
        substVerbenExceptions.add("k\u00f6nnen");
        substVerbenExceptions.add("mein");
        substVerbenExceptions.add("sein");
        substVerbenExceptions.add("muss");
        substVerbenExceptions.add("mu\u00df");
        substVerbenExceptions.add("wollen");
        substVerbenExceptions.add("habe");
        substVerbenExceptions.add("ein");
        substVerbenExceptions.add("tun");
        substVerbenExceptions.add("best\u00e4tigt");
        substVerbenExceptions.add("best\u00e4tigte");
        substVerbenExceptions.add("best\u00e4tigten");
        substVerbenExceptions.add("bekommen");
    }
}

