/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.de.GermanToken;

public class AnalyzedGermanToken
extends AnalyzedToken {
    private GermanToken.POSType type;
    private GermanToken.Kasus casus;
    private GermanToken.Numerus numerus;
    private GermanToken.Genus genus;

    public AnalyzedGermanToken(AnalyzedToken token) {
        super(token.getToken(), token.getPOSTag(), token.getLemma());
        this.init();
    }

    public AnalyzedGermanToken(String token, String posTag) {
        super(token, posTag, null);
        this.init();
    }

    public AnalyzedGermanToken(String token, String posTag, String lemma) {
        super(token, posTag, lemma);
        this.init();
    }

    private void init() {
        if (this.getPOSTag() == null) {
            return;
        }
        String[] parts = this.getPOSTag().split(":");
        if (parts.length < 3) {
            return;
        }
        for (String part : parts) {
            if (part.equals("EIG")) {
                this.type = GermanToken.POSType.PROPER_NOUN;
                continue;
            }
            if (part.equals("SUB") && this.type == null) {
                this.type = GermanToken.POSType.NOMEN;
                continue;
            }
            if (part.equals("PA1") || part.equals("PA2")) {
                this.type = GermanToken.POSType.PARTIZIP;
                continue;
            }
            if (part.equals("VER") && this.type == null) {
                this.type = GermanToken.POSType.VERB;
                continue;
            }
            if (part.equals("ADJ") && this.type == null) {
                this.type = GermanToken.POSType.ADJEKTIV;
                continue;
            }
            if (part.equals("PRO") && this.type == null) {
                this.type = GermanToken.POSType.PRONOMEN;
                continue;
            }
            if (part.equals("ART") && this.type == null) {
                this.type = GermanToken.POSType.DETERMINER;
                continue;
            }
            if (part.equals("AKK")) {
                this.casus = GermanToken.Kasus.AKKUSATIV;
                continue;
            }
            if (part.equals("GEN")) {
                this.casus = GermanToken.Kasus.GENITIV;
                continue;
            }
            if (part.equals("NOM")) {
                this.casus = GermanToken.Kasus.NOMINATIV;
                continue;
            }
            if (part.equals("DAT")) {
                this.casus = GermanToken.Kasus.DATIV;
                continue;
            }
            if (part.equals("PLU")) {
                this.numerus = GermanToken.Numerus.PLURAL;
                continue;
            }
            if (part.equals("SIN")) {
                this.numerus = GermanToken.Numerus.SINGULAR;
                continue;
            }
            if (part.equals("MAS")) {
                this.genus = GermanToken.Genus.MASKULINUM;
                continue;
            }
            if (part.equals("FEM")) {
                this.genus = GermanToken.Genus.FEMININUM;
                continue;
            }
            if (part.equals("NEU")) {
                this.genus = GermanToken.Genus.NEUTRUM;
                continue;
            }
            if (part.equals("NOG")) {
                this.genus = GermanToken.Genus.FEMININUM;
                continue;
            }
            if (!part.equals("ALG")) continue;
            this.genus = GermanToken.Genus.ALLGEMEIN;
        }
    }

    public GermanToken.POSType getType() {
        return this.type;
    }

    public GermanToken.Kasus getCasus() {
        return this.casus;
    }

    public GermanToken.Numerus getNumerus() {
        return this.numerus;
    }

    public GermanToken.Genus getGenus() {
        return this.genus;
    }
}

