/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.chunking;

import com.google.common.base.Function;
import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicExpression;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.ExpressionFactory;
import org.languagetool.chunking.ChunkTaggedToken;
import org.languagetool.chunking.TokenPredicate;

final class TokenExpressionFactory
extends ExpressionFactory<ChunkTaggedToken> {
    private final boolean caseSensitive;

    TokenExpressionFactory(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Expression.BaseExpression<ChunkTaggedToken> create(String expr) {
        final LogicExpression logicExpression = LogicExpression.compile((String)expr, (Function)new Function<String, Expression.Arg<ChunkTaggedToken>>(){

            public Expression.Arg<ChunkTaggedToken> apply(String input) {
                return new TokenPredicate(input, TokenExpressionFactory.this.caseSensitive);
            }
        });
        return new Expression.BaseExpression<ChunkTaggedToken>(expr){

            public boolean apply(ChunkTaggedToken token) {
                return logicExpression.apply((Object)token);
            }
        };
    }
}

