/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ConfusionProbabilityRule;
import org.languagetool.rules.Example;

public class GermanConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<Pattern> EXCEPTION_PATTERNS = Arrays.asList(Pattern.compile("fiel(e|en)? .* (aus|auf)"));

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams);
        this.addExamplePair(Example.wrong((String)"W\u00e4hrend Sie das Ganze <marker>mir</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"), Example.fixed((String)"W\u00e4hrend Sie das Ganze <marker>mit</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"));
    }

    protected boolean isException(String sentenceText) {
        for (Pattern pattern : EXCEPTION_PATTERNS) {
            Matcher m = pattern.matcher(sentenceText);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }
}

