/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.de.GermanToken;

public class AnalyzedGermanToken {
    private final GermanToken.POSType type;
    private final GermanToken.Kasus casus;
    private final GermanToken.Numerus numerus;
    private final GermanToken.Genus genus;

    public AnalyzedGermanToken(AnalyzedToken token) {
        String posTag = token.getPOSTag();
        if (posTag == null || posTag.split(":").length < 3) {
            this.type = null;
            this.casus = null;
            this.numerus = null;
            this.genus = null;
            return;
        }
        String[] parts = posTag.split(":");
        GermanToken.POSType tempType = null;
        GermanToken.Kasus tempCasus = null;
        GermanToken.Numerus tempNumerus = null;
        GermanToken.Genus tempGenus = null;
        for (String part : parts) {
            if (part.equals("EIG")) {
                tempType = GermanToken.POSType.PROPER_NOUN;
                continue;
            }
            if (part.equals("SUB") && tempType == null) {
                tempType = GermanToken.POSType.NOMEN;
                continue;
            }
            if (part.equals("PA1") || part.equals("PA2")) {
                tempType = GermanToken.POSType.PARTIZIP;
                continue;
            }
            if (part.equals("VER") && tempType == null) {
                tempType = GermanToken.POSType.VERB;
                continue;
            }
            if (part.equals("ADJ") && tempType == null) {
                tempType = GermanToken.POSType.ADJEKTIV;
                continue;
            }
            if (part.equals("PRO") && tempType == null) {
                tempType = GermanToken.POSType.PRONOMEN;
                continue;
            }
            if (part.equals("ART") && tempType == null) {
                tempType = GermanToken.POSType.DETERMINER;
                continue;
            }
            if (part.equals("AKK")) {
                tempCasus = GermanToken.Kasus.AKKUSATIV;
                continue;
            }
            if (part.equals("GEN")) {
                tempCasus = GermanToken.Kasus.GENITIV;
                continue;
            }
            if (part.equals("NOM")) {
                tempCasus = GermanToken.Kasus.NOMINATIV;
                continue;
            }
            if (part.equals("DAT")) {
                tempCasus = GermanToken.Kasus.DATIV;
                continue;
            }
            if (part.equals("PLU")) {
                tempNumerus = GermanToken.Numerus.PLURAL;
                continue;
            }
            if (part.equals("SIN")) {
                tempNumerus = GermanToken.Numerus.SINGULAR;
                continue;
            }
            if (part.equals("MAS")) {
                tempGenus = GermanToken.Genus.MASKULINUM;
                continue;
            }
            if (part.equals("FEM")) {
                tempGenus = GermanToken.Genus.FEMININUM;
                continue;
            }
            if (part.equals("NEU")) {
                tempGenus = GermanToken.Genus.NEUTRUM;
                continue;
            }
            if (part.equals("NOG")) {
                tempGenus = GermanToken.Genus.FEMININUM;
                continue;
            }
            if (!part.equals("ALG")) continue;
            tempGenus = GermanToken.Genus.ALLGEMEIN;
        }
        this.type = tempType != null ? tempType : null;
        this.casus = tempCasus != null ? tempCasus : null;
        this.numerus = tempNumerus != null ? tempNumerus : null;
        this.genus = tempGenus != null ? tempGenus : null;
    }

    public GermanToken.POSType getType() {
        return this.type;
    }

    public GermanToken.Kasus getCasus() {
        return this.casus;
    }

    public GermanToken.Numerus getNumerus() {
        return this.numerus;
    }

    public GermanToken.Genus getGenus() {
        return this.genus;
    }
}

