/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

public class GermanWordRepeatRule
extends WordRepeatRule {
    public GermanWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"In diesem Satz <marker>ist ist</marker> ein Wort doppelt."), Example.fixed((String)"In diesem Satz <marker>ist</marker> ein Wort doppelt."));
    }

    public String getId() {
        return "GERMAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (tokens[position - 1].getToken().length() == 3 && tokens[position - 1].getToken().charAt(0) == 'd') {
            if (position >= 2 && ",".equals(tokens[position - 2].getToken())) {
                return true;
            }
            return position >= 3 && ",".equals(tokens[position - 3].getToken()) && this.isPreposition(tokens[position - 2]);
        }
        if (position != 2 && tokens[position - 1].getToken().equals("Sie") && tokens[position].getToken().equals("sie") || tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("Sie")) {
            return true;
        }
        if (position > 0 && tokens[position - 1].getToken().equals("Leben") && tokens[position].getToken().equals("leben")) {
            return true;
        }
        if (position > 2 && tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("sie")) {
            if (tokens[position - 2].hasPosTag("KON:UNT")) {
                return true;
            }
            if (tokens.length - 1 > position) {
                if (tokens[position - 2].matchesPosTagRegex("VER:3:.+") && tokens[position + 1].hasPosTag("ZUS")) {
                    return true;
                }
                if (tokens[position - 2].matchesPosTagRegex("VER:MOD:3:.+") && tokens[position + 1].hasPosTag("VER:INF:NON")) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPreposition(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("PRP:");
    }
}

