/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends org.languagetool.rules.LongSentenceRule {
    private static final boolean DEFAULT_ACTIVATION = false;

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages, userConfig, defaultWords);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Dies ist ein Bandwurmsatz, der immer weiter geht, obwohl das kein guter Stil ist, den man eigentlich ber\u00fccksichtigen sollte, obwohl es auch andere Meinungen gibt, die aber in der Minderzahl sind, weil die meisten Autoren sich doch an die Stilvorgaben halten, wenn auch nicht alle, was aber letztendlich wiederum eine Sache des Geschmacks ist</marker>."), Example.fixed((String)"<marker>Dies ist ein kurzer Satz.</marker>"));
        if (defaultActive) {
            this.setDefaultOn();
        }
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords) {
        this(messages, userConfig, defaultWords, false);
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig) {
        this(messages, userConfig, -1, false);
    }

    public String getDescription() {
        return "Sehr langer Satz";
    }

    public String getMessage() {
        return "Dieser Satz ist sehr lang (mehr als " + this.maxWords + " W\u00f6rter).";
    }

    public String getId() {
        return "TOO_LONG_SENTENCE_DE";
    }

    private boolean isWordCount(String tokenText) {
        char firstChar;
        return tokenText.length() > 0 && ((firstChar = tokenText.charAt(0)) >= 'A' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'z' || firstChar == '\u00e4' || firstChar == '\u00f6' || firstChar == '\u00fc' || firstChar == '\u00c4' || firstChar == '\u00d6' || firstChar == '\u00dc' || firstChar == '\u00df');
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        if (tokens.length < this.maxWords + 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String msg = this.getMessage();
        int i = 0;
        ArrayList<Integer> fromPos = new ArrayList<Integer>();
        ArrayList<Integer> toPos = new ArrayList<Integer>();
        while (i < tokens.length) {
            int j;
            while (i < tokens.length && !this.isWordCount(tokens[i].getToken())) {
                ++i;
            }
            if (i < tokens.length) {
                fromPos.add(tokens[i].getStartPos());
                toPos.add(tokens[i].getEndPos());
            }
            int numWords = 1;
            while (!(i >= tokens.length || tokens[i].getToken().equals(":") || tokens[i].getToken().equals(";") || (i >= tokens.length - 1 || tokens[i + 1].getToken().equals(",")) && (tokens[i].getToken().equals("\u201c") || tokens[i].getToken().equals("\u00bb") || tokens[i].getToken().equals("\u00ab") || tokens[i].getToken().equals("\"")))) {
                if (this.isWordCount(tokens[i].getToken())) {
                    toPos.set(toPos.size() - 1, tokens[i].getEndPos());
                    ++numWords;
                } else if (tokens[i].getToken().equals("(") || tokens[i].getToken().equals("{") || tokens[i].getToken().equals("[")) {
                    int k;
                    String endChar = tokens[i].getToken().equals("(") ? ")" : (tokens[i].getToken().equals("{") ? "}" : "]");
                    int numWordsInt = 0;
                    int fromPosInt = 0;
                    int toPosInt = 0;
                    for (k = i + 1; k < tokens.length && !tokens[k].getToken().equals(endChar) && !this.isWordCount(tokens[k].getToken()); ++k) {
                    }
                    if (k < tokens.length) {
                        fromPosInt = tokens[k].getStartPos();
                        toPosInt = tokens[k].getEndPos();
                    }
                    ++k;
                    while (k < tokens.length && !tokens[k].getToken().equals(endChar)) {
                        if (this.isWordCount(tokens[k].getToken())) {
                            toPosInt = tokens[k].getEndPos();
                            ++numWordsInt;
                        }
                        ++k;
                    }
                    if (k < tokens.length) {
                        if (numWordsInt > this.maxWords) {
                            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPosInt, toPosInt, msg);
                            ruleMatches.add(ruleMatch);
                        }
                        for (i = k; i < tokens.length && !this.isWordCount(tokens[i].getToken()); ++i) {
                        }
                        if (i < tokens.length) {
                            fromPos.add(tokens[i].getStartPos());
                            toPos.add(tokens[i].getEndPos());
                            ++numWords;
                        }
                    }
                }
                ++i;
            }
            if (numWords > this.maxWords) {
                for (j = 0; j < fromPos.size(); ++j) {
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, ((Integer)fromPos.get(j)).intValue(), ((Integer)toPos.get(j)).intValue(), msg);
                    ruleMatches.add(ruleMatch);
                }
                continue;
            }
            for (j = fromPos.size() - 1; j >= 0; --j) {
                fromPos.remove(j);
                toPos.remove(j);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

