/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.German;
import org.languagetool.rules.Example;
import org.languagetool.rules.de.LineExpander;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final Pattern PREVENT_SUGGESTION = Pattern.compile(".*(Majon\u00e4se|Bravur|Anschovis|Belkanto|Campagne|Frott\u00e9|Grisli|Jockei|Joga|Kalvinismus|Kanossa|Kargo|Ketschup|Kollier|Kommunikee|Masurka|Negligee|Nessess\u00e4r|Poulard|Varietee|Wandalismus|kalvinist).*");
    private final Set<String> wordsToBeIgnoredInCompounds = new HashSet<String>();
    private final Set<String> wordStartsToBeProhibited = new HashSet<String>();
    private static final Map<Pattern, Function<String, List<String>>> ADDITIONAL_SUGGESTIONS = new HashMap<Pattern, Function<String, List<String>>>();
    private static final Map<Pattern, Function<String, List<String>>> ADDITIONAL_SUGGESTIONS_WITH_DOT = new HashMap<Pattern, Function<String, List<String>>>();
    private static final GermanWordSplitter splitter;
    private final LineExpander lineExpander = new LineExpander();
    private final GermanCompoundTokenizer compoundTokenizer;
    private final Synthesizer synthesizer;
    private final Tagger tagger;

    private static void putRepl(String wordPattern, String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(wordPattern), w -> Collections.singletonList(w.replaceFirst(pattern, replacement)));
    }

    private static void put(String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), w -> Collections.singletonList(replacement));
    }

    private static void put(String pattern, Function<String, List<String>> f) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), f);
    }

    private static GermanWordSplitter getSplitter() {
        try {
            return new GermanWordSplitter(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GermanSpellerRule(ResourceBundle messages, German language) {
        this(messages, language, null, null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict) {
        super(messages, (Language)language, language.getNonStrictCompoundSplitter(), GermanSpellerRule.getSpeller(language, userConfig, languageVariantPlainTextDict), userConfig);
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = language.getStrictCompoundTokenizer();
        this.tagger = language.getTagger();
        this.synthesizer = language.getSynthesizer();
    }

    protected void init() throws IOException {
        super.init();
        String pattern = "(" + this.nonWordPattern.pattern() + "|(?<=\\d)-|-(?=\\d+))";
        this.nonWordPattern = Pattern.compile(pattern);
        this.needsInit = false;
    }

    public String getId() {
        return RULE_ID;
    }

    public List<String> getCandidates(String word) {
        ArrayList partList;
        try {
            partList = splitter.getAllSplits(word);
        }
        catch (InputTooLongException e) {
            partList = new ArrayList();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (List parts : partList) {
            candidates.addAll(super.getCandidates(parts));
            if (parts.size() == 2 && !((String)parts.get(0)).endsWith("s")) {
                candidates.add((String)parts.get(0) + "s" + (String)parts.get(1));
            }
            if (parts.size() != 2 || !((String)parts.get(1)).startsWith("s")) continue;
            String firstPart = (String)parts.get(0);
            String secondPart = (String)parts.get(1);
            candidates.addAll(super.getCandidates(Arrays.asList(firstPart + "s", secondPart.substring(1))));
        }
        return candidates;
    }

    protected boolean isProhibited(String word) {
        return super.isProhibited(word) || this.wordStartsToBeProhibited.stream().anyMatch(w -> word.startsWith((String)w));
    }

    protected void addIgnoreWords(String origLine) {
        String line;
        if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH")) {
            line = origLine.replace("\u00df", "ss");
        } else {
            if (origLine.endsWith("-*")) {
                this.wordsToBeIgnoredInCompounds.add(origLine.substring(0, origLine.length() - 2));
                return;
            }
            line = origLine;
        }
        List<String> words = this.expandLine(line);
        for (String word : words) {
            super.addIgnoreWords(word);
        }
    }

    protected List<String> expandLine(String line) {
        return this.lineExpander.expandLine(line);
    }

    public List<String> getSuggestions(String word) throws IOException {
        List<String> suggestions = super.getSuggestions(word);
        suggestions = suggestions.stream().filter(k -> !PREVENT_SUGGESTION.matcher((CharSequence)k).matches() && !k.endsWith("roulett")).collect(Collectors.toList());
        if (word.endsWith(".")) {
            suggestions.replaceAll(s -> s.endsWith(".") ? s : s + ".");
        }
        suggestions = suggestions.stream().filter(k -> !k.equals(word)).collect(Collectors.toList());
        return suggestions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MorfologikMultiSpeller getSpeller(Language language, UserConfig userConfig, String languageVariantPlainTextDict) {
        if (!language.getShortCode().equals(Locale.GERMAN.getLanguage())) {
            throw new RuntimeException("Language is not a variant of German: " + language);
        }
        try {
            String morfoFile = "/de/hunspell/de_" + language.getCountries()[0] + ".dict";
            if (!JLanguageTool.getDataBroker().resourceExists(morfoFile)) return null;
            List<String> paths = Arrays.asList("/de/hunspell/spelling.txt");
            StringBuilder concatPaths = new StringBuilder();
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            for (String path : paths) {
                concatPaths.append(path + ";");
                streams.add(JLanguageTool.getDataBroker().getFromResourceDirAsStream(path));
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), "utf-8"));){
                InputStream variantStream = null;
                ExpandingReader variantReader = null;
                if (languageVariantPlainTextDict != null && !languageVariantPlainTextDict.isEmpty()) {
                    variantStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextDict);
                    variantReader = new ExpandingReader(new BufferedReader(new InputStreamReader(variantStream, "utf-8")));
                }
                MorfologikMultiSpeller morfologikMultiSpeller = new MorfologikMultiSpeller(morfoFile, (BufferedReader)new ExpandingReader(br), concatPaths.toString(), variantReader, languageVariantPlainTextDict, userConfig != null ? userConfig.getAcceptedWords() : Collections.emptyList(), 2);
                return morfologikMultiSpeller;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    protected void filterForLanguage(List<String> suggestions) {
        if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH")) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String s2 = suggestions.get(i);
                suggestions.set(i, s2.replace("\u00df", "ss"));
            }
        }
        suggestions.removeIf(s -> Arrays.stream(s.split(" ")).anyMatch(k -> k.matches("\\w\\p{Punct}?")));
        suggestions.removeIf(s -> s.length() > 1 && s.startsWith("-"));
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (misspelling.equalsIgnoreCase(suggestion) || suggestion.contains(" ")) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(StringUtils.uncapitalize((String)words.get(0)));
        boolean ignoreByHyphen = false;
        boolean ignoreHyphenatedCompound = false;
        if (!ignore && !ignoreUncapitalizedWord) {
            if (words.get(idx).contains("-")) {
                ignoreByHyphen = words.get(idx).endsWith("-") && this.ignoreByHangingHyphen(words, idx);
            }
            ignoreHyphenatedCompound = !ignoreByHyphen && this.ignoreCompoundWithIgnoredWord(words.get(idx));
        }
        return ignore || ignoreUncapitalizedWord || ignoreByHyphen || ignoreHyphenatedCompound;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String[] words;
        String ucWord;
        String suggestion;
        if ("WIFI".equalsIgnoreCase(word)) {
            return Collections.singletonList("Wi-Fi");
        }
        if ("genomen".equals(word)) {
            return Collections.singletonList("genommen");
        }
        if ("Preis-Leistungsverh\u00e4ltnis".equals(word)) {
            return Collections.singletonList("Preis-Leistungs-Verh\u00e4ltnis");
        }
        if ("ausversehen".equals(word)) {
            return Collections.singletonList("aus Versehen");
        }
        if ("getz".equals(word)) {
            return Arrays.asList("jetzt", "geht's");
        }
        if ("Trons".equals(word)) {
            return Collections.singletonList("Trance");
        }
        if (word.matches(".*ibel[hk]eit$")) {
            suggestion = word.replaceFirst("el[hk]eit$", "ilit\u00e4t");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("aquise")) {
            suggestion = word.replaceFirst("aquise$", "akquise");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standart")) {
            suggestion = word.replaceFirst("standart$", "standard");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standarts")) {
            suggestion = word.replaceFirst("standarts$", "standards");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tips")) {
            suggestion = word.replaceFirst("tips$", "tipps");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tip")) {
            suggestion = word + "p";
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("entfehlung")) {
            suggestion = word.replaceFirst("ent", "emp");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("oullie")) {
            suggestion = word.replaceFirst("oullie$", "ouille");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("[dD]urschnitt")) {
            suggestion = word.replaceFirst("^urschnitt", "urchschnitt");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("Bundstift")) {
            suggestion = word.replaceFirst("^Bundstift", "Buntstift");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[aA]llm\u00e4hll?i(g|ch)(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("llm\u00e4hll?i(g|ch)", "llm\u00e4hlich");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[mM]a[jy]onn?[\u00e4e]se.*")) {
            suggestion = word.replaceFirst("a[jy]onn?[\u00e4e]se", "ayonnaise");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[rR]es(a|er)[vw]i[he]?rung(en)?")) {
            suggestion = word.replaceFirst("es(a|er)[vw]i[he]?rung", "eservierung");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[rR]eschaschier.+")) {
            suggestion = word.replaceFirst("schaschier", "cherchier");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[lL]aborants$")) {
            suggestion = word.replaceFirst("ts$", "ten");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[pP]roff?ess?ion([\u00e4e])h?ll?(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("roff?ess?ion([\u00e4e])h?l{1,2}", "rofessionell");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[vV]erstehendniss?(es?)?")) {
            suggestion = word.replaceFirst("[vV]erstehendnis", "Verst\u00e4ndnis");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("koregier.+")) {
            suggestion = word.replaceAll("reg", "rrig");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("diagno[sz]ier.*")) {
            suggestion = word.replaceAll("gno[sz]ier", "gnostizier");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*eiss.*")) {
            suggestion = word.replaceAll("eiss", "ei\u00df");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*uess.*")) {
            suggestion = word.replaceAll("uess", "\u00fc\u00df");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else {
            if (word.matches("bi[s\u00df][ij]en")) {
                return Collections.singletonList("bisschen");
            }
            if (word.equals("gin")) {
                return Collections.singletonList("ging");
            }
            if (word.equals("dh") || word.equals("dh.")) {
                return Collections.singletonList("d.\u202fh.");
            }
            if (word.equals("ua") || word.equals("ua.")) {
                return Collections.singletonList("u.\u202fa.");
            }
            if (word.matches("z[bB]") || word.matches("z[bB].")) {
                return Collections.singletonList("z.\u202fB.");
            }
            if (word.equals("uvm") || word.equals("uvm.")) {
                return Collections.singletonList("u.\u202fv.\u202fm.");
            }
            if (word.equals("udgl") || word.equals("udgl.")) {
                return Collections.singletonList("u.\u202fdgl.");
            }
            if (word.equals("Ruhigkeit")) {
                return Collections.singletonList("Ruhe");
            }
            if (word.equals("angepreist")) {
                return Collections.singletonList("angepriesen");
            }
            if (word.equals("halo")) {
                return Collections.singletonList("hallo");
            }
            if (word.equals("zumindestens")) {
                return Collections.singletonList("zumindest");
            }
            if (word.equals("ca")) {
                return Collections.singletonList("ca.");
            }
            if (word.equals("Jezt")) {
                return Collections.singletonList("Jetzt");
            }
            if (word.equals("Rolladen")) {
                return Collections.singletonList("Rollladen");
            }
            if (word.equals("Ma\u00dfname")) {
                return Collections.singletonList("Ma\u00dfnahme");
            }
            if (word.equals("Ma\u00dfnamen")) {
                return Collections.singletonList("Ma\u00dfnahmen");
            }
            if (word.equals("nanten")) {
                return Collections.singletonList("nannten");
            }
            if (word.endsWith("ies")) {
                if (word.equals("Stories")) {
                    return Collections.singletonList("Storys");
                }
                if (word.equals("Lobbies")) {
                    return Collections.singletonList("Lobbys");
                }
                if (word.equals("Hobbies")) {
                    return Collections.singletonList("Hobbys");
                }
                if (word.equals("Parties")) {
                    return Collections.singletonList("Partys");
                }
                if (word.equals("Babies")) {
                    return Collections.singletonList("Babys");
                }
                if (word.equals("Ladies")) {
                    return Collections.singletonList("Ladys");
                }
                if (word.endsWith("derbies") ? !this.hunspellDict.misspelled(suggestion = word.replaceFirst("derbies$", "derbys")) : (word.endsWith("stories") ? !this.hunspellDict.misspelled(suggestion = word.replaceFirst("stories$", "storys")) : word.endsWith("parties") && !this.hunspellDict.misspelled(suggestion = word.replaceFirst("parties$", "partys")))) {
                    return Collections.singletonList(suggestion);
                }
            } else {
                if (word.equals("Hallochen")) {
                    return Arrays.asList("Hall\u00f6chen", "hall\u00f6chen");
                }
                if (word.equals("hallochen")) {
                    return Collections.singletonList("hall\u00f6chen");
                }
                if (word.equals("ok")) {
                    return Arrays.asList("okay", "O.\u202fK.");
                }
                if (word.equals("gesuchen")) {
                    return Arrays.asList("gesuchten", "gesucht");
                }
                if (word.equals("Germanistiker")) {
                    return Arrays.asList("Germanist", "Germanisten");
                }
                if (word.equals("par")) {
                    return Collections.singletonList("paar");
                }
                if (word.equals("vllt")) {
                    return Collections.singletonList("vielleicht");
                }
                if (word.equals("iwie")) {
                    return Collections.singletonList("irgendwie");
                }
                if (word.equals("sry")) {
                    return Collections.singletonList("sorry");
                }
                if (word.equals("Zynik")) {
                    return Collections.singletonList("Zynismus");
                }
                if (word.matches("Email[a-z\u00e4\u00f6\u00fc]{5,}")) {
                    String suffix = word.substring(5);
                    if (this.hunspellDict.misspelled(suffix)) {
                        List suffixSuggestions = this.hunspellDict.suggest(suffix);
                        suffix = suffixSuggestions.isEmpty() ? suffix : (String)suffixSuggestions.get(0);
                    }
                    return Collections.singletonList("E-Mail-" + Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1));
                }
                if (word.equals("wiederspiegeln")) {
                    return Collections.singletonList("widerspiegeln");
                }
                if (word.equals("ch")) {
                    return Collections.singletonList("ich");
                }
                for (Pattern p : ADDITIONAL_SUGGESTIONS.keySet()) {
                    if (!p.matcher(word).matches()) continue;
                    return ADDITIONAL_SUGGESTIONS.get(p).apply(word);
                }
            }
        }
        if (!(StringTools.startsWithUppercase((String)word) || suggestions.contains(ucWord = StringTools.uppercaseFirstChar((String)word)) || this.hunspellDict.misspelled(ucWord))) {
            return Collections.singletonList(ucWord);
        }
        String verbSuggestion = this.getPastTenseVerbSuggestion(word);
        if (verbSuggestion != null) {
            return Collections.singletonList(verbSuggestion);
        }
        String participleSuggestion = this.getParticipleSuggestion(word);
        if (participleSuggestion != null) {
            return Collections.singletonList(participleSuggestion);
        }
        if (suggestions.isEmpty() && word.contains("-") && (words = word.split("-")).length > 1) {
            ArrayList<List<String>> suggestionLists = new ArrayList<List<String>>(words.length);
            int startAt = 0;
            int stopAt = words.length;
            String partialWord = words[0] + "-" + words[1];
            if (super.ignoreWord(partialWord) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                startAt = 2;
                suggestionLists.add(Collections.singletonList(words[0] + "-" + words[1]));
            }
            if (super.ignoreWord(partialWord = words[words.length - 2] + "-" + words[words.length - 1]) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                stopAt = words.length - 2;
            }
            for (int idx = startAt; idx < stopAt; ++idx) {
                if (this.hunspellDict.misspelled(words[idx])) {
                    List<String> list = this.sortSuggestionByQuality(words[idx], super.getSuggestions(words[idx]));
                    suggestionLists.add(list);
                    continue;
                }
                suggestionLists.add(Collections.singletonList(words[idx]));
            }
            if (stopAt < words.length - 1) {
                suggestionLists.add(Collections.singletonList(partialWord));
            }
            if (suggestionLists.size() <= 3) {
                ArrayList<String> additionalSuggestions = (ArrayList<String>)suggestionLists.get(0);
                for (int idx = 1; idx < suggestionLists.size(); ++idx) {
                    List suggestionList = (List)suggestionLists.get(idx);
                    ArrayList<String> newList = new ArrayList<String>(additionalSuggestions.size() * suggestionList.size());
                    for (String additionalSuggestion : additionalSuggestions) {
                        for (String aSuggestionList : suggestionList) {
                            newList.add(additionalSuggestion + "-" + aSuggestionList);
                        }
                    }
                    additionalSuggestions = newList;
                }
                return additionalSuggestions.subList(0, Math.min(5, additionalSuggestions.size()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private String getPastTenseVerbSuggestion(String word) {
        if (word.endsWith("e")) {
            String wordStem = word.substring(0, word.length() - 1);
            try {
                AnalyzedToken token;
                String[] forms;
                String lemma = this.baseForThirdPersonSingularVerb(wordStem);
                if (lemma != null && (forms = this.synthesizer.synthesize(token = new AnalyzedToken(lemma, null, lemma), "VER:3:SIN:PRT:.*", true)).length > 0) {
                    return forms[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String baseForThirdPersonSingularVerb(String word) throws IOException {
        List readings = this.tagger.tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings reading : readings) {
            if (!reading.hasPosTagStartingWith("VER:3:SIN:")) continue;
            return ((AnalyzedToken)reading.getReadings().get(0)).getLemma();
        }
        return null;
    }

    @Nullable
    private String getParticipleSuggestion(String word) {
        if (word.startsWith("ge") && word.endsWith("t")) {
            String baseform = word.substring(2, word.length() - 1) + "en";
            try {
                String participle = this.getParticipleForBaseform(baseform);
                if (participle != null) {
                    return participle;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String getParticipleForBaseform(String baseform) throws IOException {
        AnalyzedToken token = new AnalyzedToken(baseform, null, baseform);
        String[] forms = this.synthesizer.synthesize(token, "VER:PA2:.*", true);
        if (forms.length > 0 && !this.hunspellDict.misspelled(forms[0])) {
            return forms[0];
        }
        return null;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) throws IOException {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx + 1);
        boolean bl = isCompound = (nextWord = StringUtils.removeEnd((String)nextWord, (String)".")) != null && (this.compoundTokenizer.tokenize(nextWord).size() > 1 || nextWord.indexOf(45) > 0);
        if (isCompound) {
            boolean isMisspelled = this.hunspellDict.misspelled(word = StringUtils.removeEnd((String)word, (String)"-"));
            if (isMisspelled && (super.ignoreWord(word) || this.wordsToBeIgnoredInCompounds.contains(word))) {
                isMisspelled = false;
            } else if (isMisspelled && word.endsWith("s") && this.isNeedingFugenS(StringUtils.removeEnd((String)word, (String)"s"))) {
                isMisspelled = this.hunspellDict.misspelled(StringUtils.removeEnd((String)word, (String)"s"));
            }
            return !isMisspelled;
        }
        return false;
    }

    private boolean isNeedingFugenS(String word) {
        return StringUtils.endsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"tum", "ling", "ion", "t\u00e4t", "keit", "schaft", "sicht", "ung", "en"});
    }

    @Nullable
    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            String word = words.get(i);
            if (word.endsWith("-") || StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{",", "und", "oder", "sowie"}) || word.trim().isEmpty()) continue;
            return word;
        }
        return null;
    }

    private boolean ignoreCompoundWithIgnoredWord(String word) throws IOException {
        if (!StringTools.startsWithUppercase((String)word) && !StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"nord", "west", "ost", "s\u00fcd", "\u03b1-", "\u03b2-", "\u0263-"})) {
            return false;
        }
        String[] words = word.split("-");
        if (words.length < 2) {
            int end = super.startsWithIgnoredWord(word, true);
            if (end < 3) {
                if (word.startsWith("ost") || word.startsWith("s\u00fcd")) {
                    end = 3;
                } else if (word.startsWith("west") || word.startsWith("nord")) {
                    end = 4;
                } else {
                    return false;
                }
            }
            String ignoredWord = word.substring(0, end);
            String partialWord = word.substring(end);
            boolean isCandidateForNonHyphenatedCompound = !StringUtils.isAllUpperCase((CharSequence)ignoredWord) && (StringUtils.isAllLowerCase((CharSequence)partialWord) || ignoredWord.endsWith("-"));
            boolean needFugenS = this.isNeedingFugenS(ignoredWord);
            if (isCandidateForNonHyphenatedCompound && !needFugenS && partialWord.length() > 1) {
                return !this.hunspellDict.misspelled(partialWord) || !this.hunspellDict.misspelled(StringUtils.capitalize((String)partialWord));
            }
            if (isCandidateForNonHyphenatedCompound && needFugenS && partialWord.length() > 2) {
                partialWord = partialWord.startsWith("s") ? partialWord.substring(1) : partialWord;
                return !this.hunspellDict.misspelled(partialWord) || !this.hunspellDict.misspelled(StringUtils.capitalize((String)partialWord));
            }
            return false;
        }
        boolean hasIgnoredWord = false;
        ArrayList<String> toSpellCheck = new ArrayList<String>(3);
        String stripFirst = word.substring(words[0].length() + 1);
        String stripLast = word.substring(0, word.length() - words[words.length - 1].length() - 1);
        if (super.ignoreWord(stripFirst) || this.wordsToBeIgnoredInCompounds.contains(stripFirst)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[0])) {
                toSpellCheck.add(words[0]);
            }
        } else if (super.ignoreWord(stripLast) || this.wordsToBeIgnoredInCompounds.contains(stripLast)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[words.length - 1])) {
                toSpellCheck.add(words[words.length - 1]);
            }
        } else {
            for (String word1 : words) {
                if (super.ignoreWord(word1) || this.wordsToBeIgnoredInCompounds.contains(word1)) {
                    hasIgnoredWord = true;
                    continue;
                }
                toSpellCheck.add(word1);
            }
        }
        if (hasIgnoredWord) {
            for (String w : toSpellCheck) {
                if (!this.hunspellDict.misspelled(w)) continue;
                return false;
            }
        }
        return hasIgnoredWord;
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        if (idx > 3 && token.startsWith("-")) {
            return StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 1].getToken(), (CharSequence[])new CharSequence[]{"\u201c", "\""}) && StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 3].getToken(), (CharSequence[])new CharSequence[]{"\u201e", "\""});
        }
        return false;
    }

    protected void addProhibitedWords(List<String> words) {
        if (words.size() == 1 && words.get(0).endsWith(".*")) {
            this.wordStartsToBeProhibited.add(words.get(0).substring(0, words.get(0).length() - 2));
        } else {
            super.addProhibitedWords(words);
        }
    }

    static {
        GermanSpellerRule.put("wars", (String w) -> Arrays.asList("war's", "war es"));
        GermanSpellerRule.put("[aA]wa", (String w) -> Arrays.asList("AWA", "ach was", "aber"));
        GermanSpellerRule.put("[aA]lsallerersten?s", (String w) -> Arrays.asList(w.replaceFirst("lsallerersten?s", "ls allererstes"), w.replaceFirst("lsallerersten?s", "ls Allererstes")));
        GermanSpellerRule.putRepl("(an|auf|ein|zu)gehangen(e[mnrs]?)?$", "hangen", "h\u00e4ngt");
        GermanSpellerRule.putRepl("[oO]key", "ey$", "ay");
        GermanSpellerRule.put("packet", "Paket");
        GermanSpellerRule.put("Allalei", "Allerlei");
        GermanSpellerRule.put("geupdate[dt]$", "upgedatet");
        GermanSpellerRule.put("gefaked", "gefakt");
        GermanSpellerRule.put("[pP]roblemhaft(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("haft", "behaftet"), w.replaceFirst("haft", "atisch")));
        GermanSpellerRule.put("rosane[mnrs]?$", (String w) -> Arrays.asList("rosa", w.replaceFirst("^rosan", "rosafarben")));
        GermanSpellerRule.put("Erbung", (String w) -> Arrays.asList("Vererbung", "Erbschaft"));
        GermanSpellerRule.put("Energiesparung", (String w) -> Arrays.asList("Energieeinsparung", "Energieersparnis"));
        GermanSpellerRule.put("Abbrechung", "Abbruch");
        GermanSpellerRule.put("Abbrechungen", (String w) -> Arrays.asList("Abbr\u00fcche", "Abbr\u00fcchen"));
        GermanSpellerRule.put("Urteilung", (String w) -> Arrays.asList("Urteil", "Verurteilung"));
        GermanSpellerRule.put("allm\u00f6glichen?", (String w) -> Arrays.asList("alle m\u00f6glichen", "alle m\u00f6gliche"));
        GermanSpellerRule.put("Krankenhausen", (String w) -> Arrays.asList("Krankenh\u00e4usern", "Krankenh\u00e4user"));
        GermanSpellerRule.put("vorr?auss?etzlich", (String w) -> Arrays.asList("voraussichtlich", "vorausgesetzt"));
        GermanSpellerRule.put("nichtmals", (String w) -> Arrays.asList("nicht mal", "nicht einmal"));
        GermanSpellerRule.put("eingepeilt", "angepeilt");
        GermanSpellerRule.put("gekukt", "geguckt");
        GermanSpellerRule.put("\u00fcberhaut", "\u00fcberhaupt");
        GermanSpellerRule.put("nacher", "nachher");
        GermanSpellerRule.put("jeztz", "jetzt");
        GermanSpellerRule.put("[wW]ah?rscheindlichkeit", "Wahrscheinlichkeit");
        GermanSpellerRule.put("Hijab", "Hidsch\u0101b");
        GermanSpellerRule.putRepl("for?melar(en?)?", "for?me", "Formu");
        GermanSpellerRule.putRepl("n\u00e4ste[mnrs]?$", "^n\u00e4s", "n\u00e4chs");
        GermanSpellerRule.putRepl("Erdogans?$", "^Erdogan", "Erdo\u011fan");
        GermanSpellerRule.put("Germanistiker[ns]", "Germanisten");
        GermanSpellerRule.putRepl("Germanistikerin(nen)?", "Germanistiker", "Germanist");
        GermanSpellerRule.putRepl("[eE]rh\u00f6herung(en)?", "[eE]rh\u00f6herung", "Erh\u00f6hung");
        GermanSpellerRule.putRepl("[vV]orallendingen", "orallendingen", "or allen Dingen");
        GermanSpellerRule.putRepl("[aA]ufjedenfall", "jedenfall$", " jeden Fall");
        GermanSpellerRule.putRepl("^funk?z[ou]nier.+", "funk?z[ou]nier", "funktionier");
        GermanSpellerRule.putRepl("[wW]\u00f6ruber", "\u00f6ru", "or\u00fc");
        GermanSpellerRule.putRepl("[lL]einensamens?", "[lL]einen", "Lein");
        GermanSpellerRule.putRepl("Oldheimer[ns]?", "he", "t");
        GermanSpellerRule.putRepl("unternehmensl[u\u00fc]stig(e[mnrs]?)?", "mensl[u\u00fc]st", "mungslust");
        GermanSpellerRule.putRepl("proff?ess?ional(e[mnrs]?)?", "ff?ess?ional", "fessionell");
        GermanSpellerRule.putRepl("gesundlich(e[mnrs]?)?", "lich", "heitlich");
        GermanSpellerRule.putRepl("eckel(e|t(en?)?|st)?", "^eck", "ek");
        GermanSpellerRule.putRepl("entt?euscht(e[mnrs]?)?", "entt?eusch", "entt\u00e4usch");
        GermanSpellerRule.putRepl("Ph\u00e4hlen?", "^Ph", "Pf");
        GermanSpellerRule.putRepl("Kattermesser[ns]?", "Ka", "Cu");
        GermanSpellerRule.putRepl("gehert(e[mnrs]?)?", "he", "eh");
        GermanSpellerRule.put("kreativlos(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("kreativ", "fantasie"), w.replaceFirst("kreativ", "einfalls"), w.replaceFirst("kreativlos", "unkreativ"), w.replaceFirst("kreativlos", "uninspiriert")));
        GermanSpellerRule.put("Kreativlosigkeit", "Unkreativit\u00e4t");
        GermanSpellerRule.put("hinund?her", "hin und her");
        GermanSpellerRule.put("misverst\u00e4ndniss", "Missverst\u00e4ndnis");
        GermanSpellerRule.put("warheit", "Wahrheit");
        GermanSpellerRule.put("[pP]okemon", "Pok\u00e9mon");
        GermanSpellerRule.put("kreigt", "kriegt");
        GermanSpellerRule.put("Frit\u00f6se", "Fritteuse");
        GermanSpellerRule.put("unerkennlich", "unkenntlich");
        GermanSpellerRule.put("r\u00fcckg[\u00e4e]nglich", "r\u00fcckg\u00e4ngig");
        GermanSpellerRule.put("emen[sz]", "immens");
        GermanSpellerRule.put("verhing", "verh\u00e4ngte");
        GermanSpellerRule.put("verhingen", "verh\u00e4ngten");
        GermanSpellerRule.put("fangte", "fing");
        GermanSpellerRule.put("fangten", "fingen");
        GermanSpellerRule.put("past", "passt");
        GermanSpellerRule.put("Schwitch", "Switch");
        GermanSpellerRule.put("[aA]nwesenzeiten", "Anwesenheitszeiten");
        GermanSpellerRule.put("[gG]eizigkeit", "Geiz");
        GermanSpellerRule.put("[fF]lei\u00dfigkeit", "Flei\u00df");
        GermanSpellerRule.put("[bB]equemheit", "Bequemlichkeit");
        GermanSpellerRule.put("[mM]issionarie?sie?rung", "Missionierung");
        GermanSpellerRule.put("[sS]chee?selonge?", "Chaiselongue");
        GermanSpellerRule.put("Re[kc]amiere", "R\u00e9cami\u00e8re");
        GermanSpellerRule.put("legen[td]lich", "lediglich");
        GermanSpellerRule.put("ein[ua]ndhalb", "eineinhalb");
        GermanSpellerRule.put("[mM]illion(en)?mal", (String w) -> Collections.singletonList(StringTools.uppercaseFirstChar((String)w.replaceFirst("mal", " Mal"))));
        GermanSpellerRule.put("Opelarena", "Opel Arena");
        GermanSpellerRule.put("Toll-Collect", "Toll Collect");
        GermanSpellerRule.put("desweitere[nm]", "des Weiteren");
        GermanSpellerRule.put("handzuhaben", "zu handhaben");
        GermanSpellerRule.put("nachvollzuziehe?n", "nachzuvollziehen");
        GermanSpellerRule.putRepl("indifiziert(e[mnrs]?)?", "ind", "ident");
        GermanSpellerRule.putRepl("dreite[mnrs]?", "dreit", "dritt");
        GermanSpellerRule.putRepl("verbl\u00fcte[mnrs]?", "bl\u00fc", "bl\u00fch");
        GermanSpellerRule.putRepl("(aller)?einzigste[mnrs]?", "(aller)?einzigst", "einzig");
        GermanSpellerRule.putRepl("[iI]nterkurell(e[nmrs]?)?", "ku", "kultu");
        GermanSpellerRule.putRepl("ubera(g|sch)end(e[nmrs]?)?", "uber", "\u00fcberr");
        GermanSpellerRule.putRepl("[wW]olt$", "lt", "llt");
        GermanSpellerRule.putRepl("[zZ]uende", "ue", "u E");
        GermanSpellerRule.putRepl("[iI]nb\u00e4lde", "nb", "n B");
        GermanSpellerRule.putRepl("[lL]etztenendes", "ene", "en E");
        GermanSpellerRule.putRepl("[nN]achwievor", "wievor", " wie vor");
        GermanSpellerRule.putRepl("[zZ]umbeispiel", "beispiel", " Beispiel");
        GermanSpellerRule.putRepl("[gG]ottseidank", "[gG]ottseidank", "Gott sei Dank");
        GermanSpellerRule.putRepl("[gG]rundauf", "[gG]rundauf", "Grund auf");
        GermanSpellerRule.putRepl("[aA]nsichtnach", "[aA]nsicht", "Ansicht ");
        GermanSpellerRule.putRepl("[uU]nswar", "swar", "d zwar");
        GermanSpellerRule.putRepl("[wW]aschte(s?t)?", "aschte", "usch");
        GermanSpellerRule.putRepl("[wW]aschten", "ascht", "usch");
        GermanSpellerRule.putRepl("Probiren?", "ir", "ier");
        GermanSpellerRule.putRepl("[gG]esetztreu(e[nmrs]?)?", "tz", "tzes");
        GermanSpellerRule.putRepl("[wW]ikich(e[nmrs]?)?", "k", "rkl");
        GermanSpellerRule.putRepl("[uU]naufbesichtigt(e[nmrs]?)?", "aufbe", "beauf");
        GermanSpellerRule.putRepl("[nN]utzvoll(e[nmrs]?)?", "utzvoll", "\u00fctzlich");
        GermanSpellerRule.putRepl("Lezte[mnrs]?", "Lez", "Letz");
        GermanSpellerRule.putRepl("Makeups?", "up", "-up");
        GermanSpellerRule.putRepl("Add-?Ons?", "Add-?On", "Add-on");
        GermanSpellerRule.putRepl("Addons?", "on", "-on");
        GermanSpellerRule.putRepl("Internetkaffees?", "kaffee", "caf\u00e9");
        GermanSpellerRule.putRepl("[gG]ehorsamkeitsverweigerung(en)?", "[gG]ehorsamkeit", "Gehorsam");
        GermanSpellerRule.putRepl("[wW]ochende[ns]?", "[wW]ochend", "Wochenend");
        GermanSpellerRule.putRepl("[kK]ongratulier(en?|t(en?)?|st)", "[kK]on", "");
        GermanSpellerRule.putRepl("[wWkKdD]an$", "n$", "nn");
        GermanSpellerRule.putRepl("geh?neh?m[ie]gung(en)?", "geh?neh?m[ie]gung", "Genehmigung");
        GermanSpellerRule.putRepl("Korrigierung(en)?", "igierung", "ektur");
        GermanSpellerRule.putRepl("[kK]orregierung(en)?", "[kK]orregierung", "Korrektur");
        GermanSpellerRule.putRepl("[kK]orrie?girung(en)?", "[kK]orrie?girung", "Korrektur");
        GermanSpellerRule.putRepl("[nN]ocheimal", "eimal", " einmal");
        GermanSpellerRule.putRepl("[aA]benzu", "enzu", " und zu");
        GermanSpellerRule.putRepl("[kK]onflikation(en)?", "[kK]onfli", "Kompli");
        GermanSpellerRule.putRepl("[mM]itanader", "ana", "einan");
        GermanSpellerRule.putRepl("[mM]itenand", "enand", "einander");
        GermanSpellerRule.putRepl("Gelangenheitsbest\u00e4tigung(en)?", "heit", "");
        GermanSpellerRule.putRepl("[jJ]edwillige[mnrs]?", "willig", "wed");
        GermanSpellerRule.putRepl("[qQ]ualit\u00e4ts?bewu\u00dft(e[mnrs]?)?", "ts?bewu\u00dft", "tsbewusst");
        GermanSpellerRule.putRepl("[vV]oraussichtig(e[nmrs]?)?", "sichtig", "sichtlich");
        GermanSpellerRule.putRepl("[gG]leichrechtig(e[nmrs]?)?", "rechtig", "berechtigt");
        GermanSpellerRule.putRepl("[uU]nn\u00fctzlich(e[nmrs]?)?", "n\u00fctzlich", "n\u00fctz");
        GermanSpellerRule.putRepl("[uU]nzerbrechbar(e[nmrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("kolegen?", "ko", "Kol");
        GermanSpellerRule.putRepl("tableten?", "tablet", "Tablett");
        GermanSpellerRule.putRepl("unverantwortungsvoll(e[nmrs]?)?", "unverantwortungsvoll", "verantwortungslos");
        GermanSpellerRule.putRepl("[gG]erechtlichkeit", "[gG]erechtlich", "Gerechtig");
        GermanSpellerRule.putRepl("[zZ]uverl\u00e4sslichkeit", "lich", "ig");
        GermanSpellerRule.putRepl("[uU]nverzeilig(e[mnrs]?)?", "zeilig", "zeihlich");
        GermanSpellerRule.putRepl("[zZ]uk(ue?|\u00fc)nftlich(e[mnrs]?)?", "uk(ue?|\u00fc)nftlich", "uk\u00fcnftig");
        GermanSpellerRule.putRepl("[rR]eligi\u00f6sisch(e[nmrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[fF]olklorisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlsvoll(e[nmrs]?)?", "voll", "am");
        GermanSpellerRule.putRepl("todesbedroh(end|lich)(e[nmrs]?)?", "todes", "lebens");
        GermanSpellerRule.putRepl("^[uU]nabsichtig(e[nmrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[aA]ntisemitistisch(e[mnrs]?)?", "tist", "t");
        GermanSpellerRule.putRepl("[uU]nvorsehbar(e[mnrs]?)?", "vor", "vorher");
        GermanSpellerRule.putRepl("([eE]r|[bB]e|unter|[aA]uf)?h\u00e4lst", "h\u00e4lst", "h\u00e4ltst");
        GermanSpellerRule.put("[wW]ohlf\u00fchlseins?", (String w) -> Arrays.asList("Wellness", w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlbefinden"), w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlf\u00fchlen")));
        GermanSpellerRule.putRepl("[sS]chmett?e?rling(s|en?)?", "[sS]chmett?e?rling", "Schmetterling");
        GermanSpellerRule.putRepl("^[eE]inlamie?nie?r(st|en?|(t(e[nmrs]?)?))?", "^einlamie?nie?r", "laminier");
        GermanSpellerRule.putRepl("[bB]ravur\u00f6s(e[nrms]?)?", "vur", "vour");
        GermanSpellerRule.putRepl("[aA]ss?ecoires?", "[aA]ss?ec", "Access");
        GermanSpellerRule.putRepl("[aA]ufwechse?lungsreich(er|st)?(e[nmrs]?)?", "ufwechse?lung", "bwechslung");
        GermanSpellerRule.putRepl("[iI]nordnung", "ordnung", " Ordnung");
        GermanSpellerRule.putRepl("[iI]mmoment", "moment", " Moment");
        GermanSpellerRule.putRepl("[wW]ienerschnitzel[ns]?", "[wW]ieners", "Wiener S");
        GermanSpellerRule.putRepl("[sS]chwarzw\u00e4lderkirschtorten?", "[sS]chwarzw\u00e4lderk", "Schwarzw\u00e4lder K");
        GermanSpellerRule.putRepl("[kK]oxial(e[nmrs]?)?", "x", "ax");
        GermanSpellerRule.putRepl("[dD]urs?chnitt?lich(e[nmrs]?)?", "s?chnitt?", "chschnitt");
        GermanSpellerRule.putRepl("[oO]rganisativ(e[nmrs]?)?", "tiv", "torisch");
        GermanSpellerRule.putRepl("[kK]ontaktfreundlich(e[nmrs]?)?", "ndlich", "dig");
        GermanSpellerRule.put("[oO]r?ganisazion", "Organisation");
        GermanSpellerRule.put("[oO]rganisative", "Organisation");
        GermanSpellerRule.putRepl("[hH]eilei[td]s?", "[hH]eilei[td]", "Highlight");
        GermanSpellerRule.putRepl("[mM]atschscheiben?", "[mM]atschsch", "Mattsch");
        GermanSpellerRule.put("schafen?", (String w) -> Arrays.asList(w.replaceFirst("sch", "schl"), w.replaceFirst("af", "arf"), w.replaceFirst("af", "aff")));
        GermanSpellerRule.putRepl("[hH]ofen?", "of", "off");
        GermanSpellerRule.putRepl("[sS]ommerverien?", "[sS]ommerverien?", "Sommerferien");
        GermanSpellerRule.putRepl("[rR]ecourcen?", "[rR]ec", "Ress");
        GermanSpellerRule.putRepl("[fF]amm?ill?i?[a\u00e4]risch(e[mnrs]?)?", "amm?ill?i?[a\u00e4]risch", "amili\u00e4r");
        GermanSpellerRule.putRepl("Sim-Karten?", "^Sim", "SIM");
        GermanSpellerRule.putRepl("Spax-Schrauben?", "^Spax", "SPAX");
        GermanSpellerRule.putRepl("[aA]leine", "l", "ll");
        GermanSpellerRule.putRepl("Kaput", "t", "tt");
        GermanSpellerRule.putRepl("[fF]estell(s?t|en?)", "est", "estst");
        GermanSpellerRule.putRepl("(Baden-)?W\u00fcrtenbergs?", "W\u00fcrten", "W\u00fcrttem");
        GermanSpellerRule.putRepl("Betriebsratzimmer[ns]?", "rat", "rats");
        GermanSpellerRule.putRepl("Rechts?schreibungsfehler[ns]?", "Rechts?schreibungs", "Rechtschreib");
        GermanSpellerRule.putRepl("Open[aA]ir-Konzert(en?)?", "Open[aA]ir", "Open-Air");
        GermanSpellerRule.putRepl("Jugenschuhen?", "Jug", "Jung");
        GermanSpellerRule.putRepl("TODO-Listen?", "TODO", "To-do");
        GermanSpellerRule.putRepl("ausiehs?t", "aus", "auss");
        GermanSpellerRule.putRepl("unterbemittel(nd|t)(e[nmrs]?)?", "unterbemittel(nd|t)", "minderbemittelt");
        GermanSpellerRule.putRepl("[xX]te[mnrs]?", "te", "-te");
        GermanSpellerRule.put("[zZ]oolophie", "Zoophilie");
        GermanSpellerRule.put("Makieren", "Markieren");
        GermanSpellerRule.put("Altersheimer", "Alzheimer");
        GermanSpellerRule.put("gesen", "gesehen");
        GermanSpellerRule.put("Neugierigkeit", (String w) -> Arrays.asList("Neugier", "Neugierde"));
        GermanSpellerRule.put("[kK]onn?ekt?schen", "Connection");
        GermanSpellerRule.put("E-Maul", "E-Mail");
        GermanSpellerRule.put("E-Mauls", "E-Mails");
        GermanSpellerRule.put("E-Mal", "E-Mail");
        GermanSpellerRule.put("E-Mals", "E-Mails");
        GermanSpellerRule.put("[nN]ah?richt", "Nachricht");
        GermanSpellerRule.put("[nN]ah?richten", "Nachrichten");
        GermanSpellerRule.put("Getrixe", "Getrickse");
        GermanSpellerRule.put("Ausage", "Aussage");
        GermanSpellerRule.put("gelessen", "gelesen");
        GermanSpellerRule.put("Kanst", "Kannst");
        GermanSpellerRule.put("Unwohlbefinden", "Unwohlsein");
        GermanSpellerRule.put("leiwagen", "Leihwagen");
        GermanSpellerRule.put("krahn", "Kran");
        GermanSpellerRule.put("[hH]ifi", "Hi-Fi");
        GermanSpellerRule.put("chouch", "Couch");
        GermanSpellerRule.put("eh?rgeit?z", "Ehrgeiz");
        GermanSpellerRule.put("solltes", "solltest");
        GermanSpellerRule.put("geklabt", "geklappt");
        GermanSpellerRule.put("angefangt", "angefangen");
        GermanSpellerRule.put("beinh\u00e4lt", "beinhaltet");
        GermanSpellerRule.put("einhaltest", "einh\u00e4ltst");
        GermanSpellerRule.put("\u00fcbers\u00e4ht", "\u00fcbers\u00e4t");
        GermanSpellerRule.put("staats?angehoe?rigkeit", "Staatsangeh\u00f6rigkeit");
        GermanSpellerRule.put("[uU]nangeneh?mheiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Humuspaste", "Hummuspaste");
        GermanSpellerRule.put("afarung", "Erfahrung");
        GermanSpellerRule.put("bescheid?t", "Bescheid");
        GermanSpellerRule.put("[mM]iteillung", "Mitteilung");
        GermanSpellerRule.put("Revisionierung", "Revision");
        GermanSpellerRule.put("[eE]inf\u00fchlverm\u00f6gen", "Einf\u00fchlungsverm\u00f6gen");
        GermanSpellerRule.put("[sS]peziellisierung", "Spezialisierung");
        GermanSpellerRule.put("[cC]hangse", "Chance");
        GermanSpellerRule.put("untergangen", "untergegangen");
        GermanSpellerRule.put("BluRay", "Blu-ray");
        GermanSpellerRule.put("Freiwilligerin", "Freiwillige");
        GermanSpellerRule.put("Mitgliederinnen", (String w) -> Arrays.asList("Mitglieder", "Mitgliedern"));
        GermanSpellerRule.put("Hautreinheiten", "Hautunreinheiten");
        GermanSpellerRule.put("tuhen", "tun");
        GermanSpellerRule.put("ccm", "cm\u00b3");
        GermanSpellerRule.put("Kilimand?jaro", "Kilimandscharo");
        GermanSpellerRule.put("[hH]erausfordung", "Herausforderung");
        GermanSpellerRule.put("[bB]er\u00fccksichtung", "Ber\u00fccksichtigung");
        GermanSpellerRule.put("artzt?", "Arzt");
        GermanSpellerRule.put("[tT]h?elepath?ie", "Telepathie");
        GermanSpellerRule.put("Wi-?Fi-Dire[ck]t", "Wi-Fi Direct");
        GermanSpellerRule.put("gans", "ganz");
        GermanSpellerRule.put("Pearl-Harbou?r", "Pearl Harbor");
        GermanSpellerRule.put("[aA]utonomit\u00e4t", "Autonomie");
        GermanSpellerRule.put("[fF]r[u\u00fc]h?st[u\u00fc]c?k", "Fr\u00fchst\u00fcck");
        GermanSpellerRule.put("zucc?h?inis?", "Zucchini");
        GermanSpellerRule.put("[mM]itag", "Mittag");
        GermanSpellerRule.put("Lexion", "Lexikon");
        GermanSpellerRule.put("[mM]otorisation", "Motorisierung");
        GermanSpellerRule.put("[mM]enegment", "Management");
        GermanSpellerRule.put("[iI]nstall?at\u00f6r", "Installateur");
        GermanSpellerRule.put("maletriert", "maltr\u00e4tiert");
        GermanSpellerRule.put("abgeschaffen", "abgeschafft");
        GermanSpellerRule.put("Verschiden", "Verschieden");
        GermanSpellerRule.put("Anschovis", "Anchovis");
        GermanSpellerRule.put("Bravur", "Bravour");
        GermanSpellerRule.put("Grisli", "Grizzly");
        GermanSpellerRule.put("Grislib\u00e4r", "Grizzlyb\u00e4r");
        GermanSpellerRule.put("Grislib\u00e4ren", "Grizzlyb\u00e4ren");
        GermanSpellerRule.put("Frott\u00e9", "Frottee");
        GermanSpellerRule.put("Joga", "Yoga");
        GermanSpellerRule.put("Kalvinismus", "Calvinismus");
        GermanSpellerRule.put("Kollier", "Collier");
        GermanSpellerRule.put("Kolliers", "Colliers");
        GermanSpellerRule.put("Ketschup", "Ketchup");
        GermanSpellerRule.put("Kommunikee", "Kommuniqu\u00e9");
        GermanSpellerRule.put("Negligee", "Neglig\u00e9");
        GermanSpellerRule.put("Nessess\u00e4r", "Necessaire");
        GermanSpellerRule.put("passee", "pass\u00e9");
        GermanSpellerRule.put("Varietee", "Variet\u00e9");
        GermanSpellerRule.put("Varietees", "Variet\u00e9s");
        GermanSpellerRule.put("Wandalismus", "Vandalismus");
        GermanSpellerRule.put("Campagne", "Kampagne");
        GermanSpellerRule.put("Campagnen", "Kampagnen");
        GermanSpellerRule.put("Jockei", "Jockey");
        GermanSpellerRule.put("Roulett", "Roulette");
        splitter = GermanSpellerRule.getSplitter();
    }

    static class ExpandingReader
    extends BufferedReader {
        private final List<String> buffer = new ArrayList<String>();
        private final LineExpander lineExpander = new LineExpander();

        ExpandingReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            if (this.buffer.isEmpty()) {
                String line = super.readLine();
                if (line == null) {
                    return null;
                }
                this.buffer.addAll(this.lineExpander.expandLine(line));
            }
            return this.buffer.remove(0);
        }
    }
}

