/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionSet;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.tools.StringTools;

public class ProhibitedCompoundRule
extends Rule {
    public static final String RULE_ID = "DE_PROHIBITED_COMPOUNDS";
    private static final List<Pair> lowercasePairs = Arrays.asList(new Pair("uhr", "Instrument zur Zeitmessung", "ur", "urspr\u00fcnglich"), new Pair("abschluss", "Ende", "abschuss", "Vorgang des Abschie\u00dfens, z.B. mit einer Waffe"), new Pair("brache", "verlassenes Grundst\u00fcck", "branche", "Wirtschaftszweig"), new Pair("wieder", "erneut, wiederholt, nochmal (Wiederholung, Wiedervorlage, ...)", "wider", "gegen, entgegen (Widerwille, Widerstand, Widerspruch, ...)"), new Pair("leer", "ohne Inhalt", "lehr", "bezogen auf Ausbildung und Wissen"), new Pair("gewerbe", "wirtschaftliche T\u00e4tigkeit", "gewebe", "gewebter Stoff; Verbund \u00e4hnlicher Zellen"), new Pair("schuh", "Fu\u00dfbekleidung", "schul", "auf die Schule bezogen"), new Pair("klima", "langfristige Wetterzust\u00e4nde", "lima", "Hauptstadt von Peru"), new Pair("modell", "vereinfachtes Abbild der Wirklichkeit", "model", "Fotomodell"), new Pair("treppen", "Folge von Stufen (Mehrzahl)", "truppen", "Armee oder Teil einer Armee (Mehrzahl)"), new Pair("h\u00e4ufigkeit", "Anzahl von Ereignissen", "h\u00e4utigkeit", "z.B. in Dunkelh\u00e4utigkeit"), new Pair("hin", "in Richtung", "hirn", "Gehirn, Denkapparat"), new Pair("verkl\u00e4rung", "Besch\u00f6nigung, Darstellung in einem besseren Licht", "erkl\u00e4rung", "Darstellung, Erl\u00e4uterung"), new Pair("spitze", "spitzes Ende eines Gegenstandes", "spritze", "medizinisches Instrument zur Injektion"));
    private static final GermanSpellerRule spellerRule = new GermanSpellerRule(JLanguageTool.getMessageBundle(), new GermanyGerman(), null, null);
    private static final List<String> ignoreWords = Arrays.asList("Die", "De");
    private static final List<Pair> pairs = new ArrayList<Pair>();
    private final BaseLanguageModel lm;
    private Pair confusionPair = null;
    private AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie = null;
    private Map<String, List<Pair>> pairMap = new HashMap<String, List<Pair>>();

    private static void addAllCaseVariants(List<Pair> candidatePairs, Pair lcPair) {
        candidatePairs.add(new Pair(lcPair.part1, lcPair.part1Desc, lcPair.part2, lcPair.part2Desc));
        String ucPart1 = StringTools.uppercaseFirstChar((String)lcPair.part1);
        String ucPart2 = StringTools.uppercaseFirstChar((String)lcPair.part2);
        if (!lcPair.part1.equals(ucPart1) || !lcPair.part2.equals(ucPart2)) {
            candidatePairs.add(new Pair(ucPart1, lcPair.part1Desc, ucPart2, lcPair.part2Desc));
        }
    }

    private static void addUpperCaseVariants() {
        for (Pair lcPair : lowercasePairs) {
            if (StringTools.startsWithUppercase((String)lcPair.part1)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part1);
            }
            if (StringTools.startsWithUppercase((String)lcPair.part2)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part2);
            }
            ProhibitedCompoundRule.addAllCaseVariants(pairs, lcPair);
        }
    }

    private static void addItemsFromConfusionSets(String confusionSetsFile, boolean isUpperCase) {
        try {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(confusionSetsFile);){
                ConfusionSetLoader loader = new ConfusionSetLoader();
                Map confusionSet = loader.loadConfusionSet(confusionSetStream);
                for (Map.Entry entry : confusionSet.entrySet()) {
                    for (ConfusionSet set : (List)entry.getValue()) {
                        boolean allUpper = set.getSet().stream().allMatch(k -> StringTools.startsWithUppercase((String)k.getString()) && !ignoreWords.contains(k.getString()));
                        if (!allUpper && isUpperCase) continue;
                        Set cSet = set.getSet();
                        if (cSet.size() != 2) {
                            throw new RuntimeException("Got confusion set with != 2 items: " + cSet);
                        }
                        Iterator it = cSet.iterator();
                        ConfusionString part1 = (ConfusionString)it.next();
                        ConfusionString part2 = (ConfusionString)it.next();
                        pairs.add(new Pair(part1.getString(), part1.getDescription(), part2.getString(), part2.getDescription()));
                        if (isUpperCase) {
                            pairs.add(new Pair(StringTools.lowercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.lowercaseFirstChar((String)part2.getString()), part2.getDescription()));
                            continue;
                        }
                        pairs.add(new Pair(StringTools.uppercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.uppercaseFirstChar((String)part2.getString()), part2.getDescription()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ProhibitedCompoundRule(ResourceBundle messages, LanguageModel lm) {
        this.lm = (BaseLanguageModel)Objects.requireNonNull(lm);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setupAhoCorasickSearch();
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "Markiert wahrscheinlich falsche Komposita wie 'Lehrzeile', wenn 'Leerzeile' h\u00e4ufiger vorkommt.";
    }

    private void setupAhoCorasickSearch() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Pair pair : pairs) {
            map.put(pair.part1, pair.part1);
            map.put(pair.part2, pair.part2);
            this.pairMap.putIfAbsent(pair.part1, new LinkedList());
            this.pairMap.putIfAbsent(pair.part2, new LinkedList());
            this.pairMap.get(pair.part1).add(pair);
            this.pairMap.get(pair.part2).add(pair);
        }
        this.ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie();
        this.ahoCorasickDoubleArrayTrie.build(map);
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        block0: for (AnalyzedTokenReadings readings : sentence.getTokensWithoutWhitespace()) {
            String word = readings.getToken();
            if (!readings.hasPartialPosTag("SUB") || word.length() <= 6) continue;
            ArrayList<Pair> candidatePairs = new ArrayList<Pair>();
            if (this.confusionPair == null) {
                List wordList = this.ahoCorasickDoubleArrayTrie.parseText(word);
                for (AhoCorasickDoubleArrayTrie.Hit hit : wordList) {
                    List<Pair> pair = this.pairMap.get(hit.value);
                    if (pair == null) continue;
                    candidatePairs.addAll(pair);
                }
            } else {
                ProhibitedCompoundRule.addAllCaseVariants(candidatePairs, this.confusionPair);
            }
            for (Pair pair : candidatePairs) {
                String variant = null;
                if (word.contains(pair.part1)) {
                    variant = word.replaceFirst(pair.part1, pair.part2);
                } else if (word.contains(pair.part2)) {
                    variant = word.replaceFirst(pair.part2, pair.part1);
                }
                if (variant == null) continue;
                long wordCount = this.lm.getCount(word);
                long variantCount = this.lm.getCount(variant);
                if (variantCount <= 0L || wordCount != 0L || spellerRule.isMisspelled(variant)) continue;
                String msg = pair.part1Desc != null && pair.part2Desc != null ? "M\u00f6glicher Tippfehler. " + StringTools.uppercaseFirstChar((String)pair.part1) + ": " + pair.part1Desc + ", " + StringTools.uppercaseFirstChar((String)pair.part2) + ": " + pair.part2Desc : "M\u00f6glicher Tippfehler: " + pair.part1 + "/" + pair.part2;
                RuleMatch match = new RuleMatch((Rule)this, sentence, readings.getStartPos(), readings.getEndPos(), msg);
                match.setSuggestedReplacement(variant);
                ruleMatches.add(match);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public void setConfusionPair(Pair confusionPair) {
        this.confusionPair = confusionPair;
    }

    static {
        ProhibitedCompoundRule.addUpperCaseVariants();
        ProhibitedCompoundRule.addItemsFromConfusionSets("/de/confusion_sets.txt", true);
    }

    public static class Pair {
        private final String part1;
        private final String part1Desc;
        private final String part2;
        private final String part2Desc;

        public Pair(String part1, String part1Desc, String part2, String part2Desc) {
            this.part1 = part1;
            this.part1Desc = part1Desc;
            this.part2 = part2;
            this.part2Desc = part2Desc;
        }

        public String toString() {
            return this.part1 + "/" + this.part2;
        }
    }
}

