/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.Unit;
import org.languagetool.rules.AbstractUnitConversionRule;
import tech.units.indriya.unit.Units;

public class UnitConversionRule
extends AbstractUnitConversionRule {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.GERMANY);

    public UnitConversionRule(ResourceBundle messages) {
        super(messages);
        this.format.setMaximumFractionDigits(2);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.addUnit("Kilo(gramm)?", (Unit)Units.KILOGRAM, "Kilogramm", 1.0, true);
        this.addUnit("Gramm", (Unit)Units.KILOGRAM, "Gramm", 0.001, true);
        this.addUnit("Tonnen?", (Unit)Units.KILOGRAM, "Tonnen", 1000.0, true);
        this.addUnit("Pfund", POUND, "Pfund", 1.0, false);
        this.addUnit("Meilen?", MILE, "Meile", 1.0, false);
        this.addUnit("Yard", YARD, "Yard", 1.0, false);
        this.addUnit("Fu\u00df", FEET, "Fu\u00df", 1.0, false);
        this.addUnit("Zoll", INCH, "Zoll", 1.0, false);
        this.addUnit("(Kilometer pro Stunde|Stundenkilometer)", Units.KILOMETRE_PER_HOUR, "Kilometer pro Stunde", 1.0, true);
        this.addUnit("Meilen pro Stunde", MILE.divide(Units.HOUR), "Meilen pro Stunde", 1.0, false);
        this.addUnit("Meter", Units.METRE, "Meter", 1.0, true);
        this.addUnit("Kilometer", Units.METRE, "Kilometer", 1000.0, true);
        this.addUnit("Dezimeter", Units.METRE, "Dezimeter", 0.1, false);
        this.addUnit("Zentimeter", Units.METRE, "Zentimeter", 0.01, true);
        this.addUnit("Millimeter", Units.METRE, "Millimeter", 0.001, true);
        this.addUnit("Mikrometer", Units.METRE, "Mikrometer", 1.0E-6, true);
        this.addUnit("Nanometer", Units.METRE, "Nanometer", 1.0E-9, true);
        this.addUnit("Pikometer", Units.METRE, "Pikometer", 1.0E-12, true);
        this.addUnit("Femtometer", Units.METRE, "Femtometer", 1.0E-15, true);
        this.addUnit("Quadratmeter", Units.SQUARE_METRE, "Quadratmeter", 1.0, true);
        this.addUnit("Hektar", Units.SQUARE_METRE, "Hektar", 10000.0, true);
        this.addUnit("Ar", Units.SQUARE_METRE, "Ar", 100.0, true);
        this.addUnit("Quadratkilometer", Units.SQUARE_METRE, "Quadratkilometer", 1000000.0, true);
        this.addUnit("Quadratdezimeter", Units.SQUARE_METRE, "Quadratdezimeter", 0.01, false);
        this.addUnit("Quadratzentimeter", Units.SQUARE_METRE, "Quadratzentimeter", 1.0E-4, true);
        this.addUnit("Quadratmillimeter", Units.SQUARE_METRE, "Quadratmillimeter", 1.0E-6, true);
        this.addUnit("Quadratmikrometer", Units.SQUARE_METRE, "Quadratmikrometer", 1.0E-12, true);
        this.addUnit("Quadratnanometer", Units.SQUARE_METRE, "Quadratnanometer", 1.0E-18, true);
        this.addUnit("Kubikmeter", Units.CUBIC_METRE, "Kubikmeter", 1.0, true);
        this.addUnit("Kubikkilometer", Units.CUBIC_METRE, "Kubikkilometer", 1.0E9, true);
        this.addUnit("Kubikdezimeter", Units.CUBIC_METRE, "Kubikdezimeter", 0.001, false);
        this.addUnit("Kubikzentimeter", Units.CUBIC_METRE, "Kubikzentimeter", 1.0E-6, true);
        this.addUnit("Kubikmillimeter", Units.CUBIC_METRE, "Kubikmillimeter", 1.0E-9, true);
        this.addUnit("Kubikmikrometer", Units.CUBIC_METRE, "Kubikmikrometer", 1.0E-18, true);
        this.addUnit("Kubiknanometer", Units.CUBIC_METRE, "Kubiknanometer", 1.0E-27, true);
        this.addUnit("Liter", Units.LITRE, "Liter", 1.0, true);
        this.addUnit("Milliliter", Units.LITRE, "Milliliter", 0.001, true);
        this.addUnit("(?:Grad)? Fahrenheit", FAHRENHEIT, "Grad Fahrenheit", 1.0, false);
        this.addUnit("(?:Grad)? Celsius", (Unit)Units.CELSIUS, "Grad Celsius", 1.0, true);
    }

    public String getId() {
        return "EINHEITEN_METRISCH";
    }

    public String getDescription() {
        return "Schl\u00e4gt vor oder \u00fcberpr\u00fcft Angaben des metrischen \u00c4quivalentes bei bestimmten Ma\u00dfeinheiten.";
    }

    protected String getMessage(AbstractUnitConversionRule.Message message) {
        switch (message) {
            case CHECK: {
                return "Diese Umrechnung scheint falsch zu sein. Wollen Sie sie automatisch korrigieren lassen?";
            }
            case SUGGESTION: {
                return "Wollen Sie eine Umwandlung ins metrische System automatisch hinzuf\u00fcgen?";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "Die in dieser Umrechnung verwendete Einheit wurde nicht erkannt.";
            }
            case UNIT_MISMATCH: {
                return "Diese Einheiten sind nicht kompatibel.";
            }
        }
        throw new RuntimeException("Unknown message type." + message);
    }

    protected String getShortMessage(AbstractUnitConversionRule.Message message) {
        switch (message) {
            case CHECK: {
                return "Falsche Umrechung. Automatisch korrigieren?";
            }
            case SUGGESTION: {
                return "Metrisches \u00c4quivalent hinzuf\u00fcgen?";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "Unbekannte Einheit.";
            }
            case UNIT_MISMATCH: {
                return "Inkompatible Einheiten.";
            }
        }
        throw new RuntimeException("Unknown message type." + message);
    }

    protected NumberFormat getNumberFormat() {
        return this.format;
    }
}

