/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.GermanChunker;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundCoherencyRule;
import org.languagetool.rules.de.CompoundInfinitivRule;
import org.languagetool.rules.de.CompoundRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.DuUpperLowerCaseRule;
import org.languagetool.rules.de.GermanConfusionProbabilityRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanFillerWordsRule;
import org.languagetool.rules.de.GermanParagraphRepeatBeginningRule;
import org.languagetool.rules.de.GermanReadabilityRule;
import org.languagetool.rules.de.GermanStyleRepeatedWordRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.LongSentenceRule;
import org.languagetool.rules.de.MissingVerbRule;
import org.languagetool.rules.de.OldSpellingRule;
import org.languagetool.rules.de.ProhibitedCompoundRule;
import org.languagetool.rules.de.SentenceWhitespaceRule;
import org.languagetool.rules.de.SimilarNameRule;
import org.languagetool.rules.de.SubjectVerbAgreementRule;
import org.languagetool.rules.de.UnitConversionRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRuleCreator;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;

public class German
extends Language
implements AutoCloseable {
    private static final Language GERMANY_GERMAN = new GermanyGerman();
    protected Tagger tagger;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private Disambiguator disambiguator;
    private GermanChunker chunker;
    private CompoundWordTokenizer compoundTokenizer;
    private GermanCompoundTokenizer strictCompoundTokenizer;
    private LanguageModel languageModel;
    private List<Rule> nnRules;
    private Word2VecModel word2VecModel;

    @Deprecated
    public German() {
    }

    public Language getDefaultLanguageVariant() {
        return GERMANY_GERMAN;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new GermanRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public Chunker getPostDisambiguationChunker() {
        if (this.chunker == null) {
            this.chunker = new GermanChunker();
        }
        return this.chunker;
    }

    public String getName() {
        return "German";
    }

    public String getShortCode() {
        return "de";
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tagger getTagger() {
        Object t = this.tagger;
        if (t == null) {
            German german = this;
            synchronized (german) {
                t = this.tagger;
                if (t == null) {
                    this.tagger = t = new GermanTagger();
                }
            }
        }
        return t;
    }

    @NotNull
    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new GermanSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"Die Partei<marker> ,</marker> die die letzte Wahl gewann."), Example.fixed((String)"Die Partei<marker>,</marker> die die letzte Wahl gewann.")), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u00bb", "\u00ab", "\""), Arrays.asList("]", ")", "}", "\u201c", "\u00ab", "\u00bb", "\"")), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Das Haus ist alt. <marker>es</marker> wurde 1950 gebaut."), Example.fixed((String)"Das Haus ist alt. <marker>Es</marker> wurde 1950 gebaut.")), new MultipleWhitespaceRule(messages, (Language)this), new OldSpellingRule(messages), new SentenceWhitespaceRule(messages), new GermanDoublePunctuationRule(messages), new MissingVerbRule(messages, this), new GermanWordRepeatRule(messages, this), new GermanWordRepeatBeginningRule(messages, this), new GermanWrongWordInContextRule(messages), new AgreementRule(messages, this), new CaseRule(messages, this), new CompoundRule(messages), new DashRule(messages), new VerbAgreementRule(messages, this), new SubjectVerbAgreementRule(messages, this), new WordCoherencyRule(messages), new SimilarNameRule(messages), new WiederVsWiderRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new GermanStyleRepeatedWordRule(messages, this, userConfig), new CompoundCoherencyRule(messages), new LongSentenceRule(messages, userConfig), new LongParagraphRule(messages, (Language)this, userConfig), new GermanFillerWordsRule(messages, this, userConfig), new GermanParagraphRepeatBeginningRule(messages, this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new DuUpperLowerCaseRule(messages), new UnitConversionRule(messages), new GermanReadabilityRule(messages, this, userConfig, true), new GermanReadabilityRule(messages, this, userConfig, false), new CompoundInfinitivRule(messages, this, userConfig)});
    }

    public CompoundWordTokenizer getNonStrictCompoundSplitter() {
        if (this.compoundTokenizer == null) {
            try {
                GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer(false);
                this.compoundTokenizer = word -> new ArrayList<String>(tokenizer.tokenize(word));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up German compound splitter", e);
            }
        }
        return this.compoundTokenizer;
    }

    public GermanCompoundTokenizer getStrictCompoundTokenizer() {
        if (this.strictCompoundTokenizer == null) {
            try {
                this.strictCompoundTokenizer = new GermanCompoundTokenizer();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up strict German compound splitter", e);
            }
        }
        return this.strictCompoundTokenizer;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public synchronized Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        if (this.word2VecModel == null) {
            this.word2VecModel = new Word2VecModel(indexDir + File.separator + this.getShortCode());
        }
        return this.word2VecModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new GermanConfusionProbabilityRule(messages, languageModel, this), new ProhibitedCompoundRule(messages, languageModel)});
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        if (this.nnRules == null) {
            this.nnRules = NeuralNetworkRuleCreator.createRules((ResourceBundle)messages, (Language)this, (Word2VecModel)word2vecModel);
        }
        return this.nnRules;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public int getPriorityForId(String id) {
        switch (id) {
            case "OLD_SPELLING_INTERNAL": {
                return 10;
            }
            case "DE_PROHIBITED_COMPOUNDS": {
                return 1;
            }
            case "ANS_OHNE_APOSTROPH": {
                return 1;
            }
            case "CONFUSION_RULE": {
                return -1;
            }
            case "AKZENT_STATT_APOSTROPH": {
                return -1;
            }
            case "PUNKT_ENDE_ABSATZ": {
                return -10;
            }
            case "KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ": {
                return -10;
            }
        }
        return 0;
    }
}

