/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleRepeatedWordRule;
import org.languagetool.rules.Categories;

public class GermanStyleRepeatedWordRule
extends AbstractStyleRepeatedWordRule {
    private static final String SYNONYMS_URL = "https://www.openthesaurus.de/synonyme/";

    public GermanStyleRepeatedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig);
        super.setCategory(Categories.STYLE.getCategory(messages));
    }

    public String getId() {
        return "STYLE_REPEATED_WORD_RULE_DE";
    }

    public String getDescription() {
        return "Wiederholte Worte in aufeinanderfolgenden S\u00e4tzen";
    }

    protected String messageSameSentence() {
        return "Stilproblem: Das Wort wird bereits im selben Satz verwendet!";
    }

    protected String messageSentenceBefore() {
        return "Stilproblem: Das Wort wird bereits in einem vorhergehenden Satz verwendet!";
    }

    protected String messageSentenceAfter() {
        return "Stilproblem: Das Wort wird bereits in einem nachfolgenden Satz verwendet!";
    }

    private static boolean isUnknownWord(AnalyzedTokenReadings token) {
        return token.isPosTagUnknown() && token.getToken().length() > 2 && token.getToken().matches("^[A-Za-z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+$");
    }

    protected boolean isTokenToCheck(AnalyzedTokenReadings token) {
        return token.matchesPosTagRegex("(SUB|EIG|VER|ADJ):.*") && !token.matchesPosTagRegex("(PRO|ART|ADV|VER:(AUX|MOD)):.*") && !token.getToken().equals("Ich") || GermanStyleRepeatedWordRule.isUnknownWord(token);
    }

    protected boolean isTokenPair(AnalyzedTokenReadings[] tokens, int n, boolean before) {
        return before ? tokens[n - 2].hasPosTagStartingWith("SUB:") && tokens[n - 1].hasPosTagStartingWith("PRP:") && tokens[n].hasPosTagStartingWith("SUB:") : tokens[n].hasPosTagStartingWith("SUB:") && tokens[n + 1].hasPosTagStartingWith("PRP:") && tokens[n + 2].hasPosTagStartingWith("SUB:");
    }

    protected boolean isPartOfWord(String testTokenText, String tokenText) {
        return (testTokenText.startsWith(tokenText) || testTokenText.endsWith(tokenText) || tokenText.startsWith(testTokenText) || tokenText.endsWith(testTokenText)) && (testTokenText.length() == tokenText.length() || testTokenText.length() < tokenText.length() - 3 || testTokenText.length() > tokenText.length() + 3) || testTokenText.equals(tokenText + "s") || tokenText.equals(testTokenText + "s");
    }

    protected URL setURL(AnalyzedTokenReadings token) throws MalformedURLException {
        if (token != null) {
            List readings = token.getReadings();
            ArrayList<String> lemmas = new ArrayList<String>();
            for (AnalyzedToken reading : readings) {
                String lemma = reading.getLemma();
                if (lemma == null) continue;
                lemmas.add(lemma);
            }
            if (lemmas.size() == 1) {
                return new URL(SYNONYMS_URL + (String)lemmas.get(0));
            }
            return new URL(SYNONYMS_URL + token.getToken());
        }
        return null;
    }
}

