/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SpellingData;

class SpellingRuleWithSuggestion {
    private final Rule rule;
    private final String alternative;
    private final String suggestion;

    SpellingRuleWithSuggestion(Rule rule, String alternative, String suggestion) {
        this.rule = Objects.requireNonNull(rule);
        this.alternative = Objects.requireNonNull(alternative);
        this.suggestion = Objects.requireNonNull(suggestion);
    }

    static List<RuleMatch> computeMatches(AnalyzedSentence sentence, SpellingData data, String[] exceptions) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (SpellingRuleWithSuggestion ruleWithSuggestion : data.get()) {
            RuleMatch[] matches;
            Rule rule = ruleWithSuggestion.rule;
            for (RuleMatch match : matches = rule.match(sentence)) {
                String suggestion;
                String matchedText = sentence.getText().substring(match.getFromPos(), match.getToPos());
                String textFromMatch = sentence.getText().substring(match.getFromPos());
                boolean isException = false;
                for (String exception : exceptions) {
                    if (!textFromMatch.startsWith(exception)) continue;
                    isException = true;
                    break;
                }
                if (isException || (suggestion = matchedText.replace(ruleWithSuggestion.alternative, ruleWithSuggestion.suggestion)).equals(matchedText)) continue;
                match.setSuggestedReplacement(suggestion);
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }
}

