/* LanguageTool, a natural language style checker 
 * Copyright (C) 2005 Daniel Naber (http://www.danielnaber.de)
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

package org.languagetool.rules.de;

import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.*;
import org.languagetool.tools.ContextTools;

import java.util.*;

/**
 */
public class UncommonTagSequenceRule extends Rule {

  private static final List<List<String>> TAG_COMBINATIONS = Arrays.asList(
        //Arrays.asList("SUB", "SUB", "SUB"),  // TODO: remove
        
        Arrays.asList("ADJ", "PA1", "NEG"),
        Arrays.asList("ART", "NEG", "EIG"),
        Arrays.asList("ART", "PA1", "NEG"),
        Arrays.asList("NEG", "ART", "NEG"),
        Arrays.asList("NEG", "EIG", "ADJ"),
        Arrays.asList("NEG", "EIG", "NEG"),
        Arrays.asList("NEG", "EIG", "PA1"),
        Arrays.asList("NEG", "NEG", "ART"),
        Arrays.asList("NEG", "NEG", "EIG"),
        Arrays.asList("NEG", "NEG", "KON"),
        Arrays.asList("NEG", "NEG", "NEG"),
        Arrays.asList("NEG", "NEG", "PA1"),
        Arrays.asList("NEG", "NEG", "PRO"),
        Arrays.asList("NEG", "NEG", "SUB"),
        Arrays.asList("NEG", "PA1", "EIG"),
        Arrays.asList("NEG", "PA1", "NEG"),
        Arrays.asList("NEG", "PA1", "PA1"),
        Arrays.asList("NEG", "PA2", "EIG"),
        Arrays.asList("NEG", "PA2", "NEG"),
        Arrays.asList("NEG", "PA2", "PA1"),
        Arrays.asList("NEG", "PRO", "NEG"),
        Arrays.asList("NEG", "PRP", "NEG"),
        Arrays.asList("NEG", "SUB", "EIG"),
        Arrays.asList("NEG", "SUB", "NEG"),
        Arrays.asList("PA1", "ADJ", "EIG"),
        Arrays.asList("PA1", "ART", "EIG"),
        Arrays.asList("PA1", "ART", "NEG"),
        Arrays.asList("PA1", "EIG", "PA1"),
        Arrays.asList("PA1", "NEG", "EIG"),
        Arrays.asList("PA1", "NEG", "NEG"),
        Arrays.asList("PA1", "NEG", "PRO"),
        Arrays.asList("PA1", "PA1", "ADV"),
        Arrays.asList("PA1", "PA1", "ART"),
        Arrays.asList("PA1", "PA1", "NEG"),
        Arrays.asList("PA1", "PA1", "PA1"),
        Arrays.asList("PA1", "PA1", "PA2"),
        Arrays.asList("PA1", "PA1", "PRO"),
        Arrays.asList("PA1", "PA2", "NEG"),
        Arrays.asList("PA1", "PA2", "PA1"),
        Arrays.asList("PA1", "PRO", "EIG"),
        Arrays.asList("PA1", "PRP", "NEG"),
        Arrays.asList("PA2", "NEG", "PA1"),
        Arrays.asList("PA2", "PA2", "NEG"),
        Arrays.asList("PRP", "NEG", "EIG"),
        Arrays.asList("PRP", "NEG", "NEG"),
        Arrays.asList("PRP", "PA1", "NEG"),
        Arrays.asList("PRP", "PRP", "NEG")
  );

  public UncommonTagSequenceRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
    super(messages);
    //super.setCategory(new Category(new CategoryId("TEXT_ANALYSIS"), "Textanalyse", Location.INTERNAL, false));
  }

  @Override
  public String getId() {
    return "DE_UNCOMMON_TAG_SEQ";
  }

  @Override
  public String getDescription() {
    return "FIXME";
  }

  @Override
  public RuleMatch[] match(AnalyzedSentence sentence) {
    AnalyzedTokenReadings[] tokens = getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
    AnalyzedTokenReadings prevPrevToken = null;
    AnalyzedTokenReadings prevToken = null;
    List<RuleMatch> matches = new ArrayList<>();

    for (AnalyzedTokenReadings token : tokens) {
      // TODO: ngrams prüfen -> wenn vorhanden, dann eher kein Fehler?!
      for (List<String> tmpTags : TAG_COMBINATIONS) {
        if (token.hasPosTagStartingWith(tmpTags.get(2)) && prevToken != null && prevToken.hasPosTagStartingWith(tmpTags.get(1)) &&
            prevPrevToken != null && prevPrevToken.hasPosTagStartingWith(tmpTags.get(0))) {
          String msg = "Ungewöhnliche Wortfolge. Dies muss nicht unbedingt ein Fehler sein, aber bitte prüfen Sie diese Stelle.";
          ContextTools tools = new ContextTools();
          tools.setEscapeHtml(false);
          tools.setErrorMarkerStart("**");
          tools.setErrorMarkerEnd("**");
          tools.setContextSize(40);
          System.out.println("SEQ: " + tmpTags + " ==> " + tools.getContext(prevPrevToken.getStartPos(), token.getEndPos(), sentence.getText()));
          //RuleMatch match = new RuleMatch(this, sentence, prevPrevToken.getStartPos(), token.getEndPos(), msg);
          //matches.add(match);
        }
      }
      prevPrevToken = prevToken;
      prevToken = token;
    }
    return toRuleMatchArray(matches);
  }

}
