/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends org.languagetool.rules.LongSentenceRule {
    private static final boolean DEFAULT_ACTIVATION = false;

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages, userConfig, defaultWords);
        int confWords;
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Dies ist ein Bandwurmsatz, der immer weiter geht, obwohl das kein guter Stil ist, den man eigentlich ber\u00fccksichtigen sollte, obwohl es auch andere Meinungen gibt, die aber in der Minderzahl sind, weil die meisten Autoren sich doch an die Stilvorgaben halten, wenn auch nicht alle, was aber letztendlich wiederum eine Sache des Geschmacks ist</marker>."), Example.fixed((String)"<marker>Dies ist ein kurzer Satz.</marker>"));
        if (defaultActive) {
            this.setDefaultOn();
        }
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            this.maxWords = confWords;
        }
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords) {
        this(messages, userConfig, defaultWords, false);
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig) {
        this(messages, userConfig, -1, false);
    }

    public String getDescription() {
        return "Sehr langer Satz";
    }

    public String getMessage() {
        return "Der Satz hat an der markierten Stelle mehr als " + this.maxWords + " W\u00f6rter.";
    }

    public String getId() {
        return "TOO_LONG_SENTENCE_DE";
    }

    private boolean isWordCount(String tokenText) {
        char firstChar;
        return tokenText.length() > 0 && ((firstChar = tokenText.charAt(0)) >= 'A' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'z' || firstChar == '\u00e4' || firstChar == '\u00f6' || firstChar == '\u00fc' || firstChar == '\u00c4' || firstChar == '\u00d6' || firstChar == '\u00dc' || firstChar == '\u00df');
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        if (tokens.length < this.maxWords) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String msg = this.getMessage();
        ArrayList<Integer> fromPos = new ArrayList<Integer>();
        ArrayList<Integer> toPos = new ArrayList<Integer>();
        for (int i = 0; i < tokens.length; ++i) {
            int numWords = 0;
            while (!(i >= tokens.length || tokens[i].getToken().equals(":") || tokens[i].getToken().equals(";") || tokens[i].getToken().equals("\n") || tokens[i].getToken().equals("\r\n") || tokens[i].getToken().equals("\n\r"))) {
                if (this.isWordCount(tokens[i].getToken())) {
                    if (numWords == this.maxWords) {
                        fromPos.add(tokens[i].getStartPos());
                        toPos.add(tokens[i].getEndPos());
                    }
                    ++numWords;
                }
                ++i;
            }
        }
        for (int j = 0; j < fromPos.size(); ++j) {
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, ((Integer)fromPos.get(j)).intValue(), ((Integer)toPos.get(j)).intValue(), msg);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

