/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.Tools;

public class CompoundInfinitivRule
extends Rule {
    private static Dictionary dict;
    private final LinguServices linguServices;
    private Speller speller = null;
    private final Language lang;

    public CompoundInfinitivRule(ResourceBundle messages, Language lang, UserConfig userConfig) throws IOException {
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Er \u00fcberpr\u00fcfte die Rechnungen noch einmal, um ganz <marker>sicher zu gehen</marker>."), Example.fixed((String)"Er \u00fcberpr\u00fcfte die Rechnungen noch einmal, um ganz <marker>sicherzugehen</marker>."));
        this.lang = lang;
        this.linguServices = userConfig != null ? userConfig.getLinguServices() : null;
        this.setUrl(Tools.getUrl((String)"https://www.duden.de/sprachwissen/sprachratgeber/Infinitiv-mit-zu"));
    }

    @NotNull
    private static Dictionary getDictionary() throws IOException {
        if (dict == null) {
            dict = Dictionary.read((URL)JLanguageTool.getDataBroker().getFromResourceDirAsUrl("/de/hunspell/de_DE.dict"));
        }
        return dict;
    }

    public String getId() {
        return "COMPOUND_INFINITIV_RULE";
    }

    public String getDescription() {
        return "Erweiterter Infinitiv mit zu (Zusammenschreibung)";
    }

    private static boolean isInfinitiv(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("VER:INF");
    }

    private boolean isMisspelled(String word) {
        if (this.linguServices == null && this.speller != null) {
            return this.speller.isMisspelled(word);
        }
        if (this.linguServices != null) {
            return !this.linguServices.isCorrectSpell(word, this.lang);
        }
        return false;
    }

    private boolean isRelevant(AnalyzedTokenReadings token) {
        return token.hasPosTag("ZUS") && !"um".equalsIgnoreCase(token.getToken());
    }

    private String getLemma(AnalyzedTokenReadings token) {
        if (token != null) {
            List readings = token.getReadings();
            for (AnalyzedToken reading : readings) {
                String lemma = reading.getLemma();
                if (lemma == null) continue;
                return lemma;
            }
        }
        return null;
    }

    private boolean isException(AnalyzedTokenReadings[] tokens, int n) {
        int i;
        if (tokens[n - 2].hasPosTagStartingWith("VER")) {
            return true;
        }
        if ("sagen".equals(tokens[n + 1].getToken()) && ("weiter".equals(tokens[n - 1].getToken()) || "dazu".equals(tokens[n - 1].getToken()))) {
            return true;
        }
        if (("tragen".equals(tokens[n + 1].getToken()) || "machen".equals(tokens[n + 1].getToken())) && "davon".equals(tokens[n - 1].getToken())) {
            return true;
        }
        if ("geben".equals(tokens[n + 1].getToken()) && "daran".equals(tokens[n - 1].getToken())) {
            return true;
        }
        if ("gehen".equals(tokens[n + 1].getToken()) && "ab".equals(tokens[n - 1].getToken())) {
            return true;
        }
        if ("errichten".equals(tokens[n + 1].getToken()) && "wieder".equals(tokens[n - 1].getToken())) {
            return true;
        }
        String verb = null;
        for (i = n - 2; i > 0 && !this.isPunctuation(tokens[i].getToken()) && verb == null; --i) {
            if (tokens[i].hasPosTagStartingWith("VER:IMP")) {
                verb = StringUtils.lowerCase((String)this.getLemma(tokens[i]));
            } else if (tokens[i].hasPosTagStartingWith("VER")) {
                verb = tokens[i].getToken().toLowerCase();
            } else if ("Fang".equals(tokens[i].getToken())) {
                verb = "fangen";
            }
            if (verb == null) continue;
            if (this.isMisspelled(tokens[n - 1].getToken() + verb)) break;
            return true;
        }
        if ("aus".equals(tokens[n - 1].getToken()) || "an".equals(tokens[n - 1].getToken())) {
            for (i = n - 2; i > 0 && !this.isPunctuation(tokens[i].getToken()); --i) {
                if (!"von".equals(tokens[i].getToken()) && !"vom".equals(tokens[i].getToken())) continue;
                return true;
            }
        }
        if ("her".equals(tokens[n - 1].getToken())) {
            for (i = n - 2; i > 0 && !this.isPunctuation(tokens[i].getToken()); --i) {
                if (!"vor".equals(tokens[i].getToken())) continue;
                return true;
            }
        }
        return false;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        if (this.linguServices == null && this.speller == null) {
            this.speller = new Speller(CompoundInfinitivRule.getDictionary());
        }
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 2; i < tokens.length - 1; ++i) {
            if (!"zu".equals(tokens[i].getToken()) || !CompoundInfinitivRule.isInfinitiv(tokens[i + 1]) || !this.isRelevant(tokens[i - 1]) || this.isException(tokens, i) || this.isMisspelled(tokens[i - 1].getToken() + tokens[i + 1].getToken())) continue;
            String msg = "Wenn der erweiterte Infinitv von dem Verb '" + tokens[i - 1].getToken() + tokens[i + 1].getToken() + "' abgeleitet ist, muss er zusammengeschrieben werden";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokens[i - 1].getStartPos(), tokens[i + 1].getEndPos(), msg);
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add(tokens[i - 1].getToken() + tokens[i].getToken() + tokens[i + 1].getToken());
            ruleMatch.setSuggestedReplacements(suggestions);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isPunctuation(String word) {
        return word != null && word.length() == 1 && StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{".", "?", "!", "\u2026", ":", ";", ",", "(", ")", "[", "]"});
    }
}

