/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class GermanWordRepeatRule
extends WordRepeatRule {
    private final Language GERMAN;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().csToken("Bora").build(), new PatternTokenBuilder().csToken("Bora").build()), Arrays.asList(new PatternTokenBuilder().token("Moin").build(), new PatternTokenBuilder().token("Moin").build()), Arrays.asList(new PatternTokenBuilder().token("Na").build(), new PatternTokenBuilder().token("na").build()), Arrays.asList(new PatternTokenBuilder().csToken(",").build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken(",").build(), new PatternTokenBuilder().posRegex("PRP:.+").build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("Leben").build(), new PatternTokenBuilder().csToken("leben").build()));

    public GermanWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"In diesem Satz <marker>ist ist</marker> ein Wort doppelt."), Example.fixed((String)"In diesem Satz <marker>ist</marker> ein Wort doppelt."));
        this.GERMAN = language;
    }

    public String getId() {
        return "GERMAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (position != 2 && tokens[position - 1].getToken().equals("Sie") && tokens[position].getToken().equals("sie") || tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("Sie")) {
            return true;
        }
        if (position > 2 && tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("sie")) {
            if (tokens[position - 2].hasPosTag("KON:UNT")) {
                return true;
            }
            if (tokens.length - 1 > position && (tokens[position - 2].hasPosTagStartingWith("VER:3:") && tokens[position + 1].hasPosTag("ZUS") || tokens[position - 2].hasPosTagStartingWith("VER:MOD:3") && tokens[position + 1].hasPosTag("VER:INF:NON"))) {
                return true;
            }
        }
        return false;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.GERMAN);
    }
}

