/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.CaseRuleExceptions;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class CaseRule
extends Rule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|[0-9]+|(m{0,4}(c[md]|d?c{0,3})(x[cl]|l?x{0,3})(i[xv]|v?i{0,3}))$");
    private static final Set<String> nounIndicators = new HashSet<String>();
    private static final String UPPERCASE_MESSAGE = "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben.";
    private static final String LOWERCASE_MESSAGE = "Falls es sich um ein substantiviertes Verb handelt, wird es gro\u00dfgeschrieben.";
    private static final String COLON_MESSAGE = "Folgt dem Doppelpunkt weder ein Substantiv noch eine w\u00f6rtliche Rede oder ein vollst\u00e4ndiger Hauptsatz, schreibt man klein weiter.";
    public static final PatternToken SENT_START = new PatternTokenBuilder().posRegex("SENT_START").build();
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.regex((String)"erste[nr]?"), PatternRuleBuilderHelper.csToken((String)"Hilfe")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Alfred|Emanuel|G\u00fcnter|Immanuel|Johannes|Karl|Ludvig|Anton|Peter|Robert|Rolf"), PatternRuleBuilderHelper.csToken((String)"Nobel")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Gro\u00dfes"), new PatternTokenBuilder().tokenRegex("leisten|erreichen|schaffen").matchInflectedForms().build()), Arrays.asList(SENT_START, PatternRuleBuilderHelper.regex((String)"[:;]"), PatternRuleBuilderHelper.token((String)")"), PatternRuleBuilderHelper.regex((String)".*")), Arrays.asList(SENT_START, PatternRuleBuilderHelper.regex((String)"[;:]"), PatternRuleBuilderHelper.token((String)"-"), PatternRuleBuilderHelper.token((String)")"), PatternRuleBuilderHelper.regex((String)".*")), Arrays.asList(SENT_START, PatternRuleBuilderHelper.regex((String)"\u25b6\ufe0e|\u25b6|\\*|\u2022|-|\u2605"), PatternRuleBuilderHelper.regex((String)".*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Roten?"), PatternRuleBuilderHelper.regex((String)"Bete")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"[A-Z]-f\u00f6rmig(e[mnrs]?)?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Geboten")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"vor|den"), PatternRuleBuilderHelper.token((String)"Gefahren")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Digital|Global|Smart|International|Trade|Private|Live|Urban|Man|Total|Native|Imperial|Modern"), PatternRuleBuilderHelper.pos((String)"UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"UNKNOWN"), PatternRuleBuilderHelper.regex((String)"Digital|Global|Smart|International|Trade|Private|Live|Urban|Man|Total|Native|Imperial|Modern")), Arrays.asList(PatternRuleBuilderHelper.token((String)"National"), PatternRuleBuilderHelper.regex((String)"Sales")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Goldenen?"), PatternRuleBuilderHelper.regex((String)"Hochzeit(en)?")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Graue[nr]?"), PatternRuleBuilderHelper.regex((String)"Stars?|Eminenz")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Gro\u00dfe[nr]?"), PatternRuleBuilderHelper.regex((String)"Strafkammer|Latinums?|Rats?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Guten"), PatternRuleBuilderHelper.csToken((String)"Tag")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"H\u00f6heren?"), PatternRuleBuilderHelper.regex((String)"Schule|Mathematik")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"K\u00fcnstliche[nr]?"), PatternRuleBuilderHelper.token((String)"Intelligenz")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Neue[ns]?"), PatternRuleBuilderHelper.regex((String)"Jahr(s|es)?|Linken?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Neues"), PatternRuleBuilderHelper.token((String)"\\?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Zahl"), PatternRuleBuilderHelper.pos((String)"UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"*"), PatternRuleBuilderHelper.token((String)"innen")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"UNKNOWN|EIG:.+"), PatternRuleBuilderHelper.regex((String)"Schulte|Junge?|Lange?|Braun|Gro\u00df|Gross|K(\u00fc|ue)hne?|Schier|Becker|Sauer|Ernst|Fr(\u00f6|oe)hlich|Kurz|Klein|Schick|Frisch|Weigert|D(\u00fc|ue)rr|Nagele|Hoppe|D(\u00f6|oe)rre|G(\u00f6|oe)ttlich")), Arrays.asList(PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.posRegex((String)".*ADJ.*|UNKNOWN"), PatternRuleBuilderHelper.regex((String)"[\\.?!]")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)","), PatternRuleBuilderHelper.regex((String)"[md]eine?|du"), PatternRuleBuilderHelper.posRegex((String)".*ADJ.*|UNKNOWN"), PatternRuleBuilderHelper.regex((String)"[\\.?!]")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)".*ADJ.*|UNKNOWN"), PatternRuleBuilderHelper.regex((String)"Konstanten?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"PA2:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:AUX:.+")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:AUX:.+"), PatternRuleBuilderHelper.posRegex((String)"PKT|KON:NEB")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:.+"), new PatternTokenBuilder().pos("KON:NEB").setSkip(5).build(), PatternRuleBuilderHelper.posRegex((String)"VER:(AUX|MOD):.*"), PatternRuleBuilderHelper.posRegex((String)"PKT|KON:NEB")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.regex((String)"[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc]+"), PatternRuleBuilderHelper.regex((String)"und|oder")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"VER:INF:NON"), PatternRuleBuilderHelper.pos((String)"VER:MOD:2:PLU:PR\u00c4")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"UNKNOWN"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:INF.+"), PatternRuleBuilderHelper.posRegex((String)"VER:MOD:.+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:INF.+"), PatternRuleBuilderHelper.posRegex((String)"VER:AUX:.:(SIN|PLU)(:KJ2)?")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"etwas|nichts|viel|wenig|allerlei|was"), PatternRuleBuilderHelper.regex((String)"[A-Z\u00c4\u00d6\u00dc].*es"), PatternRuleBuilderHelper.regex((String)"und|oder|,"), PatternRuleBuilderHelper.regex((String)"[A-Z\u00c4\u00d6\u00dc].*es")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*[1-3]:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:.+:ADJ"), PatternRuleBuilderHelper.regex((String)"und|oder|,"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:.+:(NEU|FEM|MAS)|ART:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"(s\u00fcd|nord|ost|west).*lich"), PatternRuleBuilderHelper.token((String)"von")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Million(en)?"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:ADJ")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRP:.+|ADV:MOD"), PatternRuleBuilderHelper.pos((String)"VER:PA2:NON"), PatternRuleBuilderHelper.posRegex((String)"(ART|PRO):(IND|DE[FM]|POS):GEN:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"[A-Z\u00c4\u00d6\u00dc0-9]+[a-z\u00e4\u00f6\u00fc\u00df0-9]-[a-z\u00e4\u00f6\u00fc\u00df]+")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"auf|das|vor|a[mn]"), PatternRuleBuilderHelper.csToken((String)"Aus"), PatternRuleBuilderHelper.posRegex((String)"^PRP:.+|VER:[1-3]:.+")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"90"), PatternRuleBuilderHelper.csToken((String)"/"), PatternRuleBuilderHelper.csToken((String)"Die")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Neue[nrs]?"), new PatternTokenBuilder().tokenRegex("Mitte(lschule)?|Rathaus|Testament|Welt|Markt|Rundschau").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:(SFT|NON)"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.+|ADV:MOD")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:(SFT|NON)"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.+|ADV:MOD")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:(SFT|NON)"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+"), PatternRuleBuilderHelper.posRegex((String)"KON:.+"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.+|ADV:MOD")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[tT]ausende?"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.+"), PatternRuleBuilderHelper.posRegex((String)"SENT_END|VER:[1-3]:.+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:MOD.*"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:(SFT|NON)")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:MOD.*"), PatternRuleBuilderHelper.posRegex((String)"PRO:.+"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:(SFT|NON)")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Schlimm(er)?es"), PatternRuleBuilderHelper.pos((String)"SENT_END")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Angeh\u00f6rige[nr]?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Alt"), PatternRuleBuilderHelper.regex((String)"mach|w[iu]rde?"), PatternRuleBuilderHelper.csToken((String)"Neu")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:MAS:ADJ"), PatternRuleBuilderHelper.posRegex((String)"PRP:.+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"ZUS"), PatternRuleBuilderHelper.csToken((String)"Bekanntwerden")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)".+:(POS|GEN):.+"), PatternRuleBuilderHelper.csToken((String)"Zuhause")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"altes|anderes|k?ein|neues"), PatternRuleBuilderHelper.csToken((String)"Zuhause")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.csToken((String)"kommen"), new PatternTokenBuilder().csToken("sehen").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"auf"), PatternRuleBuilderHelper.csToken((String)"die"), PatternRuleBuilderHelper.csToken((String)"Schnelle")), Arrays.asList(new PatternTokenBuilder().csToken("fehlen").matchInflectedForms().setSkip(3).build(), PatternRuleBuilderHelper.csToken((String)"am"), PatternRuleBuilderHelper.csToken((String)"N\u00f6tigsten")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"am"), PatternRuleBuilderHelper.csToken((String)"N\u00f6tigsten"), new PatternTokenBuilder().csToken("fehlen").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"im"), PatternRuleBuilderHelper.csToken((String)"Aus")), Arrays.asList(PatternRuleBuilderHelper.token((String)"im"), PatternRuleBuilderHelper.csToken((String)"Ganzen")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Top"), PatternRuleBuilderHelper.pos((String)"ZAL")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Top"), PatternRuleBuilderHelper.csToken((String)"Ten")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Van"), PatternRuleBuilderHelper.csToken((String)"Den")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Lasse"), PatternRuleBuilderHelper.posRegex((String)"EIG:.*|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Just"), PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.csToken((String)"Time")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Hey|Hi|Hallo|Na"), PatternRuleBuilderHelper.regex((String)"S\u00fc\u00dfer?|H\u00fcbscher?"), PatternRuleBuilderHelper.pos((String)"PKT")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Hey|Hi|Hallo|Na"), PatternRuleBuilderHelper.regex((String)"du|meine?"), PatternRuleBuilderHelper.regex((String)"S\u00fc\u00dfer?|H\u00fcbscher?"), PatternRuleBuilderHelper.pos((String)"PKT")));
    private static final String[] sentenceStartExceptions;
    private static final String[] UNDEFINED_QUANTIFIERS;
    private static final String[] INTERROGATIVE_PARTICLES;
    private static final String[] POSSESSIVE_INDICATORS;
    private static final String[] DAS_VERB_EXCEPTIONS;
    private static final String[] exceptions;
    private static final Set<String> languages;
    private static final Set<Pattern[]> exceptionPatterns;
    private static final Set<String> substVerbenExceptions;
    private final GermanTagger tagger;
    private final German german;

    public CaseRule(ResourceBundle messages, German german) {
        this.german = german;
        super.setCategory(Categories.CASING.getCategory(messages));
        this.tagger = (GermanTagger)german.getTagger();
        this.addExamplePair(Example.wrong((String)"<marker>Das laufen</marker> f\u00e4llt mir schwer."), Example.fixed((String)"<marker>Das Laufen</marker> f\u00e4llt mir schwer."));
    }

    public String getId() {
        return "DE_CASE";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public URL getUrl() {
        return Tools.getUrl((String)"http://www.canoonet.eu/services/GermanSpelling/Regeln/Gross-klein/index.html");
    }

    public String getDescription() {
        return "Gro\u00dfschreibung von Nomen und substantivierten Verben";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        boolean prevTokenIsDas = false;
        boolean isPrecededByModalOrAuxiliary = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isBaseform;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken)) continue;
            if (i == 1) {
                prevTokenIsDas = nounIndicators.contains(tokens[1].getToken().toLowerCase());
                continue;
            }
            if (i > 0 && (this.isSalutation(tokens[i - 1].getToken()) || this.isCompany(tokens[i - 1].getToken())) || i > 2 && NUMERALS_EN.matcher(tokens[i - 1].getToken()).matches() && this.isDot(tokens[i - 2].getToken()) && NUMERALS_EN.matcher(tokens[i - 3].getToken()).matches()) continue;
            AnalyzedTokenReadings analyzedToken = tokens[i];
            String token = analyzedToken.getToken();
            boolean bl = isBaseform = analyzedToken.getReadingsLength() >= 1 && analyzedToken.hasLemma(token);
            if ((analyzedToken.getAnalyzedToken(0).getPOSTag() == null || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.VERB)) && isBaseform) {
                boolean nextTokenIsPersonalOrReflexivePronoun = false;
                if (i < tokens.length - 1) {
                    AnalyzedTokenReadings nextToken = tokens[i + 1];
                    boolean bl2 = nextTokenIsPersonalOrReflexivePronoun = nextToken.hasPartialPosTag("PRO:PER") || StringUtils.equalsAny((CharSequence)nextToken.getToken(), (CharSequence[])new CharSequence[]{"sich", "Sie"});
                    if (nextToken.hasPosTag("PKT") || prevTokenIsDas && (StringUtils.equalsAny((CharSequence)nextToken.getToken(), (CharSequence[])DAS_VERB_EXCEPTIONS) || this.isFollowedByRelativeOrSubordinateClause(i, tokens)) || i > 1 && this.hasPartialTag(tokens[i - 2], "VER:AUX", "VER:MOD")) continue;
                }
                if (this.isPrevProbablyRelativePronoun(tokens, i) || prevTokenIsDas && this.getTokensWithPosTagStartingWithCount(tokens, "VER") == 1) continue;
                this.potentiallyAddLowercaseMatch(ruleMatches, tokens[i], prevTokenIsDas, token, nextTokenIsPersonalOrReflexivePronoun, sentence);
            }
            prevTokenIsDas = nounIndicators.contains(tokens[i].getToken().toLowerCase());
            if (analyzedToken.matchesPosTagRegex("VER:(MOD|AUX):[1-3]:.*")) {
                isPrecededByModalOrAuxiliary = true;
            }
            AnalyzedTokenReadings lowercaseReadings = this.tagger.lookup(token.toLowerCase());
            if (!this.hasNounReading(analyzedToken) ? analyzedToken.hasPosTagStartingWith("SUB:") && i < tokens.length - 1 && Character.isLowerCase(tokens[i + 1].getToken().charAt(0)) && tokens[i + 1].matchesPosTagRegex("(VER:[123]:|PA2).+") : !this.isPotentialUpperCaseError(i, tokens, lowercaseReadings, isPrecededByModalOrAuxiliary)) continue;
            if (analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings != null && (lowercaseReadings.getAnalyzedToken(0).getPOSTag() == null || analyzedToken.getToken().endsWith("innen"))) continue;
            this.potentiallyAddUppercaseMatch(ruleMatches, tokens, i, analyzedToken, token, lowercaseReadings, sentence);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getTokensWithPosTagStartingWithCount(AnalyzedTokenReadings[] tokens, String partialPosTag) {
        return Arrays.stream(tokens).filter(token -> token.hasPosTagStartingWith(partialPosTag)).mapToInt(e -> 1).sum();
    }

    private boolean isPotentialUpperCaseError(int pos, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings, boolean isPrecededByModalOrAuxiliary) {
        boolean isPotentialError;
        if (pos <= 1) {
            return false;
        }
        if ("zu".equals(tokens[pos - 1].getToken()) && !tokens[pos].matchesPosTagRegex(".*(NEU|MAS|FEM)$") && lowercaseReadings != null && lowercaseReadings.hasPosTagStartingWith("VER:INF")) {
            return true;
        }
        boolean bl = isPotentialError = pos < tokens.length - 3 && tokens[pos + 1].getToken().equals(",") && StringUtils.equalsAny((CharSequence)tokens[pos + 2].getToken(), (CharSequence[])INTERROGATIVE_PARTICLES) && tokens[pos - 1].hasPosTagStartingWith("VER:MOD") && !tokens[pos - 1].hasLemma("m\u00f6gen") && !tokens[pos + 3].getToken().equals("zum");
        if (!isPotentialError && lowercaseReadings != null && tokens[pos].hasAnyPartialPosTag(new String[]{"SUB:NOM:SIN:NEU:INF", "SUB:DAT:PLU:"}) && ("zu".equals(tokens[pos - 1].getToken()) || this.hasPartialTag(tokens[pos - 1], "SUB", "EIG", "VER:AUX:3:", "ADV:TMP", "ABK"))) {
            isPotentialError |= lowercaseReadings.hasPosTag("PA2:PRD:GRU:VER") && !tokens[pos - 1].hasPosTagStartingWith("VER:AUX:3") && !lowercaseReadings.hasPosTag("VER:3:PLU:PRT:NON");
            isPotentialError |= !(pos < tokens.length - 2 && !",".equals(tokens[pos + 1].getToken()) || !"zu".equals(tokens[pos - 1].getToken()) && !isPrecededByModalOrAuxiliary || !tokens[pos].getToken().startsWith("\u00dcber") || !lowercaseReadings.hasAnyPartialPosTag(new String[]{"VER:INF:", "PA2:PRD:GRU:VER"}));
        }
        return isPotentialError;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.german);
    }

    private boolean isPrevProbablyRelativePronoun(AnalyzedTokenReadings[] tokens, int i) {
        return i >= 3 && tokens[i - 1].getToken().equals("das") && tokens[i - 2].getToken().equals(",") && tokens[i - 3].matchesPosTagRegex("SUB:...:SIN:NEU");
    }

    private boolean isSalutation(String token) {
        return StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Herr", "Herrn", "Frau"});
    }

    private boolean isCompany(String token) {
        return StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Firma", "Familie", "Unternehmen", "Firmen", "B\u00e4ckerei", "Metzgerei", "Fa"});
    }

    private boolean isDot(String token) {
        return token.equals(".");
    }

    private boolean hasNounReading(AnalyzedTokenReadings readings) {
        if (readings != null) {
            if (readings.hasPosTagStartingWith("ABK") && readings.hasPartialPosTag("SUB")) {
                return true;
            }
            AnalyzedTokenReadings allReadings = this.lookup(readings.getToken());
            if (allReadings != null) {
                for (AnalyzedToken reading : allReadings) {
                    String posTag = reading.getPOSTag();
                    if (posTag == null || !posTag.contains("SUB:") || posTag.contains(":ADJ")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void potentiallyAddLowercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings tokenReadings, boolean prevTokenIsDas, String token, boolean nextTokenIsPersonalOrReflexivePronoun, AnalyzedSentence sentence) {
        if (prevTokenIsDas && !nextTokenIsPersonalOrReflexivePronoun && Character.isLowerCase(token.charAt(0)) && !substVerbenExceptions.contains(token) && tokenReadings.hasPosTagStartingWith("VER:INF") && !tokenReadings.isIgnoredBySpeller() && !tokenReadings.isImmunized()) {
            this.addRuleMatch(ruleMatches, sentence, LOWERCASE_MESSAGE, tokenReadings, StringTools.uppercaseFirstChar((String)tokenReadings.getToken()));
        }
    }

    private void potentiallyAddUppercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings analyzedToken, String token, AnalyzedTokenReadings lowercaseReadings, AnalyzedSentence sentence) {
        boolean isUpperFirst = Character.isUpperCase(token.charAt(0));
        if (!(!isUpperFirst || token.length() <= 1 || tokens[i].isIgnoredBySpeller() || tokens[i].isImmunized() || StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])sentenceStartExceptions) || StringUtils.equalsAny((CharSequence)token, (CharSequence[])exceptions) || StringTools.isAllUppercase((String)token) || this.isLanguage(i, tokens, token) || this.isProbablyCity(i, tokens, token) || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PROPER_NOUN) || analyzedToken.isSentenceEnd() || this.isEllipsis(i, tokens) || this.isNumbering(i, tokens) || this.isNominalization(i, tokens, token, lowercaseReadings) || this.isAdverbAndNominalization(i, tokens) || this.isSpecialCase(i, tokens) || this.isAdjectiveAsNoun(i, tokens, lowercaseReadings) || this.isExceptionPhrase(i, tokens) || i == 2 && "\u201c".equals(tokens[i - 1].getToken()) || this.isNounWithVerbReading(i, tokens))) {
            String fixedWord = StringTools.lowercaseFirstChar((String)tokens[i].getToken());
            if (":".equals(tokens[i - 1].getToken())) {
                AnalyzedTokenReadings[] subarray = new AnalyzedTokenReadings[i];
                System.arraycopy(tokens, 0, subarray, 0, i);
                if (!this.isVerbFollowing(i, tokens, lowercaseReadings) && this.getTokensWithPosTagStartingWithCount(subarray, "VER") != 0) {
                    this.addRuleMatch(ruleMatches, sentence, COLON_MESSAGE, tokens[i], fixedWord);
                }
                return;
            }
            this.addRuleMatch(ruleMatches, sentence, UPPERCASE_MESSAGE, tokens[i], fixedWord);
        }
    }

    private boolean isNounWithVerbReading(int i, AnalyzedTokenReadings[] tokens) {
        return tokens[i].hasPosTagStartingWith("SUB") && tokens[i].hasPosTagStartingWith("VER:INF");
    }

    private boolean isVerbFollowing(int i, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings) {
        AnalyzedTokenReadings[] subarray = new AnalyzedTokenReadings[tokens.length - i];
        System.arraycopy(tokens, i, subarray, 0, subarray.length);
        if (lowercaseReadings != null) {
            subarray[0] = lowercaseReadings;
        }
        return this.getTokensWithPosTagStartingWithCount(subarray, "VER:") != 0;
    }

    private void addRuleMatch(List<RuleMatch> ruleMatches, AnalyzedSentence sentence, String msg, AnalyzedTokenReadings tokenReadings, String fixedWord) {
        RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getEndPos(), msg);
        ruleMatch.setSuggestedReplacement(fixedWord);
        ruleMatches.add(ruleMatch);
    }

    private boolean isNumbering(int i, AnalyzedTokenReadings[] tokens) {
        return i >= 2 && StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])new CharSequence[]{")", "]"}) && NUMERALS_EN.matcher(tokens[i - 2].getToken()).matches() && (i <= 3 || !tokens[i - 3].getToken().equals("(") || !tokens[i - 4].hasPosTagStartingWith("SUB:"));
    }

    private boolean isEllipsis(int i, AnalyzedTokenReadings[] tokens) {
        return StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])new CharSequence[]{"]", ")"}) && (i == 4 && tokens[i - 2].getToken().equals("\u2026") || i == 6 && tokens[i - 2].getToken().equals("."));
    }

    private boolean isNominalization(int i, AnalyzedTokenReadings[] tokens, String token, AnalyzedTokenReadings lowercaseReadings) {
        AnalyzedTokenReadings nextReadings;
        AnalyzedTokenReadings analyzedTokenReadings = nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        if (!(!StringTools.startsWithUppercase((String)token) || this.isNumber(token) || this.hasNounReading(nextReadings) || nextReadings != null && StringUtils.isNumeric((CharSequence)nextReadings.getToken()) || token.matches("Alle[nm]"))) {
            String prevTokenStr;
            if (lowercaseReadings != null && lowercaseReadings.hasPosTag("PRP:LOK+TMP+CAU:DAT+AKK")) {
                return false;
            }
            AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
            AnalyzedTokenReadings prevPrevToken = i >= 2 ? tokens[i - 2] : null;
            AnalyzedTokenReadings prevPrevPrevToken = i >= 3 ? tokens[i - 3] : null;
            String string = prevTokenStr = prevToken != null ? prevToken.getToken() : "";
            if (StringUtils.equalsAny((CharSequence)prevTokenStr, (CharSequence[])new CharSequence[]{"und", "oder", "beziehungsweise"}) && prevPrevToken != null && tokens[i].hasPartialPosTag("SUB") && tokens[i].hasPartialPosTag(":ADJ") || prevPrevToken.hasPartialPosTag("SUB") && !this.hasNounReading(nextReadings) && lowercaseReadings != null && lowercaseReadings.hasPartialPosTag("ADJ")) {
                return true;
            }
            if (lowercaseReadings != null && lowercaseReadings.hasPosTag("PA1:PRD:GRU:VER")) {
                return false;
            }
            return prevToken != null && ("irgendwas".equals(prevTokenStr) || "aufs".equals(prevTokenStr) || this.isNumber(prevTokenStr)) || this.hasPartialTag(prevToken, "ART", "PRO:") && ((i >= 4 || tokens.length <= 4) && prevToken.getReadings().size() != 1 && !prevPrevToken.hasLemma("sein") || !prevToken.hasPosTagStartingWith("PRO:PER:NOM:")) && !prevToken.hasPartialPosTag(":STD") || this.hasPartialTag(prevPrevPrevToken, "ART") && this.hasPartialTag(prevPrevToken, "PRP") && this.hasPartialTag(prevToken, "SUB") || this.hasPartialTag(prevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2", "PA1") || this.hasPartialTag(prevPrevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevPrevToken, "ADJ", "ADV") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2") || tokens[i].hasPosTagStartingWith("SUB:") && this.hasPartialTag(prevToken, "GEN") && !this.hasPartialTag(nextReadings, "PKT");
        }
        return false;
    }

    private boolean isNumber(String token) {
        if (StringUtils.isNumeric((CharSequence)token)) {
            return true;
        }
        AnalyzedTokenReadings lookup = this.lookup(StringTools.lowercaseFirstChar((String)token));
        return lookup != null && lookup.hasPosTag("ZAL");
    }

    private boolean isAdverbAndNominalization(int i, AnalyzedTokenReadings[] tokens) {
        String prevPrevToken = i > 1 ? tokens[i - 2].getToken() : "";
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "das".equalsIgnoreCase(prevPrevToken) && this.hasPartialTag(prevToken, "ADV") && StringTools.startsWithUppercase((String)token) && !this.hasNounReading(nextReadings);
    }

    private boolean hasPartialTag(AnalyzedTokenReadings token, String ... posTags) {
        if (token != null) {
            for (String posTag : posTags) {
                if (!token.hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialCase(int i, AnalyzedTokenReadings[] tokens) {
        String prevToken = i > 1 ? tokens[i - 1].getToken() : "";
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "im".equalsIgnoreCase(prevToken) && "Allgemeinen".equals(token) && !this.hasNounReading(nextReadings);
    }

    private boolean isAdjectiveAsNoun(int i, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings) {
        boolean isPrecededByVerb;
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        AnalyzedTokenReadings prevLowercaseReadings = null;
        if (i > 1 && StringUtils.equalsAny((CharSequence)tokens[i - 2].getToken(), (CharSequence[])sentenceStartExceptions)) {
            prevLowercaseReadings = this.lookup(prevToken.getToken().toLowerCase());
        }
        boolean isPossiblyFollowedByInfinitive = nextReadings != null && nextReadings.getToken().equals("zu");
        boolean isFollowedByInfinitive = nextReadings != null && !isPossiblyFollowedByInfinitive && nextReadings.hasPartialPosTag("EIZ");
        boolean isFollowedByPossessiveIndicator = nextReadings != null && StringUtils.equalsAny((CharSequence)nextReadings.getToken(), (CharSequence[])POSSESSIVE_INDICATORS);
        boolean isUndefQuantifier = prevToken != null && StringUtils.equalsAny((CharSequence)prevToken.getToken().toLowerCase(), (CharSequence[])UNDEFINED_QUANTIFIERS);
        boolean isPrevDeterminer = prevToken != null && (this.hasPartialTag(prevToken, "ART", "PRP", "ZAL") || this.hasPartialTag(prevLowercaseReadings, "ART", "PRP", "ZAL")) && !prevToken.hasPartialPosTag(":STD");
        boolean bl = isPrecededByVerb = prevToken != null && prevToken.matchesPosTagRegex("VER:(MOD:|AUX:)?[1-3]:.*") && !prevToken.hasLemma("sein");
        if (!(isPrevDeterminer || isUndefQuantifier || isPossiblyFollowedByInfinitive || isFollowedByInfinitive || isPrecededByVerb && lowercaseReadings != null && this.hasPartialTag(lowercaseReadings, "ADJ:", "PA") && nextReadings != null && !StringUtils.equalsAny((CharSequence)nextReadings.getToken(), (CharSequence[])new CharSequence[]{"und", "oder", ","}) || isFollowedByPossessiveIndicator && this.hasPartialTag(lowercaseReadings, "ADJ", "VER") || prevToken != null && prevToken.hasPosTag("KON:UNT") && !this.hasNounReading(nextReadings) && nextReadings != null && !nextReadings.hasPosTag("KON:NEB"))) {
            AnalyzedTokenReadings prevPrevToken;
            AnalyzedTokenReadings analyzedTokenReadings = prevPrevToken = i > 1 && prevToken != null && prevToken.hasPartialPosTag("ADJ") ? tokens[i - 2] : null;
            if (!isPrecededByVerb && lowercaseReadings != null && prevToken != null) {
                if (prevToken.hasPartialPosTag("SUB:") && lowercaseReadings.matchesPosTagRegex("(ADJ|PA2):GEN:PLU:MAS:GRU:SOL.*")) {
                    return nextReadings != null && !nextReadings.hasPartialPosTag("SUB:");
                }
                if (nextReadings != null && nextReadings.getReadingsLength() == 1 && prevToken.hasPosTagStartingWith("PRO:PER:NOM:") && nextReadings.hasPosTag("ADJ:PRD:GRU")) {
                    return true;
                }
            }
            if (!this.hasPartialTag(prevPrevToken, "ART", "PRP", "ZAL")) {
                return false;
            }
        }
        for (AnalyzedToken reading : tokens[i].getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag != null && !posTag.contains("ADJ") || this.hasNounReading(nextReadings) || StringUtils.isNumeric((CharSequence)(nextReadings != null ? nextReadings.getToken() : "")) || posTag == null && this.hasPartialTag(lowercaseReadings, "PRP:LOK", "PA2:PRD:GRU:VER", "PA1:PRD:GRU:VER", "ADJ:PRD:KOM", "ADV:TMP")) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguage(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean maybeLanguage = token.endsWith("sch") && languages.contains(token) || languages.contains(StringUtils.removeEnd((String)StringUtils.removeEnd((String)token, (String)"n"), (String)"e"));
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return maybeLanguage && (!this.hasNounReading(nextReadings) || prevToken != null && prevToken.getToken().equals("auf"));
    }

    private boolean isProbablyCity(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean hasCityPrefix = StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Klein", "Gro\u00df", "Neu"});
        if (hasCityPrefix) {
            AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
            return nextReadings != null && (!nextReadings.isTagged() || nextReadings.hasPosTagStartingWith("EIG"));
        }
        return false;
    }

    private boolean isFollowedByRelativeOrSubordinateClause(int i, AnalyzedTokenReadings[] tokens) {
        if (i < tokens.length - 4) {
            return ",".equals(tokens[i + 1].getToken()) && (StringUtils.equalsAny((CharSequence)tokens[i + 2].getToken(), (CharSequence[])INTERROGATIVE_PARTICLES) || tokens[i + 2].hasPosTag("KON:UNT"));
        }
        return false;
    }

    private boolean isExceptionPhrase(int i, AnalyzedTokenReadings[] tokens) {
        for (Pattern[] patterns : exceptionPatterns) {
            for (int j = 0; j < patterns.length; ++j) {
                int startIndex;
                if (!patterns[j].matcher(tokens[i].getToken()).matches() || !this.compareLists(tokens, startIndex = i - j, startIndex + patterns.length - 1, patterns)) continue;
                return true;
            }
        }
        return false;
    }

    boolean compareLists(AnalyzedTokenReadings[] tokens, int startIndex, int endIndex, Pattern[] patterns) {
        if (startIndex < 0) {
            return false;
        }
        int i = 0;
        for (int j = startIndex; j <= endIndex; ++j) {
            if (i >= patterns.length || j >= tokens.length || !patterns[i].matcher(tokens[j].getToken()).matches()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private AnalyzedTokenReadings lookup(String word) {
        AnalyzedTokenReadings lookupResult = null;
        try {
            lookupResult = this.tagger.lookup(word);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not lookup '" + word + "'.", e);
        }
        return lookupResult;
    }

    static {
        nounIndicators.add("das");
        nounIndicators.add("sein");
        nounIndicators.add("mein");
        nounIndicators.add("dein");
        nounIndicators.add("euer");
        nounIndicators.add("unser");
        sentenceStartExceptions = new String[]{"(", "\"", "'", "\u2018", "\u201e", "\u00ab", "\u00bb", ".", "!", "?"};
        UNDEFINED_QUANTIFIERS = new String[]{"viel", "nichts", "wenig", "allerlei"};
        INTERROGATIVE_PARTICLES = new String[]{"was", "wodurch", "wof\u00fcr", "womit", "woran", "worauf", "woraus", "wovon", "wie"};
        POSSESSIVE_INDICATORS = new String[]{"einer", "eines", "der", "des", "dieser", "dieses"};
        DAS_VERB_EXCEPTIONS = new String[]{"nur", "sogar", "auch", "die", "alle", "viele", "zu"};
        exceptions = new String[]{"Do", "Fr", "Sa", "Gr", "Mag", "Dozierende", "Dozierenden", "Studierende", "Suchbegriffen", "Plattdeutsch", "Wallet", "Str", "Auszubildende", "Auszubildender", "Gelehrte", "Gelehrter", "Gelehrten", "Vorstehende", "Vorstehender", "Mitwirkende", "Mitwirkender", "Mitwirkenden", "Selbstst\u00e4ndige", "Selbstst\u00e4ndiger", "Genaueres", "\u00c4u\u00dfersten", "Dienstreisender", "Verletzte", "Vermisste", "\u00c4u\u00dferes", "Abseits", "Besch\u00e4ftigter", "Besch\u00e4ftigte", "Besch\u00e4ftigten", "Bekannter", "Bekannte", "Bevollm\u00e4chtigte", "Bevollm\u00e4chtigter", "Bevollm\u00e4chtigten", "Brecht", "Tel", "Unschuldiger", "Vorgesetzter", "Abs", "Klappe", "Vorfahre", "Mittler", "Hr", "Schwarz", "Genese", "Rosa", "Auftrieb", "Zuschnitt", "Geschossen", "Vortrieb", "Abtrieb", "Gesandter", "Durchfahrt", "Durchgriff", "\u00dcberfahrt", "Zeche", "Sparte", "Sparten", "Heiliger", "Reisender", "Pest", "Schwinge", "Verlies", "Nachfolge", "Stift", "Belange", "Geistlicher", "Google", "Jenseits", "Abends", "Abgeordneter", "Abgeordnete", "Abgeordneten", "Angestellter", "Angestellte", "Angestellten", "Armeeangeh\u00f6rige", "Armeeangeh\u00f6rigen", "Armeeangeh\u00f6riger", "Liberaler", "Abriss", "Ahne", "\u00c4hnlichem", "\u00c4hnliches", "Allerlei", "Anklang", "Verlobter", "Anstrich", "Armes", "Ausdr\u00fccke", "Ausw\u00fcchsen", "B\u00e4nde", "B\u00e4nden", "Beauftragter", "Belange", "Biss", "De", "Diesseits", "Dr", "Durcheinander", "Eindr\u00fccke", "Erwachsener", "Familienangeh\u00f6rige", "Fl\u00f6\u00dfe", "Folgendes", "Fort", "Fra\u00df", "Frevel", "Gen\u00fcge", "Gefallen", "Gl\u00e4ubige", "Gl\u00e4ubiger", "Gl\u00e4ubigen", "Hechte", "Herz\u00f6ge", "Herz\u00f6gen", "Hinfahrt", "Hilfsstoff", "Hilfsstoffe", "Hundert", "Zehntausend", "Hunderttausend", "Hyperwallet", "Ihnen", "Ihr", "Ihre", "Ihrem", "Ihren", "Ihrer", "Ihres", "Infrarot", "Jenseits", "Jugendlicher", "J\u00fcnger", "Kant", "Klaue", "Konditional", "Kr\u00e4he", "Kurzem", "Landwirtschaft", "Langem", "L\u00e4ngerem", "Le", "Lehrlingsunter\u00adweisung", "Letzt", "Letzt", "Letztere", "Letzterer", "Letzteres", "Link", "Links", "L\u00f6hne", "Luden", "Mitfahrt", "Mr", "Mrd", "Mrs", "Nachfrage", "Nachts", "Nachspann", "N\u00e4hte", "N\u00e4hten", "Narkoseverfahren", "Neuem", "Nr", "Nutze", "Obdachloser", "Oder", "Ohrfeige", "Patsche", "Pfiffe", "Pfiffen", "Press", "Prof", "Puste", "Sachverst\u00e4ndiger", "Sankt", "Schaulustige", "Scheine", "Schei\u00dfe", "Schuft", "Schufte", "Schuld", "Schwangere", "Schwangeren", "Schw\u00e4rme", "Schwarzes", "Sie", "Skype", "Spitz", "Spott", "St", "Stereotyp", "St\u00f6re", "Tausend", "Tischende", "Toter", "\u00dcbrigen", "Unentschieden", "Unvorhergesehenes", "Verantwortlicher", "Verlass", "Verwandter", "Vielfache", "Vielfaches", "Vorsitzender", "Fraktionsvorsitzender", "Walt", "Weitem", "Weiteres", "Wicht", "Wichtiges", "Wider", "Wild", "Zeche", "Zusage", "Zwinge", "Zirkusrund", "Terti\u00e4r", "Erster", "Zweiter", "Dritter", "Vierter", "F\u00fcnfter", "Sechster", "Siebter", "Achter", "Neunter", "Erste", "Zweite", "Dritte", "Vierte", "F\u00fcnfte", "Sechste", "Siebte", "Achte", "Neunte", "Dein", "Deine", "Deinem", "Deinen", "Deiner", "Deines", "Dich", "Dir", "Du", "Euch", "Euer", "Eure", "Eurem", "Euren", "Eures"};
        languages = new HashSet<String>();
        languages.add("Angels\u00e4chsisch");
        languages.add("Afrikanisch");
        languages.add("Albanisch");
        languages.add("Altarabisch");
        languages.add("Altchinesisch");
        languages.add("Altgriechisch");
        languages.add("Althochdeutsch");
        languages.add("Altpersisch");
        languages.add("Amerikanisch");
        languages.add("Arabisch");
        languages.add("Armenisch");
        languages.add("Bairisch");
        languages.add("Baskisch");
        languages.add("Bengalisch");
        languages.add("Bulgarisch");
        languages.add("Chinesisch");
        languages.add("D\u00e4nisch");
        languages.add("Deutsch");
        languages.add("Englisch");
        languages.add("Estnisch");
        languages.add("Finnisch");
        languages.add("Franz\u00f6sisch");
        languages.add("Fr\u00fchneuhochdeutsch");
        languages.add("Germanisch");
        languages.add("Georgisch");
        languages.add("Griechisch");
        languages.add("Hebr\u00e4isch");
        languages.add("Hocharabisch");
        languages.add("Hochchinesisch");
        languages.add("Hochdeutsch");
        languages.add("Holl\u00e4ndisch");
        languages.add("Indonesisch");
        languages.add("Irisch");
        languages.add("Isl\u00e4ndisch");
        languages.add("Italienisch");
        languages.add("Japanisch");
        languages.add("Jiddisch");
        languages.add("Jugoslawisch");
        languages.add("Kantonesisch");
        languages.add("Katalanisch");
        languages.add("Klingonisch");
        languages.add("Koreanisch");
        languages.add("Kroatisch");
        languages.add("Kurdisch");
        languages.add("Lateinisch");
        languages.add("Lettisch");
        languages.add("Litauisch");
        languages.add("Luxemburgisch");
        languages.add("Mittelhochdeutsch");
        languages.add("Mongolisch");
        languages.add("Neuhochdeutsch");
        languages.add("Niederl\u00e4ndisch");
        languages.add("Norwegisch");
        languages.add("Persisch");
        languages.add("Plattdeutsch");
        languages.add("Polnisch");
        languages.add("Portugiesisch");
        languages.add("R\u00e4toromanisch");
        languages.add("Rum\u00e4nisch");
        languages.add("Russisch");
        languages.add("S\u00e4chsisch");
        languages.add("Schw\u00e4bisch");
        languages.add("Schwedisch");
        languages.add("Schweizerisch");
        languages.add("Serbisch");
        languages.add("Serbokroatisch");
        languages.add("Slawisch");
        languages.add("Slowakisch");
        languages.add("Slowenisch");
        languages.add("Spanisch");
        languages.add("Tamilisch");
        languages.add("Tibetisch");
        languages.add("Tschechisch");
        languages.add("Tschetschenisch");
        languages.add("T\u00fcrkisch");
        languages.add("Turkmenisch");
        languages.add("Uigurisch");
        languages.add("Ukrainisch");
        languages.add("Ungarisch");
        languages.add("Usbekisch");
        languages.add("Vietnamesisch");
        languages.add("Walisisch");
        languages.add("Wei\u00dfrussisch");
        exceptionPatterns = CaseRuleExceptions.getExceptionPatterns();
        substVerbenExceptions = new HashSet<String>();
        substVerbenExceptions.add("hinziehen");
        substVerbenExceptions.add("helfen");
        substVerbenExceptions.add("lassen");
        substVerbenExceptions.add("passieren");
        substVerbenExceptions.add("haben");
        substVerbenExceptions.add("passiert");
        substVerbenExceptions.add("beschr\u00e4nkt");
        substVerbenExceptions.add("wiederholt");
        substVerbenExceptions.add("scheinen");
        substVerbenExceptions.add("klar");
        substVerbenExceptions.add("hei\u00dfen");
        substVerbenExceptions.add("einen");
        substVerbenExceptions.add("geh\u00f6ren");
        substVerbenExceptions.add("bedeutet");
        substVerbenExceptions.add("erm\u00f6glicht");
        substVerbenExceptions.add("funktioniert");
        substVerbenExceptions.add("sollen");
        substVerbenExceptions.add("werden");
        substVerbenExceptions.add("d\u00fcrfen");
        substVerbenExceptions.add("m\u00fcssen");
        substVerbenExceptions.add("so");
        substVerbenExceptions.add("ist");
        substVerbenExceptions.add("k\u00f6nnen");
        substVerbenExceptions.add("mein");
        substVerbenExceptions.add("sein");
        substVerbenExceptions.add("muss");
        substVerbenExceptions.add("mu\u00df");
        substVerbenExceptions.add("wollen");
        substVerbenExceptions.add("habe");
        substVerbenExceptions.add("ein");
        substVerbenExceptions.add("tun");
        substVerbenExceptions.add("best\u00e4tigt");
        substVerbenExceptions.add("best\u00e4tigte");
        substVerbenExceptions.add("best\u00e4tigten");
        substVerbenExceptions.add("bekommen");
        substVerbenExceptions.add("sauer");
        substVerbenExceptions.add("bedeuten");
    }
}

