/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;

public class GermanCompoundRule
extends AbstractCompoundRule {
    private static final CompoundRuleData compoundData = new CompoundRuleData(new String[]{"/de/compounds.txt", "/de/compound-cities.txt"});

    public GermanCompoundRule(ResourceBundle messages) throws IOException {
        super(messages, "Dieses Wort wird mit Bindestrich geschrieben.", "Dieses Wort wird zusammengeschrieben.", "Diese W\u00f6rter werden zusammengeschrieben oder mit Bindestrich getrennt.", "Zusammenschreibung von W\u00f6rtern");
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO Arzt</marker> gehen."), Example.fixed((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO-Arzt</marker> gehen."));
    }

    public String getId() {
        return "DE_COMPOUNDS";
    }

    public String getDescription() {
        return "Zusammenschreibung von W\u00f6rtern, z. B. 'CD-ROM' statt 'CD ROM'";
    }

    protected CompoundRuleData getCompoundRuleData() {
        return compoundData;
    }
}

