/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;

final class CaseRuleExceptions {
    private static final Set<String> exceptions = CaseRuleExceptions.loadExceptions("/de/case_rule_exceptions.txt");

    private CaseRuleExceptions() {
    }

    public static Set<String> getExceptions() {
        return exceptions;
    }

    public static Set<Pattern[]> getExceptionPatterns() {
        HashSet<Pattern[]> exceptionPatterns = new HashSet<Pattern[]>(250);
        for (String phrase : exceptions) {
            String[] parts = phrase.split(" ");
            Pattern[] patterns = new Pattern[parts.length];
            for (int j = 0; j < parts.length; ++j) {
                patterns[j] = Pattern.compile(parts[j]);
            }
            exceptionPatterns.add(patterns);
        }
        return Collections.unmodifiableSet(exceptionPatterns);
    }

    private static Set<String> loadExceptions(String ... paths) {
        HashSet<String> result = new HashSet<String>();
        for (String path : paths) {
            List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
            for (String line : lines) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (line.matches("^\\s.*") || line.matches(".*\\s$")) {
                    throw new IllegalArgumentException("Invalid line in " + path + ", starts or ends with whitespace: '" + line + "'");
                }
                result.add(line);
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

