/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private final ExtendedGermanWordSplitter wordSplitter = new ExtendedGermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.addException("Maskerade", Collections.singletonList("Maskerade"));
        this.wordSplitter.addException("Sportshorts", Arrays.asList("Sport", "shorts"));
        this.wordSplitter.addException("Bermudashorts", Arrays.asList("Bermuda", "shorts"));
        this.wordSplitter.addException("Laufshorts", Arrays.asList("Lauf", "shorts"));
        this.wordSplitter.addException("Badeshorts", Arrays.asList("Bade", "shorts"));
        this.wordSplitter.addException("Buchungstrick", Arrays.asList("Buchungs", "trick"));
        this.wordSplitter.addException("Buchungstricks", Arrays.asList("Buchungs", "tricks"));
        this.wordSplitter.addException("R\u00fcckzugsorte", Arrays.asList("R\u00fcckzugs", "orte"));
        this.wordSplitter.addException("Malerarbeiten", Arrays.asList("Maler", "arbeiten"));
        this.wordSplitter.addException("Siebengestirn", Arrays.asList("Sieben", "gestirn"));
        this.wordSplitter.addException("Siebengestirne", Arrays.asList("Sieben", "gestirne"));
        this.wordSplitter.addException("Siebengestirnen", Arrays.asList("Sieben", "gestirnen"));
        this.wordSplitter.addException("Siebengestirns", Arrays.asList("Sieben", "gestirns"));
        this.wordSplitter.addException("Siebengestirnes", Arrays.asList("Sieben", "gestirnes"));
        this.wordSplitter.addException("Alpinforum", Arrays.asList("Alpin", "forum"));
        this.wordSplitter.addException("Rollerskate", Arrays.asList("Rollerskate"));
        this.wordSplitter.addException("Baumeisterarbeiten", Arrays.asList("Baumeister", "arbeiten"));
        this.wordSplitter.addException("Bilderarbeiten", Arrays.asList("Bilder", "arbeiten"));
        this.wordSplitter.addException("Dachdeckerarbeiten", Arrays.asList("Dachdecker", "arbeiten"));
        this.wordSplitter.addException("Handlangerarbeiten", Arrays.asList("Handlanger", "arbeiten"));
        this.wordSplitter.addException("Handwerkerarbeiten", Arrays.asList("Handwerker", "arbeiten"));
        this.wordSplitter.addException("Kinderarbeiten", Arrays.asList("Kinder", "arbeiten"));
        this.wordSplitter.addException("Masterarbeiten", Arrays.asList("Master", "arbeiten"));
        this.wordSplitter.addException("Meisterarbeiten", Arrays.asList("Meister", "arbeiten"));
        this.wordSplitter.addException("Putzerarbeiten", Arrays.asList("Putzer", "arbeiten"));
        this.wordSplitter.addException("Schlosserarbeiten", Arrays.asList("Schlosser", "arbeiten"));
        this.wordSplitter.addException("Schneiderarbeiten", Arrays.asList("Schneider", "arbeiten"));
        this.wordSplitter.addException("Wanderarbeiten", Arrays.asList("Wander", "arbeiten"));
        this.wordSplitter.addException("Taucherarbeiten", Arrays.asList("Taucher", "arbeiten"));
        this.wordSplitter.addException("Hauptakteurin", Arrays.asList("Haupt", "akteurin"));
        this.wordSplitter.addException("Kleiderecke", Arrays.asList("Kleider", "ecke"));
        this.wordSplitter.addException("Kleiderecken", Arrays.asList("Kleider", "ecken"));
        this.wordSplitter.addException("Abwehrecke", Arrays.asList("Abwehr", "ecke"));
        this.wordSplitter.addException("Abwehrecken", Arrays.asList("Abwehr", "ecken"));
        this.wordSplitter.addException("Dichterecke", Arrays.asList("Dichter", "ecke"));
        this.wordSplitter.addException("Dichterecken", Arrays.asList("Dichter", "ecken"));
        this.wordSplitter.addException("Kellerecke", Arrays.asList("Keller", "ecke"));
        this.wordSplitter.addException("Kellerecken", Arrays.asList("Keller", "ecken"));
        this.wordSplitter.addException("Kinderecke", Arrays.asList("Kinder", "ecke"));
        this.wordSplitter.addException("Kinderecken", Arrays.asList("Kinder", "ecken"));
        this.wordSplitter.addException("Silberecke", Arrays.asList("Silber", "ecke"));
        this.wordSplitter.addException("Silberecken", Arrays.asList("Silber", "ecken"));
        this.wordSplitter.addException("Schreibart", Arrays.asList("Schreib", "art"));
        this.wordSplitter.addException("Pr\u00fcfungsorte", Arrays.asList("Pr\u00fcfungs", "orte"));
        this.wordSplitter.addException("Pr\u00fcfungsorten", Arrays.asList("Pr\u00fcfungs", "orten"));
        this.wordSplitter.addException("\u00d6lsorte", Arrays.asList("\u00d6l", "sorte"));
        this.wordSplitter.addException("\u00d6lsorten", Arrays.asList("\u00d6l", "sorten"));
        this.wordSplitter.addException("Pflanzen\u00f6lsorte", Arrays.asList("Pflanzen\u00f6l", "sorte"));
        this.wordSplitter.addException("Pflanzen\u00f6lsorten", Arrays.asList("Pflanzen\u00f6l", "sorten"));
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
    }

    public List<String> tokenize(String word) {
        try {
            return this.wordSplitter.splitWord(word);
        }
        catch (InputTooLongException e) {
            return Collections.singletonList(word);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordToSplit>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        System.out.println(tokenizer.tokenize(args[0]));
    }

    static class ExtendedGermanWordSplitter
    extends GermanWordSplitter {
        ExtendedGermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
            super(hideInterfixCharacters, ExtendedGermanWordSplitter.extendedList());
        }

        static Set<String> extendedList() {
            HashSet<String> words = new HashSet<String>(EmbeddedGermanDictionary.getWords());
            words.add("online");
            words.add("affin");
            words.add("affine");
            words.add("affiner");
            words.add("affines");
            words.add("affinen");
            words.add("affinem");
            words.add("trockner");
            words.add("thermostat");
            words.add("thermostats");
            words.add("fehl");
            words.add("circus");
            words.add("schi");
            words.add("codex");
            words.add("cr\u00e8me");
            words.add("cr\u00e8mes");
            words.add("sauce");
            words.add("account");
            words.add("accounts");
            words.add("photograph");
            words.add("oxyd");
            words.add("playback");
            words.add("playbacks");
            words.add("blog");
            words.add("durchsuchung");
            words.add("durchsuchungen");
            words.add("kritisch");
            words.add("kritische");
            words.add("kritisches");
            words.add("kritischer");
            words.add("kritischen");
            words.add("kritischem");
            words.add("fortbewegung");
            words.add("freundlich");
            words.add("freundliche");
            words.add("freundliches");
            words.add("freundlicher");
            words.add("freundlichen");
            words.add("freundlichem");
            words.add("gelegenen");
            words.add("gelegenes");
            words.add("gelegene");
            words.add("gelegen");
            words.add("neurogen");
            words.add("neurogene");
            words.add("neurogenes");
            words.add("neurogenen");
            words.add("autogene");
            words.add("autogenes");
            words.add("autogenen");
            words.add("biogenetisch");
            words.add("biogenetische");
            words.add("biogenetischen");
            words.add("biogenetisches");
            words.add("fotogene");
            words.add("fotogenes");
            words.add("fotogenen");
            words.add("erlegene");
            words.add("erlegenes");
            words.add("erlegenen");
            words.add("genesenden");
            words.add("genesender");
            words.add("geneset");
            words.add("telegene");
            words.add("telegenen");
            words.add("telegenes");
            words.add("genetisch");
            words.add("genetische");
            words.add("genetischen");
            words.add("genetisches");
            words.add("premium");
            words.add("kontrolleurin");
            words.add("konstrukteurin");
            words.add("importeurin");
            words.add("requisiteurin");
            words.add("akteurin");
            words.add("masseurin");
            words.add("profiteurin");
            words.add("charmeurin");
            words.add("medailleurin");
            words.add("exporteurin");
            words.add("rechercheurin");
            words.add("poseurin");
            words.add("auskommentieren");
            words.add("impfung");
            words.add("impfungen");
            return words;
        }
    }
}

