/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class DuUpperLowerCaseRule
extends TextLevelRule {
    private static final Set<String> lowerWords = new HashSet<String>(Arrays.asList("du", "dir", "dich", "dein", "deine", "deines", "deins", "deiner", "deinen", "deinem", "euch", "euer", "eure", "euere", "euren", "eueren", "euern", "eurer", "euerer", "eurem", "euerem", "eures", "eueres"));
    private static final String IHR = "ihr";

    public DuUpperLowerCaseRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Wie geht es Dir? Bist <marker>du</marker> wieder gesund?"), Example.fixed((String)"Wie geht es Dir? Bist <marker>Du</marker> wieder gesund?"));
        this.setUrl(Tools.getUrl((String)"https://www.duden.de/sprachwissen/sprachratgeber/Gross-oder-Kleinschreibung-von-duDu-und-ihrIhr"));
    }

    public String getId() {
        return "DE_DU_UPPER_LOWER";
    }

    public String getDescription() {
        return "Einheitliche Verwendung von Du/du, Dir/dir etc.";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        String firstUse = null;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int i = 0; i < tokens.length; ++i) {
                AnalyzedTokenReadings token;
                String word;
                String lcWord;
                if (i > 0 && (tokens[i - 1].isSentenceStart() || StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])new CharSequence[]{"\"", "\u201e", ":", "\u00bb", "\u201c"})) || !lowerWords.contains(lcWord = (word = (token = tokens[i]).getToken()).toLowerCase()) && !lcWord.equals(IHR)) continue;
                if (firstUse == null) {
                    if (word.equals(IHR)) continue;
                    firstUse = word;
                    continue;
                }
                boolean firstUseIsUpper = StringTools.startsWithUppercase(firstUse);
                String msg = null;
                String replacement = null;
                if (firstUseIsUpper && !StringTools.startsWithUppercase((String)word)) {
                    String prevWord;
                    replacement = StringTools.uppercaseFirstChar((String)word);
                    String string = prevWord = i > 0 ? tokens[i - 1].getToken() : "";
                    if (word.equals(IHR)) {
                        if (!prevWord.matches("aus|bei|beim|binnen|entgegen|fern|entsprechend|gem\u00e4\u00df|gegen\u00fcber|mit|mitsamt|nach|nahe|nebst|samt|via|zuliebe|von|zu|zur|zuwider")) {
                            msg = "Vorher wurde bereits '" + firstUse + "' gro\u00dfgeschrieben. Nur falls es sich hier auch um eine Anrede handelt: Aus Gr\u00fcnden der Einheitlichkeit '" + replacement + "' hier auch gro\u00dfschreiben?";
                        }
                    } else {
                        msg = "Vorher wurde bereits '" + firstUse + "' gro\u00dfgeschrieben. Aus Gr\u00fcnden der Einheitlichkeit '" + replacement + "' hier auch gro\u00dfschreiben?";
                    }
                } else if (!firstUseIsUpper && StringTools.startsWithUppercase((String)word) && !StringUtils.isAllUpperCase((CharSequence)word)) {
                    replacement = StringTools.lowercaseFirstChar((String)word);
                    msg = "Vorher wurde bereits '" + firstUse + "' kleingeschrieben. Aus Gr\u00fcnden der Einheitlichkeit '" + replacement + "' hier auch kleinschreiben?";
                }
                if (msg == null) continue;
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, pos + token.getStartPos(), pos + token.getEndPos(), msg);
                ruleMatch.setSuggestedReplacement(replacement);
                ruleMatches.add(ruleMatch);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public int minToCheckParagraph() {
        return -1;
    }
}

