/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;

public class UppercaseNounReadingFilter
extends RuleFilter {
    private static final Tagger tagger = Languages.getLanguageForShortCode((String)"de").getTagger();

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        String token = arguments.get("token");
        if (token == null) {
            throw new RuntimeException("Set 'token' for filter " + UppercaseNounReadingFilter.class.getName() + " in rule " + match.getRule().getId());
        }
        try {
            String uppercase = StringTools.uppercaseFirstChar((String)token);
            List tags = tagger.tag(Collections.singletonList(uppercase));
            boolean hasNounReading = false;
            for (AnalyzedTokenReadings tag : tags) {
                if (!tag.hasPartialPosTag("SUB:") || tag.hasPartialPosTag("ADJ")) continue;
                hasNounReading = true;
                break;
            }
            if (hasNounReading) {
                return match;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

