/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import com.google.common.base.Suppliers;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.de.VerbPrefixes;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanTagger
extends BaseTagger {
    private static final List<String> allAdjGruTags = new ArrayList<String>();
    private static final List<String> nounTagExpansionExceptions;
    private static final List<String> tagsForWeise;
    private final ManualTagger removalTagger = (ManualTagger)((CombiningTagger)this.getWordTagger()).getRemovalTagger();
    private static final Supplier<ExpansionInfos> expansionInfos;
    public static final GermanTagger INSTANCE;

    public GermanTagger() {
        super("/de/german.dict", Locale.GERMAN);
    }

    private static ExpansionInfos initExpansionInfos() {
        THashMap verbInfos = new THashMap();
        THashMap nominalizedVerbInfos = new THashMap();
        THashMap nominalizedGenVerbInfos = new THashMap();
        List spellingWords = new CachingWordListLoader().loadWords("de/hunspell/spelling.txt");
        for (String line : spellingWords) {
            if (!line.contains("_") || line.endsWith("_in")) continue;
            String[] parts = line.replace("#.*", "").trim().split("_");
            String prefix = parts[0];
            String verbBaseform = parts[1];
            try {
                String[] forms;
                for (String form : forms = GermanSynthesizer.INSTANCE.synthesizeForPosTags(verbBaseform, s -> s.startsWith("VER:"))) {
                    if (form.contains("\u00df")) continue;
                    verbInfos.put(prefix + form, new PrefixInfixVerb(prefix, "", verbBaseform));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            verbInfos.put(prefix + "zu" + verbBaseform, new PrefixInfixVerb(prefix, "zu", verbBaseform));
            nominalizedVerbInfos.put(StringTools.uppercaseFirstChar((String)prefix) + verbBaseform, new NominalizedVerb(StringTools.uppercaseFirstChar((String)prefix), verbBaseform));
            nominalizedGenVerbInfos.put(StringTools.uppercaseFirstChar((String)prefix) + verbBaseform + "s", new NominalizedGenitiveVerb(StringTools.uppercaseFirstChar((String)prefix), verbBaseform));
        }
        return new ExpansionInfos((Map<String, PrefixInfixVerb>)verbInfos, (Map<String, NominalizedVerb>)nominalizedVerbInfos, (Map<String, NominalizedGenitiveVerb>)nominalizedGenVerbInfos);
    }

    private List<TaggedWord> addStem(List<TaggedWord> analyzedWordResults, String stem) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>();
        for (TaggedWord tw : analyzedWordResults) {
            String lemma = tw.getLemma();
            if (stem.length() > 0 && stem.charAt(stem.length() - 1) != '-' && tw.getPosTag().startsWith("SUB")) {
                lemma = lemma.toLowerCase();
            }
            result.add(new TaggedWord(stem + lemma, tw.getPosTag()));
        }
        return result;
    }

    private String sanitizeWord(String word) {
        String result = word;
        if (!word.endsWith("-")) {
            String[] splitWord = word.split("-");
            String lastPart = splitWord.length > 1 && !splitWord[splitWord.length - 1].trim().equals("") ? splitWord[splitWord.length - 1] : word;
            List<String> compoundedWord = GermanCompoundTokenizer.getStrictInstance().tokenize(lastPart);
            lastPart = compoundedWord.size() > 1 && StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1);
            List<TaggedWord> tagged = this.tag(lastPart);
            if (tagged.size() > 0 && (StringUtils.startsWithAny((CharSequence)tagged.get(0).getPosTag(), (CharSequence[])new CharSequence[]{"SUB", "ADJ"}) || this.matchesUppercaseAdjective(lastPart))) {
                result = lastPart;
            }
        }
        return result;
    }

    @Nullable
    public AnalyzedTokenReadings lookup(String word) throws IOException {
        List<AnalyzedTokenReadings> result = this.tag(Collections.singletonList(word), false);
        AnalyzedTokenReadings atr = result.get(0);
        if (atr.getAnalyzedToken(0).getPOSTag() == null) {
            return null;
        }
        return atr;
    }

    public List<TaggedWord> tag(String word) {
        return this.getWordTagger().tag(word);
    }

    private boolean matchesUppercaseAdjective(String unknownUppercaseToken) {
        List temp = this.getWordTagger().tag(StringTools.lowercaseFirstChar((String)unknownUppercaseToken));
        return temp.size() > 0 && ((TaggedWord)temp.get(0)).getPosTag().startsWith("ADJ");
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        return this.tag(sentenceTokens, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens, boolean ignoreCase) throws IOException {
        boolean firstWord = true;
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        int idxPos = 0;
        String prevWord = null;
        for (String word : sentenceTokens) {
            int idx;
            ArrayList<AnalyzedToken> readings = new ArrayList<AnalyzedToken>();
            ArrayList taggerTokens = null;
            String genderGap = "[*:_/]";
            if (idxPos + 2 < sentenceTokens.size() && sentenceTokens.get(idxPos + 1).matches(genderGap) && sentenceTokens.get(idxPos + 2).matches("in(nen)?|r|e")) {
                taggerTokens = new ArrayList();
                taggerTokens.addAll(this.getWordTagger().tag(word));
                taggerTokens.addAll(this.getWordTagger().tag(word + sentenceTokens.get(idxPos + 2)));
            }
            if (taggerTokens == null) {
                taggerTokens = this.getWordTagger().tag(word);
            }
            if ((firstWord || ":".equals(prevWord)) && taggerTokens.isEmpty() && ignoreCase) {
                taggerTokens = this.getWordTagger().tag(word.toLowerCase());
                firstWord = !StringUtils.isAlphanumeric((CharSequence)word);
            } else if (pos == 0 && ignoreCase) {
                taggerTokens.addAll(this.getWordTagger().tag(word.toLowerCase()));
            } else if (pos > 1 && taggerTokens.isEmpty() && ignoreCase && (idx = sentenceTokens.indexOf(word)) > 2 && sentenceTokens.get(idx - 1).contentEquals("\u201e") && sentenceTokens.get(idx - 3).contentEquals(":")) {
                taggerTokens.addAll(this.getWordTagger().tag(word.toLowerCase()));
            }
            if (taggerTokens.size() > 0) {
                readings.addAll(this.getAnalyzedTokens(taggerTokens, word));
            } else {
                boolean addNounTags;
                PrefixInfixVerb verbInfo = GermanTagger.expansionInfos.get().verbInfos.get(word);
                NominalizedVerb nomVerbInfo = GermanTagger.expansionInfos.get().nominalizedVerbInfos.get(word);
                NominalizedGenitiveVerb nomGenVerbInfo = GermanTagger.expansionInfos.get().nominalizedGenVerbInfos.get(word);
                boolean bl = addNounTags = !nounTagExpansionExceptions.contains(word);
                if (verbInfo != null) {
                    if (StringTools.startsWithLowercase((String)verbInfo.prefix)) {
                        String noPrefixForm = word.substring(verbInfo.prefix.length() + verbInfo.infix.length());
                        List<TaggedWord> tags = this.tag(noPrefixForm);
                        boolean isSFT = false;
                        for (TaggedWord tag : tags) {
                            if (tag.getPosTag() == null || !tag.getPosTag().startsWith("VER:") && !tag.getPosTag().startsWith("PA2:")) continue;
                            readings.add(new AnalyzedToken(word, tag.getPosTag(), verbInfo.prefix + tag.getLemma()));
                            if (!tag.getPosTag().contains(":SFT")) continue;
                            isSFT = true;
                        }
                        if ("zu".equals(verbInfo.infix)) {
                            readings.clear();
                            readings.add(new AnalyzedToken(word, "VER:EIZ:" + (isSFT ? "SFT" : "NON"), verbInfo.prefix + verbInfo.verbBaseform));
                        }
                    }
                } else if (nomVerbInfo != null && addNounTags) {
                    readings.add(new AnalyzedToken(word, "SUB:NOM:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                    readings.add(new AnalyzedToken(word, "SUB:AKK:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                    readings.add(new AnalyzedToken(word, "SUB:DAT:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                } else if (nomGenVerbInfo != null && addNounTags) {
                    readings.add(new AnalyzedToken(word, "SUB:GEN:SIN:NEU:INF", nomGenVerbInfo.prefix + nomGenVerbInfo.verbBaseform));
                } else if (this.isWeiseException(word)) {
                    for (String tag : tagsForWeise) {
                        readings.add(new AnalyzedToken(word, tag, word));
                    }
                } else if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{word})) {
                    List<String> compoundParts = GermanCompoundTokenizer.getStrictInstance().tokenize(word);
                    if (compoundParts.size() <= 1) {
                        List<AnalyzedToken> imperativeFormList = this.getImperativeForm(word, sentenceTokens, pos);
                        List<AnalyzedToken> substantivatedFormsList = this.getSubstantivatedForms(word, sentenceTokens);
                        if (imperativeFormList.size() > 0) {
                            readings.addAll(imperativeFormList);
                        } else if (substantivatedFormsList.size() > 0) {
                            readings.addAll(substantivatedFormsList);
                        } else {
                            String lastPart;
                            if (StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"bitter", "dunkel", "erz", "extra", "fr\u00fch", "gemein", "hyper", "lau", "mega", "minder", "stock", "super", "tod", "ultra", "un", "ur"}) && (lastPart = RegExUtils.removePattern((String)word, (String)"^(bitter|dunkel|erz|extra|fr\u00fch|gemein|grund|hyper|lau|mega|minder|stock|super|tod|ultra|u[nr]|voll)")).length() > 3) {
                                String firstPart = StringUtils.removeEnd((String)word, (String)lastPart);
                                List taggedWords = this.getWordTagger().tag(lastPart);
                                for (TaggedWord taggedWord : taggedWords) {
                                    if (firstPart.length() == 2 && taggedWord.getPosTag().startsWith("VER")) continue;
                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart + taggedWord.getLemma()));
                                }
                            }
                            if (StringUtils.split((String)word, (char)' ').length == 1 && !Character.isDigit(word.charAt(0))) {
                                String wordOrig = word;
                                word = this.sanitizeWord(word);
                                String wordStem = wordOrig.substring(0, wordOrig.length() - word.length());
                                List<String> compoundedWord = GermanCompoundTokenizer.getStrictInstance().tokenize(word);
                                word = compoundedWord.size() > 1 ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1);
                                List linkedTaggerTokens = this.addStem(this.getWordTagger().tag(word), wordStem);
                                if (wordOrig.contains("-") && linkedTaggerTokens.isEmpty() && this.matchesUppercaseAdjective(word)) {
                                    word = StringTools.lowercaseFirstChar((String)word);
                                    linkedTaggerTokens = this.getWordTagger().tag(word);
                                }
                                word = wordOrig;
                                boolean wordStartsUppercase = StringTools.startsWithUppercase((String)word);
                                if (linkedTaggerTokens.isEmpty()) {
                                    readings.add(this.getNoInfoToken(word));
                                } else if (wordStartsUppercase) {
                                    readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word));
                                } else {
                                    readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word, compoundedWord));
                                }
                            } else {
                                readings.add(this.getNoInfoToken(word));
                            }
                        }
                    } else if (idxPos + 2 >= sentenceTokens.size() || !sentenceTokens.get(idxPos + 1).equals(".") || !sentenceTokens.get(idxPos + 2).matches("com|net|org|de|at|ch|fr|uk|gov")) {
                        List partTaggerTokens;
                        String lastPart = compoundParts.get(compoundParts.size() - 1);
                        if (StringTools.startsWithUppercase((String)word)) {
                            lastPart = StringTools.uppercaseFirstChar((String)lastPart);
                        }
                        if ((partTaggerTokens = this.getWordTagger().tag(lastPart)).isEmpty()) {
                            readings.add(this.getNoInfoToken(word));
                        } else {
                            readings.addAll(this.getAnalyzedTokens(partTaggerTokens, word, compoundParts));
                        }
                    }
                }
                if (readings.isEmpty()) {
                    readings.add(this.getNoInfoToken(word));
                }
            }
            tokenReadings.add(new AnalyzedTokenReadings(readings.toArray(new AnalyzedToken[0]), pos));
            pos += word.length();
            prevWord = word;
            ++idxPos;
        }
        return tokenReadings;
    }

    @Nullable
    String prefixedVerbLastPart(String word) {
        for (String prefix : VerbPrefixes.get()) {
            List<TaggedWord> tags;
            if (!word.startsWith(prefix) || !(tags = this.tag(word.replaceFirst("^" + prefix, ""))).stream().anyMatch(k -> k.getPosTag() != null && k.getPosTag().startsWith("VER"))) continue;
            return word.substring(prefix.length());
        }
        return null;
    }

    boolean isWeiseException(String word) {
        if (word.endsWith("erweise")) {
            List<TaggedWord> tags = this.tag(StringUtils.removeEnd((String)word, (String)"erweise"));
            return tags.stream().anyMatch(k -> k.getPosTag() != null && k.getPosTag().startsWith("ADJ"));
        }
        return false;
    }

    private List<AnalyzedToken> getImperativeForm(String word, List<String> sentenceTokens, int pos) {
        int idx = sentenceTokens.indexOf(word);
        String previousWord = "";
        while (--idx > -1 && StringUtils.isWhitespace((CharSequence)(previousWord = sentenceTokens.get(idx)))) {
        }
        if (!(pos == 0 && sentenceTokens.size() > 1 || StringUtils.equalsAnyIgnoreCase((CharSequence)previousWord, (CharSequence[])new CharSequence[]{"ich", "er", "es", "sie", "bitte", "aber", "nun", "jetzt", "\u201e"}))) {
            return Collections.emptyList();
        }
        String w = pos == 0 || "\u201e".equals(previousWord) ? word.toLowerCase() : word;
        List taggedWithE = this.getWordTagger().tag(w.concat("e"));
        for (TaggedWord tagged : taggedWithE) {
            if (!tagged.getPosTag().startsWith("VER:IMP:SIN")) continue;
            if (this.removalTagger != null && this.removalTagger.tag(w).contains(tagged)) break;
            return this.getAnalyzedTokens(Arrays.asList(tagged), word);
        }
        return Collections.emptyList();
    }

    private List<AnalyzedToken> getSubstantivatedForms(String word, List<String> sentenceTokens) {
        if (word.endsWith("er")) {
            if (word.matches("\\d{4}+er")) {
                ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
                for (String tag : allAdjGruTags) {
                    list.add(new AnalyzedToken(word, tag, word));
                }
                return list;
            }
            List lowerCaseTags = this.getWordTagger().tag(word.toLowerCase());
            if (lowerCaseTags.stream().anyMatch(t -> t.getPosTag().startsWith("ADV"))) {
                return Collections.emptyList();
            }
            int idx = sentenceTokens.indexOf(word);
            while (++idx < sentenceTokens.size()) {
                String nextWord = sentenceTokens.get(idx);
                if (StringUtils.isWhitespace((CharSequence)nextWord)) continue;
                if (nextWord.length() <= 0 || !Character.isUpperCase(nextWord.charAt(0)) && !"als".equals(nextWord)) break;
                return Collections.emptyList();
            }
            String femaleForm = word.substring(0, word.length() - 1);
            List taggedFemaleForm = this.getWordTagger().tag(femaleForm);
            boolean isSubstantivatedForm = taggedFemaleForm.stream().anyMatch(t -> t.getPosTag().equals("SUB:NOM:SIN:FEM:ADJ"));
            if (isSubstantivatedForm) {
                ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
                list.add(new AnalyzedToken(word, "SUB:NOM:SIN:MAS:ADJ", word));
                list.add(new AnalyzedToken(word, "SUB:GEN:PLU:MAS:ADJ", word));
                return list;
            }
        }
        return Collections.emptyList();
    }

    private AnalyzedToken getNoInfoToken(String word) {
        return new AnalyzedToken(word, null, null);
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma()));
        }
        return result;
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word, List<String> compoundParts) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            if (taggedWord.getPosTag() != null && taggedWord.getPosTag().startsWith("VER:IMP")) continue;
            List<String> allButLastPart = compoundParts.subList(0, compoundParts.size() - 1);
            StringBuilder lemma = new StringBuilder();
            int i = 0;
            for (String s : allButLastPart) {
                lemma.append(i == 0 ? s : StringTools.lowercaseFirstChar((String)s));
                ++i;
            }
            lemma.append(StringTools.lowercaseFirstChar((String)taggedWord.getLemma()));
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), lemma.toString()));
        }
        return result;
    }

    static {
        for (String nomAkkGenDat : Arrays.asList("NOM", "AKK", "GEN", "DAT")) {
            for (String pluSin : Arrays.asList("PLU", "SIN")) {
                for (String masFemNeu : Arrays.asList("MAS", "FEM", "NEU")) {
                    for (String defIndSol : Arrays.asList("DEF", "IND", "SOL")) {
                        allAdjGruTags.add("ADJ:" + nomAkkGenDat + ":" + pluSin + ":" + masFemNeu + ":GRU:" + defIndSol);
                    }
                }
            }
        }
        nounTagExpansionExceptions = Arrays.asList("Wegstrecken");
        tagsForWeise = new ArrayList<String>();
        tagsForWeise.add("ADJ:AKK:PLU:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:PLU:MAS:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:PLU:NEU:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:DEF");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:IND");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:SIN:NEU:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:PLU:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:PLU:MAS:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:PLU:NEU:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:IND");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:SIN:MAS:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:SIN:NEU:GRU:DEF");
        tagsForWeise.add("ADJ:PRD:GRU");
        expansionInfos = Suppliers.memoize(GermanTagger::initExpansionInfos);
        INSTANCE = new GermanTagger();
    }

    static class ExpansionInfos {
        Map<String, PrefixInfixVerb> verbInfos;
        Map<String, NominalizedVerb> nominalizedVerbInfos;
        Map<String, NominalizedGenitiveVerb> nominalizedGenVerbInfos;

        ExpansionInfos(Map<String, PrefixInfixVerb> verbInfos, Map<String, NominalizedVerb> nominalizedVerbInfos, Map<String, NominalizedGenitiveVerb> nominalizedGenVerbInfos) {
            this.verbInfos = verbInfos;
            this.nominalizedVerbInfos = nominalizedVerbInfos;
            this.nominalizedGenVerbInfos = nominalizedGenVerbInfos;
        }
    }

    static class NominalizedGenitiveVerb {
        String prefix;
        String verbBaseform;

        NominalizedGenitiveVerb(String prefix, String verbBaseform) {
            this.prefix = prefix;
            this.verbBaseform = verbBaseform;
        }
    }

    static class NominalizedVerb {
        String prefix;
        String verbBaseform;

        NominalizedVerb(String prefix, String verbBaseform) {
            this.prefix = prefix;
            this.verbBaseform = verbBaseform;
        }
    }

    static class PrefixInfixVerb {
        String prefix;
        String infix;
        String verbBaseform;

        PrefixInfixVerb(String prefix, String infix, String verbBaseform) {
            this.prefix = prefix;
            this.infix = infix;
            this.verbBaseform = verbBaseform;
        }
    }
}

