/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementRuleAntiPatterns1;
import org.languagetool.rules.de.AgreementRuleAntiPatterns2;
import org.languagetool.rules.de.AgreementRuleAntiPatterns3;
import org.languagetool.rules.de.AgreementSuggestor2;
import org.languagetool.rules.de.AgreementTools;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class AgreementRule
extends Rule {
    private final German language;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private JLanguageTool lt;
    private static final AnalyzedToken[] INS_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("das", "ART:DEF:AKK:SIN:NEU", "das")};
    private static final AnalyzedToken[] ZUR_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("der", "ART:DEF:DAT:SIN:FEM", "der")};
    private static final String MSG = "M\u00f6glicherweise passen das Nomen und die W\u00f6rter, die das Nomen beschreiben, grammatisch nicht zusammen.";
    private static final String MSG2 = "M\u00f6glicherweise passen das Nomen und die W\u00f6rter, die das Nomen beschreiben, grammatisch nicht zusammen.";
    private static final String SHORT_MSG = "Evtl. passen W\u00f6rter grammatisch nicht zusammen.";
    private static final Set<String> MODIFIERS = new HashSet<String>(Arrays.asList("zu", "\u00fcberraschend", "ungeahnt", "absolut", "ausgesprochen", "au\u00dfergew\u00f6hnlich", "au\u00dferordentlich", "\u00e4u\u00dferst", "besonders", "dringend", "echt", "einigerma\u00dfen", "enorm", "extrem", "fast", "ganz", "entschieden", "geradezu", "zeitweise", "halbwegs", "h\u00f6chst", "komplett", "laufend", "recht", "relativ", "sehr", "total", "\u00fcberaus", "ungew\u00f6hnlich", "unglaublich", "v\u00f6llig", "weit", "wirklich", "gerade", "vereint", "\u00fcberwiegend", "gewollt", "angestrengt", "ziemlich"));
    private static final Set<String> VIELE_WENIGE_LOWERCASE = new HashSet<String>(Arrays.asList("manche", "jegliche", "jeglicher", "andere", "anderer", "anderen", "s\u00e4mtliche", "s\u00e4mtlicher", "etliche", "etlicher", "viele", "vieler", "wenige", "weniger", "einige", "einiger", "mehrerer", "mehrere"));
    private static final String[] REL_PRONOUN_LEMMAS = new String[]{"der", "welch"};
    private static final Set<String> PRONOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("nichts", "alles", "dies", "ebendies", "ich", "dir", "dich", "du", "d", "er", "sie", "es", "wir", "mich", "mir", "uns", "ihnen", "euch", "ihm", "ihr", "ihn", "dessen", "deren", "denen", "sich", "aller", "allen", "man", "beide", "beiden", "beider", "wessen", "a", "alle", "etwas", "irgendetwas", "irgendwas", "irgendwer", "was", "wer", "wem", "jenen", "diejenigen", "irgendjemand", "irgendjemandes", "jemand", "jemandes", "niemand", "niemandes"));
    private static final Set<String> NOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("A", "Prozent", "Wollen", "Gramm", "Kilogramm", "Flippers", "Standart", "Stellungsname", "K\u00fcndigungsscheiben", "Piepen", "Badlands", "Visual", "Special", "Multiple", "Chief", "Carina", "W\u00fcstenrot", "R\u00fcckgrad", "R\u00fcckgrads", "Anteilname", "Aalen", "Meter", "Boots", "Taxameter", "Bild", "Emirates", "Uhr", "cm", "km", "Nr", "KSC", "ANC", "DJK", "RP"));
    private static final List<List<PatternToken>> allAntiPatterns = Stream.of(AgreementRuleAntiPatterns1.ANTI_PATTERNS, AgreementRuleAntiPatterns2.ANTI_PATTERNS, AgreementRuleAntiPatterns3.ANTI_PATTERNS).flatMap(Collection::stream).collect(Collectors.toList());

    public AgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/deklination/"));
        this.addExamplePair(Example.wrong((String)"<marker>Der Haus</marker> wurde letztes Jahr gebaut."), Example.fixed((String)"<marker>Das Haus</marker> wurde letztes Jahr gebaut."));
        this.antiPatterns = AgreementRule.cacheAntiPatterns((Language)language, allAntiPatterns);
    }

    public String getId() {
        return "DE_AGREEMENT";
    }

    public int estimateContextForSureMatch() {
        return allAntiPatterns.stream().mapToInt(List::size).max().orElse(0);
    }

    public String getDescription() {
        return "Kongruenz von Nominalphrasen (unvollst\u00e4ndig!), z.B. 'mein kleiner (kleines) Haus'";
    }

    private Map<Integer, ReplacementType> replacePrepositionsByArticle(AnalyzedTokenReadings[] tokens) {
        HashMap<Integer, ReplacementType> map = new HashMap<Integer, ReplacementType>();
        for (int i = 0; i < tokens.length; ++i) {
            if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"ins", "ans", "aufs", "vors", "durchs", "hinters", "unters", "\u00fcbers", "f\u00fcrs", "ums"})) {
                tokens[i] = new AnalyzedTokenReadings(INS_REPLACEMENT, tokens[i].getStartPos());
                map.put(i, ReplacementType.Ins);
                continue;
            }
            if (!StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"zur"})) continue;
            tokens[i] = new AnalyzedTokenReadings(ZUR_REPLACEMENT, tokens[i].getStartPos());
            map.put(i, ReplacementType.Zur);
        }
        return map;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] origTokens = Arrays.copyOf(tokens, tokens.length);
        Map<Integer, ReplacementType> replMap = this.replacePrepositionsByArticle(tokens);
        for (int i = 0; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            AnalyzedTokenReadings maybePreposition;
            int tokenPos;
            boolean followingParticiple;
            String prevToken;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken) || tokens[i].isImmunized() || origTokens[i].isImmunized() || this.couldBeRelativeOrDependentClause(tokens, i) || i > 0 && StringUtils.equalsAny((CharSequence)(prevToken = tokens[i - 1].getToken().toLowerCase()), (CharSequence[])new CharSequence[]{"der", "die", "das", "des", "dieses"}) && StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"eine", "einen"})) continue;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            boolean detAbbrev = i < tokens.length - 2 && tokens[i + 1].getToken().equals("Art") && tokens[i + 2].getToken().equals(".");
            boolean detAdjAbbrev = i < tokens.length - 3 && tokens[i + 2].getToken().equals("Art") && tokens[i + 3].getToken().equals(".");
            boolean bl = followingParticiple = i < tokens.length - 3 && (tokens[i + 2].hasPartialPosTag("PA1") || tokens[i + 2].getToken().matches("zugeschriebenen?|genannten?"));
            if (detAbbrev || detAdjAbbrev || followingParticiple || !GermanHelper.hasReadingOfType(tokenReadings, GermanToken.POSType.DETERMINER) && !this.isRelevantPronoun(tokens, i)) continue;
            int tokenPosAfterModifier = this.getPosAfterModifier(i + 1, tokens);
            String skippedStr = null;
            if (tokenPosAfterModifier > i + 1) {
                skippedStr = sentence.getText().substring(tokens[i + 1].getStartPos(), tokens[tokenPosAfterModifier - 1].getEndPos());
            }
            if ((tokenPos = tokenPosAfterModifier) >= tokens.length) break;
            AnalyzedTokenReadings nextToken = tokens[tokenPos];
            AnalyzedTokenReadings analyzedTokenReadings = maybePreposition = i - 1 >= 0 ? tokens[i - 1] : null;
            if (i - 2 >= 0 && "was".equalsIgnoreCase(tokens[i - 2].getToken())) {
                maybePreposition = null;
            }
            if (this.isNonPredicativeAdjective(nextToken) || this.isParticiple(nextToken)) {
                RuleMatch ruleMatch2;
                tokenPos = tokenPosAfterModifier + 1;
                if (tokenPos >= tokens.length) break;
                if (GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.NOMEN)) {
                    boolean allowSuggestion;
                    RuleMatch ruleMatch3;
                    if (i >= 2 && GermanHelper.hasReadingOfType(tokens[i - 2], GermanToken.POSType.ADJEKTIV) && "als".equals(tokens[i - 1].getToken()) && "das".equals(tokens[i].getToken()) || (ruleMatch3 = this.checkDetAdjNounAgreement(maybePreposition, tokens[i], nextToken, tokens[tokenPos], sentence, i, (allowSuggestion = tokenPos == i + 2) ? replMap : null, skippedStr)) == null) continue;
                    ruleMatches.add(ruleMatch3);
                    continue;
                }
                if (tokenPos + 1 >= tokens.length || !GermanHelper.hasReadingOfType(tokens[tokenPos + 1], GermanToken.POSType.NOMEN) || !GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.ADJEKTIV) || (ruleMatch2 = this.checkDetAdjAdjNounAgreement(maybePreposition, tokens[i], nextToken, tokens[tokenPos], tokens[tokenPos + 1], sentence, i, replMap, skippedStr)) == null) continue;
                ruleMatches.add(ruleMatch2);
                continue;
            }
            if (!GermanHelper.hasReadingOfType(nextToken, GermanToken.POSType.NOMEN) || "Herr".equals(nextToken.getToken()) || (ruleMatch = this.checkDetNounAgreement(maybePreposition, tokens[i], nextToken, sentence, i, replMap, skippedStr)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getPosAfterModifier(int startAt, AnalyzedTokenReadings[] tokens) {
        if (startAt < tokens.length && tokens[startAt].getToken().matches("relativ") && startAt + 1 < tokens.length && tokens[startAt + 1].getToken().matches("gesehen")) {
            startAt += 2;
        }
        if (startAt < tokens.length && tokens[startAt].getToken().matches("viel|weit") && startAt + 1 < tokens.length && tokens[startAt + 1].getToken().matches("weniger|eher")) {
            startAt += 2;
        } else if (startAt + 1 < tokens.length && MODIFIERS.contains(tokens[startAt].getToken())) {
            ++startAt;
        }
        if (startAt + 1 < tokens.length) {
            String phrase = tokens[startAt].getToken() + " " + tokens[startAt + 1].getToken();
            if (phrase.toLowerCase().matches("mit (mir|dir|ihm|ihr|ihnen|uns|euch)")) {
                startAt += 2;
            } else if (phrase.toLowerCase().matches("ohne (mich|dich|ihn|sie|uns|euch)")) {
                startAt += 2;
            }
        }
        if (startAt + 1 < tokens.length && (StringUtils.isNumeric((CharSequence)tokens[startAt].getToken()) || tokens[startAt].hasPosTag("ZAL"))) {
            int posAfterModifier = startAt + 1;
            if (startAt + 3 < tokens.length && ",".equals(tokens[startAt + 1].getToken()) && StringUtils.isNumeric((CharSequence)tokens[startAt + 2].getToken())) {
                posAfterModifier = startAt + 3;
            }
            if (StringUtils.endsWithAny((CharSequence)tokens[posAfterModifier].getToken(), (CharSequence[])new CharSequence[]{"gramm", "Gramm", "Meter", "meter"})) {
                return posAfterModifier + 1;
            }
        }
        return startAt;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    private boolean isNonPredicativeAdjective(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith("ADJ") || posTag.contains("PRD")) continue;
            return true;
        }
        return false;
    }

    private boolean isParticiple(AnalyzedTokenReadings tokensReadings) {
        return tokensReadings.hasPartialPosTag("PA1") || tokensReadings.hasPartialPosTag("PA2");
    }

    private boolean isRelevantPronoun(AnalyzedTokenReadings[] tokens, int pos) {
        AnalyzedTokenReadings analyzedToken = tokens[pos];
        boolean relevantPronoun = GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PRONOMEN);
        String token = tokens[pos].getToken();
        if (PRONOUNS_TO_BE_IGNORED.contains(token.toLowerCase()) || pos > 0 && tokens[pos - 1].getToken().equalsIgnoreCase("vor") && token.equalsIgnoreCase("allem")) {
            relevantPronoun = false;
        }
        return relevantPronoun;
    }

    private boolean couldBeRelativeOrDependentClause(AnalyzedTokenReadings[] tokens, int pos) {
        boolean relPronoun;
        boolean comma;
        if (pos >= 1) {
            comma = tokens[pos - 1].getToken().equals(",");
            boolean bl = relPronoun = comma && tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            if (relPronoun && pos + 3 < tokens.length) {
                return true;
            }
        }
        if (pos >= 2 && (comma = tokens[pos - 2].getToken().equals(","))) {
            boolean prep = tokens[pos - 1].hasPosTagStartingWith("PRP:");
            relPronoun = tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            return prep && relPronoun || tokens[pos - 1].hasPosTag("KON:UNT") && (tokens[pos].hasLemma("jen") || tokens[pos].hasLemma("dies") || tokens[pos].hasLemma("ebendies"));
        }
        return false;
    }

    @Nullable
    private RuleMatch checkDetNounAgreement(AnalyzedTokenReadings maybePreposition, AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence, int tokenPos, Map<Integer, ReplacementType> replMap, String skippedStr) {
        if (token2.isImmunized() || NOUNS_TO_BE_IGNORED.contains(token2.getToken()) || "-".equals(token2.getToken())) {
            return null;
        }
        Set<String> set1 = token1.getReadings().size() == 1 && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag() != null && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag().endsWith(":STV") ? Collections.emptySet() : this.getAgreementCategories(token1);
        Set<String> set2 = this.getAgreementCategories(token2);
        set1.retainAll(set2);
        RuleMatch ruleMatch = null;
        if (set1.isEmpty() && !this.isException(token1, token2)) {
            RuleMatch compoundMatch = this.getCompoundError(token1, token2, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            String msg = "M\u00f6glicherweise passen das Nomen und die W\u00f6rter, die das Nomen beschreiben, grammatisch nicht zusammen.";
            String shortMsg = SHORT_MSG;
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
            AgreementSuggestor2 suggestor = new AgreementSuggestor2(this.language.getSynthesizer(), token1, token2, replMap.get(tokenPos));
            suggestor.setPreposition(maybePreposition);
            suggestor.setSkipped(skippedStr);
            ruleMatch.setSuggestedReplacements(suggestor.getSuggestions(true));
        }
        return ruleMatch;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 2 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 2]).getToken())) {
            if (token2.getStartPos() == nextToken.getStartPos()) {
                return null;
            }
            String potentialCompound = token2.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
            String testPhrase = origToken1 + " " + potentialCompound;
            String hyphenPotentialCompound = token2.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = origToken1 + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, nextToken, sentence, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 3 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 3]).getToken())) {
            if (token3.getStartPos() == nextToken.getStartPos()) {
                return null;
            }
            String potentialCompound = token3.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
            String testPhrase = origToken1 + " " + token2.getToken() + " " + potentialCompound;
            String hyphenPotentialCompound = token3.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = origToken1 + " " + token2.getToken() + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, nextToken, sentence, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedTokenReadings token4, int tokenPos, AnalyzedSentence sentence, String skippedStr) {
        int idx = tokenPos + 4 + (skippedStr != null ? 1 : 0);
        if (tokenPos != -1 && idx < sentence.getTokensWithoutWhitespace().length) {
            AnalyzedTokenReadings nextToken = sentence.getTokensWithoutWhitespace()[idx];
            String potentialCompound = token4.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            if (StringTools.startsWithUppercase((String)token4.getToken()) && StringTools.startsWithUppercase((String)nextToken.getToken())) {
                if (token4.getStartPos() == nextToken.getStartPos()) {
                    return null;
                }
                String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
                String testPhrase = origToken1 + (skippedStr != null ? " " + skippedStr + " " : " ") + token2.getToken() + " " + token3.getToken() + " " + potentialCompound;
                String hyphenPotentialCompound = token4.getToken() + "-" + nextToken.getToken();
                String hyphenTestPhrase = origToken1 + (skippedStr != null ? " " + skippedStr + " " : " ") + token2.getToken() + " " + token3.getToken() + " " + hyphenPotentialCompound;
                return this.getRuleMatch(token1, nextToken, sentence, testPhrase, hyphenTestPhrase);
            }
        }
        return null;
    }

    @Nullable
    private RuleMatch getRuleMatch(AnalyzedTokenReadings token, AnalyzedTokenReadings token2, AnalyzedSentence sentence, String testPhrase, String hyphenTestPhrase) {
        try {
            this.initLt();
            if (token2.getReadings().stream().allMatch(k -> k.getPOSTag() != null && !k.getPOSTag().startsWith("SUB"))) {
                return null;
            }
            ArrayList<String> replacements = new ArrayList<String>();
            if (this.lt.check(testPhrase).isEmpty() && token2.isTagged()) {
                replacements.add(testPhrase);
            }
            if (this.lt.check(hyphenTestPhrase).isEmpty() && token2.isTagged()) {
                replacements.add(hyphenTestPhrase);
            }
            if (replacements.size() > 0) {
                String message = "Wenn es sich um ein zusammengesetztes Nomen handelt, wird es zusammengeschrieben.";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, token.getStartPos(), token2.getEndPos(), message);
                ruleMatch.addSuggestedReplacements(replacements);
                ruleMatch.setUrl(Tools.getUrl((String)"https://dict.leo.org/grammatik/deutsch/Rechtschreibung/Regeln/Getrennt-zusammen/Nomen.html#grammarAnchor-Nomen-49575"));
                return ruleMatch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void initLt() {
        if (this.lt == null) {
            this.lt = new JLanguageTool((Language)this.language);
            for (Rule rule : this.lt.getAllActiveRules()) {
                if (rule.getId().equals("DE_AGREEMENT") || rule.getId().equals("GERMAN_SPELLER_RULE")) continue;
                this.lt.disableRule(rule.getId());
            }
        }
    }

    private boolean isException(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return "allen".equals(token1.getToken()) && "Grund".equals(token2.getToken());
    }

    List<String> getCategoriesCausingError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        ArrayList<String> categories = new ArrayList<String>();
        List<GrammarCategory> categoriesToCheck = Arrays.asList(GrammarCategory.KASUS, GrammarCategory.GENUS, GrammarCategory.NUMERUS);
        for (GrammarCategory category : categoriesToCheck) {
            if (!this.agreementWithCategoryRelaxation(token1, token2, category)) continue;
            categories.add(category.displayName);
        }
        return categories;
    }

    private RuleMatch checkDetAdjNounAgreement(AnalyzedTokenReadings maybePreposition, AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedSentence sentence, int tokenPos, Map<Integer, ReplacementType> replMap, String skippedStr) {
        if (token3 == null || token3.getToken().length() < 2) {
            return null;
        }
        Set<String> set = this.retainCommonCategories(token1, token2, token3);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            RuleMatch compoundMatch;
            AnalyzedTokenReadings token4;
            if (token3.getToken().matches("Herr|Frau") && tokenPos + 3 < sentence.getTokensWithoutWhitespace().length && (!(token4 = sentence.getTokensWithoutWhitespace()[tokenPos + 3]).isTagged() || token4.hasPosTagStartingWith("EIG:"))) {
                return null;
            }
            if (tokenPos + 4 < sentence.getTokensWithoutWhitespace().length && (compoundMatch = this.getCompoundError(sentence.getTokensWithoutWhitespace()[tokenPos], sentence.getTokensWithoutWhitespace()[tokenPos + 1], sentence.getTokensWithoutWhitespace()[tokenPos + 2], sentence.getTokensWithoutWhitespace()[tokenPos + 3], tokenPos, sentence, null)) != null) {
                return compoundMatch;
            }
            compoundMatch = this.getCompoundError(token1, token2, token3, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            if (token3.hasPosTagStartingWith("ABK")) {
                return null;
            }
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token3.getEndPos(), "M\u00f6glicherweise passen das Nomen und die W\u00f6rter, die das Nomen beschreiben, grammatisch nicht zusammen.", SHORT_MSG);
            AgreementSuggestor2 suggestor = new AgreementSuggestor2(this.language.getSynthesizer(), token1, token2, token3, replMap != null ? replMap.get(tokenPos) : null);
            suggestor.setPreposition(maybePreposition);
            suggestor.setSkipped(skippedStr);
            ruleMatch.setSuggestedReplacements(suggestor.getSuggestions(true));
        }
        return ruleMatch;
    }

    private RuleMatch checkDetAdjAdjNounAgreement(AnalyzedTokenReadings maybePreposition, AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedTokenReadings token4, AnalyzedSentence sentence, int tokenPos, Map<Integer, ReplacementType> replMap, String skippedStr) {
        Set<String> set = this.retainCommonCategories(token1, token2, token3, token4);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            RuleMatch compoundMatch = this.getCompoundError(token1, token2, token3, token4, tokenPos, sentence, skippedStr);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            if (token4.hasPosTagStartingWith("ABK")) {
                return null;
            }
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token4.getEndPos(), "M\u00f6glicherweise passen das Nomen und die W\u00f6rter, die das Nomen beschreiben, grammatisch nicht zusammen.", SHORT_MSG);
            if (replMap != null) {
                AgreementSuggestor2 suggestor = new AgreementSuggestor2(this.language.getSynthesizer(), token1, token2, token3, token4, replMap.get(tokenPos));
                suggestor.setPreposition(maybePreposition);
                suggestor.setSkipped(skippedStr);
                ruleMatch.setSuggestedReplacements(suggestor.getSuggestions(true));
            }
        }
        return ruleMatch;
    }

    private boolean agreementWithCategoryRelaxation(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax != null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, true);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, true);
        set1.retainAll(set2);
        return !set1.isEmpty();
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3) {
        Set<GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, skipSol);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        Set<String> set3 = AgreementTools.getAgreementCategories(token3, categoryToRelaxSet, true);
        set1.retainAll(set2);
        set1.retainAll(set3);
        return set1;
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedTokenReadings token4) {
        Set<GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, skipSol);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        Set<String> set3 = AgreementTools.getAgreementCategories(token3, categoryToRelaxSet, skipSol);
        Set<String> set4 = AgreementTools.getAgreementCategories(token4, categoryToRelaxSet, true);
        set1.retainAll(set2);
        set1.retainAll(set3);
        set1.retainAll(set4);
        return set1;
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken) {
        return AgreementTools.getAgreementCategories(aToken, new HashSet<GrammarCategory>(), false);
    }

    static enum ReplacementType {
        Ins,
        Zur;

    }

    static enum GrammarCategory {
        KASUS("Kasus (Fall: Wer/Was, Wessen, Wem, Wen/Was - Beispiel: 'das Fahrrads' statt 'des Fahrrads')"),
        GENUS("Genus (m\u00e4nnlich, weiblich, s\u00e4chlich - Beispiel: 'der Fahrrad' statt 'das Fahrrad')"),
        NUMERUS("Numerus (Einzahl, Mehrzahl - Beispiel: 'das Fahrr\u00e4der' statt 'die Fahrr\u00e4der')");

        private final String displayName;

        private GrammarCategory(String displayName) {
            this.displayName = displayName;
        }
    }
}

