/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RedundantModalOrAuxiliaryVerb
extends Rule {
    private static final String VERB_TEXT = " scheint redundant zu sein. Pr\u00fcfen Sie, ob es gel\u00f6scht oder der Satz umformuliert werden kann.";
    private static final String SUB_TEXT = "Der Satzteil scheint redundant zu sein. Pr\u00fcfen Sie, ob es gel\u00f6scht oder der Satz umformuliert werden kann.";
    private static final Pattern MARKS_REGEX = Pattern.compile("[,;.:?!-\u2013\u2014\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]]");

    public RedundantModalOrAuxiliaryVerb(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    public String getId() {
        return "REDUNDANT_MODAL_VERB";
    }

    public String getDescription() {
        return "Redundantes Modal- oder Hilfsverb";
    }

    private static boolean isBreakToken(String sToken) {
        return MARKS_REGEX.matcher(sToken).matches() || sToken.equals("und") || sToken.equals("oder") || sToken.equals("sowie");
    }

    private int hasParticipleAt(int nConjunction, int nStart, AnalyzedTokenReadings[] tokens) {
        if (tokens[nConjunction - 1].hasPosTagStartingWith("PA2")) {
            String sParticiple = tokens[nConjunction - 1].getToken();
            for (int i = nStart; i < tokens.length; ++i) {
                String sToken = tokens[i].getToken();
                if (RedundantModalOrAuxiliaryVerb.isBreakToken(sToken)) {
                    return -1;
                }
                if (!sToken.equals(sParticiple)) continue;
                if (i == tokens.length - 1 || RedundantModalOrAuxiliaryVerb.isBreakToken(tokens[i + 1].getToken())) {
                    return i;
                }
                return -1;
            }
        }
        return -1;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        block0: for (int nt = 2; nt < tokens.length; ++nt) {
            String sToken;
            boolean isModVerb = tokens[nt].hasPosTagStartingWith("VER:MOD");
            if (!isModVerb && !tokens[nt].hasPosTagStartingWith("VER:AUX") || nt + 1 >= tokens.length || tokens[nt - 1].getToken().equals(tokens[nt + 1].getToken())) continue;
            String sVerb = tokens[nt].getToken();
            int nVerb = nt++;
            boolean doBreak = false;
            String suggestion = null;
            while (nt < tokens.length && !MARKS_REGEX.matcher(sToken = tokens[nt].getToken()).matches()) {
                if (sToken.equals("und") || sToken.equals("oder") || sToken.equals("sowie")) {
                    int nConjunction = nt++;
                    doBreak = true;
                    while (nt < tokens.length && !RedundantModalOrAuxiliaryVerb.isBreakToken(sToken = tokens[nt].getToken())) {
                        if (sToken.equals(sVerb)) {
                            RuleMatch ruleMatch = null;
                            if (nt - 1 == nConjunction) {
                                String msg;
                                if (nVerb == nConjunction - 1) break;
                                int n = 1;
                                while (nt + n < tokens.length && tokens[nt + n].getToken().equalsIgnoreCase(tokens[nVerb + n].getToken())) {
                                    ++n;
                                }
                                if (n > 1) {
                                    if (nVerb + n == nConjunction) break;
                                    msg = SUB_TEXT;
                                    ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt + n - 1].getEndPos(), msg);
                                } else {
                                    msg = "Das " + (isModVerb ? "Modalverb" : "Hilfsverb") + VERB_TEXT;
                                    ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt].getEndPos(), msg);
                                }
                            } else if (tokens[nt - 1].getToken().equalsIgnoreCase(tokens[nVerb - 1].getToken()) && tokens[nt - 1].hasPosTagStartingWith("PRO:PER") && !tokens[nt - 1].hasPosTagStartingWith("ART")) {
                                String msg = SUB_TEXT;
                                ruleMatch = nVerb == nConjunction - 1 ? new RuleMatch((Rule)this, sentence, tokens[nVerb - 2].getEndPos(), tokens[nVerb].getEndPos(), msg) : new RuleMatch((Rule)this, sentence, tokens[nt - 2].getEndPos(), tokens[nt].getEndPos(), msg);
                            } else if (nt + 1 < tokens.length && tokens[nt + 1].getToken().equalsIgnoreCase(tokens[nVerb + 1].getToken()) && (tokens[nt + 1].hasPosTagStartingWith("PRO:IND") || tokens[nt + 1].hasPosTagStartingWith("PRO:PER") && !tokens[nt + 1].getToken().equals("Sie") && !tokens[nt + 1].hasPosTagStartingWith("ART"))) {
                                if (tokens[nt + 1].hasPosTagStartingWith("PRO:PER:AKK") && tokens[nt].matchesPosTagRegex("VER:(AUX|MOD):.*KJ1")) {
                                    String msg = "Das " + (isModVerb ? "Modalverb" : "Hilfsverb") + VERB_TEXT;
                                    ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt].getEndPos(), msg);
                                } else {
                                    String msg = SUB_TEXT;
                                    ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt + 1].getEndPos(), msg);
                                }
                            } else {
                                if (tokens[nt - 1].hasPosTagStartingWith("PRO:PER") || tokens[nt - 1].getToken().equals("da") || tokens[nt - 1].getToken().equals("zu") || tokens[nVerb + 1].getToken().equals(tokens[nt - 1].getToken()) || nt + 1 < tokens.length && (tokens[nt + 1].hasPosTagStartingWith("PRO:PER") || tokens[nt - 1].getToken().equals(tokens[nt + 1].getToken()) || tokens[nt - 1].getToken().equals(tokens[nt + 1].getToken()) || tokens[nVerb - 1].getToken().equals(tokens[nt + 1].getToken()) || tokens[nVerb + 1].hasPosTagStartingWith("VER:MOD") && tokens[nt + 1].hasPosTagStartingWith("VER:MOD") || nVerb == nConjunction - 1 && !RedundantModalOrAuxiliaryVerb.isBreakToken(tokens[nt + 1].getToken())) || nVerb < nConjunction - 1 && (nt + 1 == tokens.length || RedundantModalOrAuxiliaryVerb.isBreakToken(tokens[nt + 1].getToken()))) break;
                                if (nVerb == nConjunction - 1) {
                                    String msg;
                                    int n = 1;
                                    while (nVerb - n > 0 && nt - n > nConjunction && tokens[nVerb - n].getToken().equals(tokens[nt - n].getToken())) {
                                        ++n;
                                    }
                                    if (n > 1) {
                                        msg = SUB_TEXT;
                                        ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nVerb - n].getEndPos(), tokens[nVerb].getEndPos(), msg);
                                    } else {
                                        msg = "Das " + (isModVerb ? "Modalverb" : "Hilfsverb") + VERB_TEXT;
                                        ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nVerb - 1].getEndPos(), tokens[nVerb].getEndPos(), msg);
                                    }
                                } else {
                                    int paAt = this.hasParticipleAt(nConjunction, nt + 1, tokens);
                                    if (paAt > 0) {
                                        String msg = SUB_TEXT;
                                        ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[paAt].getEndPos(), msg);
                                        suggestion = "";
                                        for (int i = nt + 1; i < paAt; ++i) {
                                            suggestion = suggestion + " " + tokens[i].getToken();
                                        }
                                    } else {
                                        int n = 1;
                                        while (n + nVerb < nConjunction && n + nt < tokens.length && tokens[nVerb + n].getToken().equals(tokens[nt + n].getToken())) {
                                            ++n;
                                        }
                                        if (n + nVerb == nConjunction) {
                                            String msg = SUB_TEXT;
                                            ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt + n - 1].getEndPos(), msg);
                                        } else {
                                            String msg = "Das " + (isModVerb ? "Modalverb" : "Hilfsverb") + VERB_TEXT;
                                            ruleMatch = new RuleMatch((Rule)this, sentence, tokens[nt - 1].getEndPos(), tokens[nt].getEndPos(), msg);
                                        }
                                    }
                                }
                            }
                            if (ruleMatch == null) break;
                            ArrayList<String> suggestions = new ArrayList<String>();
                            if (suggestion == null) {
                                suggestions.add("");
                            } else {
                                suggestions.add(suggestion);
                            }
                            ruleMatch.setSuggestedReplacements(suggestions);
                            ruleMatches.add(ruleMatch);
                            break;
                        }
                        ++nt;
                    }
                }
                if (doBreak) continue block0;
                ++nt;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

