/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class StyleRepeatedVeryShortSentences
extends TextLevelRule {
    private final Language lang;
    private static final int MIN_REPEATED = 3;
    private static final int MIN_WORDS = 4;

    public StyleRepeatedVeryShortSentences(ResourceBundle messages, Language lang) {
        super(messages);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.lang = lang;
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"Das Auto kam <marker>n\u00e4her.</marker> Der Hund <marker>schlief.</marker> Die Reifen <marker>quietschten.</marker>"), Example.fixed((String)"Das Auto kam n\u00e4her. Tief und fest schlief der Hund. Die Reifen quietschten."));
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() < 3) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int pos = 0;
        int nRepeated = 0;
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> repeatedSentences = new ArrayList<AnalyzedSentence>();
        AnalyzedTokenReadings[] tokens = null;
        int n = -1;
        int nPara = -1;
        for (AnalyzedSentence sentence : sentences) {
            boolean paragraphEnd;
            tokens = sentence.getTokensWithoutWhitespace();
            if (!((paragraphEnd = Tools.isParagraphEnd(sentences, (int)(++n), (Language)this.lang)) && ++nPara <= 0 || tokens.length <= 2 || tokens.length > 6)) {
                repeatedSentences.add(sentence);
                startPos.add(tokens[tokens.length - 2].getStartPos() + pos);
                endPos.add(tokens[tokens.length - 1].getEndPos() + pos);
                ++nRepeated;
            } else {
                if (nRepeated >= 3) {
                    for (int i = 0; i < repeatedSentences.size(); ++i) {
                        RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                        ruleMatches.add(ruleMatch);
                    }
                }
                repeatedSentences.clear();
                startPos.clear();
                endPos.clear();
                nRepeated = 0;
            }
            pos += sentence.getCorrectedTextLength();
            if (!paragraphEnd) continue;
            nPara = -1;
        }
        if (nRepeated >= 3) {
            for (int i = 0; i < repeatedSentences.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public int minToCheckParagraph() {
        return 3;
    }

    public String getId() {
        return "STYLE_REPEATED_SHORT_SENTENCES";
    }

    public String getDescription() {
        return "Stakkato-S\u00e4tze";
    }
}

