/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class SubjectVerbAgreementRule
extends Rule {
    private static final ChunkTag NPS = new ChunkTag("NPS");
    private static final ChunkTag NPP = new ChunkTag("NPP");
    private static final ChunkTag PP = new ChunkTag("PP");
    private static final List<String> QUESTION_PRONOUNS = Arrays.asList("wie");
    private static final List<String> CURRENCIES = Arrays.asList("Dollar", "Euro", "Yen");
    private static final List<SingularPluralPair> PAIRS = Arrays.asList(new SingularPluralPair("ist", "sind"), new SingularPluralPair("war", "waren"));
    private final Set<String> singular = new HashSet<String>();
    private final Set<String> plural = new HashSet<String>();
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.pos((String)"ZAL"), PatternRuleBuilderHelper.posRegex((String)"SUB:DAT:PLU:.*"), PatternRuleBuilderHelper.csRegex((String)"war|ist"), new PatternTokenBuilder().posRegex("NEG|PA2:.+").build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"Prozent"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:PLU:.*"), PatternRuleBuilderHelper.csRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.token((String)"meisten"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:PLU:.*"), PatternRuleBuilderHelper.csRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:.*:PLU:.*"), new PatternTokenBuilder().token("nicht").setSkip(1).build(), PatternRuleBuilderHelper.posRegex((String)"PRO:.*"), PatternRuleBuilderHelper.csRegex((String)"Ding"), PatternRuleBuilderHelper.csRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Teil"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.token((String)"L\u00f6sung"), PatternRuleBuilderHelper.csRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.*"), PatternRuleBuilderHelper.token((String)"zu"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:.*:PLU:.*"), PatternRuleBuilderHelper.regex((String)"keine|wenig|kaum|viel"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:SIN:.*"), PatternRuleBuilderHelper.token((String)"sind")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Zehn"), PatternRuleBuilderHelper.token((String)"Gebote"), PatternRuleBuilderHelper.token((String)"sind")), Arrays.asList(PatternRuleBuilderHelper.token((String)"all"), PatternRuleBuilderHelper.tokenRegex((String)"d(ies)?en"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*"), PatternRuleBuilderHelper.token((String)"ist"), PatternRuleBuilderHelper.posRegex((String)"ART:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*SIN.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), new PatternTokenBuilder().token("Solchen").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*"), PatternRuleBuilderHelper.token((String)"ist"), PatternRuleBuilderHelper.posRegex((String)"ART:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*SIN.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Reste|\u00dcberreste"), PatternRuleBuilderHelper.tokenRegex((String)"eines|des"), PatternRuleBuilderHelper.posRegex((String)"ADV:.*"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*SIN.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ADJ:.*"), PatternRuleBuilderHelper.tokenRegex((String)"und|sowie"), PatternRuleBuilderHelper.posRegex((String)"ADV:.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Gr\u00fcnder(in)?|Gesellschafter(in)?|Leiter(in)?|Gesch\u00e4ftsf\u00fchrer(in)?|Chef(in)?"), PatternRuleBuilderHelper.tokenRegex((String)"und|sowie|&"), new PatternTokenBuilder().tokenRegex("Gr\u00fcnder(in)?|Gesellschafter(in)?|Leiter(in)?|Gesch\u00e4ftsf\u00fchrer(in)?|Chef(in)?").setSkip(4).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.token((String)"gemeinsam")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.pos((String)"ZAL"), PatternRuleBuilderHelper.tokenRegex((String)"Tage|Monate|Jahre"), PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN:.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.posRegex((String)"ADV:MOD|ADJ:PRD:GRU"), PatternRuleBuilderHelper.pos((String)"ZAL"), PatternRuleBuilderHelper.tokenRegex((String)"Tage|Monate|Jahre"), PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN:.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), new PatternTokenBuilder().pos("PRP:CAU:GEN").setSkip(4).build(), new PatternTokenBuilder().csToken("und").setSkip(4).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SENT_START|KON:UNT"), PatternRuleBuilderHelper.posRegex((String)"(EIG|SUB):.*"), new PatternTokenBuilder().csToken("und").setSkip(3).build(), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"KON:UNT"), new PatternTokenBuilder().token("sie").setSkip(3).build(), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), new PatternTokenBuilder().posRegex("PRP:.+").setSkip(4).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.tokenRegex((String)"d(as|er)|eine?")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.+"), PatternRuleBuilderHelper.csToken((String)"vor"), PatternRuleBuilderHelper.csToken((String)"Ort"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.token((String)"zu"), PatternRuleBuilderHelper.csRegex((String)"Fu\u00df|Hause|Bein|Besuch"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.pos((String)"SUB:DAT:PLU:NOG"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.posRegex((String)".+:NOM:.+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), new PatternTokenBuilder().pos("PKT").min(0).build(), PatternRuleBuilderHelper.token((String)"sowie"), PatternRuleBuilderHelper.posRegex((String)"ART.*"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"das"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*NEU.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*NEU.*"), PatternRuleBuilderHelper.tokenRegex((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*NEU.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"der"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*MAS.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*MAS.*"), PatternRuleBuilderHelper.tokenRegex((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*MAS.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"die"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*FEM.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*FEM.*"), PatternRuleBuilderHelper.tokenRegex((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*FEM.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"(irgend)?einer?|meisten|viele|einige|Betreiber|(Mit)?Gr\u00fcnder|Inhaber"), new PatternTokenBuilder().tokenRegex("der|dieser").setSkip(4).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(new PatternTokenBuilder().token("dank").setSkip(-1).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.posRegex((String)"EIG.*|SUB.*SIN.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Start"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.token((String)"Ziel"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB.*SIN.*"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB.*SIN.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Obst"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.token((String)"Gem\u00fcse")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Sport"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.token((String)"Spiel")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*NEU.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*NEU.*"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB.*NEU.*"), PatternRuleBuilderHelper.tokenRegex((String)"der|dieser"), PatternRuleBuilderHelper.posRegex((String)"SUB.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*PLU.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*PLU.*"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.posRegex((String)"SUB.*PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"der|dieser"), PatternRuleBuilderHelper.posRegex((String)"SUB.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]|ART).*SIN.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*SIN.*"), PatternRuleBuilderHelper.posRegex((String)"PRP.*"), PatternRuleBuilderHelper.posRegex((String)"EIG.*GEN.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*"), PatternRuleBuilderHelper.tokenRegex((String)"ist|war")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]|ART).*PLU.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*PLU.*"), PatternRuleBuilderHelper.posRegex((String)"PRP.*"), PatternRuleBuilderHelper.posRegex((String)"EIG.*GEN.*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB.*PLU.*"), PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.token((String)"auch"), PatternRuleBuilderHelper.tokenRegex((String)".+"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war|w\u00e4re?"), PatternRuleBuilderHelper.posRegex((String)"EIG:NOM:SIN.*|PRO:PER:NOM:SIN.*"), PatternRuleBuilderHelper.posRegex((String)"ADJ:PRD:GRU")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"bist|w[\u00e4a]rst"), PatternRuleBuilderHelper.tokenRegex((String)"du"), PatternRuleBuilderHelper.posRegex((String)"ADJ:PRD:GRU")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"sind|w[\u00e4a]ren|seid"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:PLU.*"), PatternRuleBuilderHelper.posRegex((String)"ADJ:PRD:GRU")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:MAS"), PatternRuleBuilderHelper.posRegex((String)"ART:...:GEN:PLU:MAS"), PatternRuleBuilderHelper.posRegex((String)"SUB:GEN:PLU:.+"), PatternRuleBuilderHelper.pos((String)"KON:NEB"), PatternRuleBuilderHelper.posRegex((String)"SUB:GEN:PLU:.+"), PatternRuleBuilderHelper.tokenRegex((String)"ist|w[\u00e4a]r")), Arrays.asList(new PatternTokenBuilder().csToken("Laut").setSkip(4).build(), new PatternTokenBuilder().csToken("und").setSkip(5).build(), PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.tokenRegex((String)"d(er|ie|as)"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:.+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war"), PatternRuleBuilderHelper.tokenRegex((String)"d(er|ie|as)"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:.+"), PatternRuleBuilderHelper.posRegex((String)"(ART|PRO:POS).*SIN.*"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:.+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"die"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.tokenRegex((String)"Mehrheit"), PatternRuleBuilderHelper.tokenRegex((String)"der|dieser|aller|unse?rer|[dsm]einer|euer|eurer|ihrer"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*NOM.*PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind|w[\u00e4a]ren")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"weil|da|denn|dass"), PatternRuleBuilderHelper.tokenRegex((String)"die|diese|solche|alle|viele|beide|einige|[mkds]eine|eure|unse?re|ihre"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*NOM.*PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"ein"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*NOM.*SIN.*"), PatternRuleBuilderHelper.tokenRegex((String)"sind|w[\u00e4a]ren")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"alle|die(se)?|einige|keine|viele|solche"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*NOM.*PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"der|unse?rer|euer|eurer|[dsm]einer|dieser|solcher|aller|einiger|vieler|ihrer|beider"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*GEN.*PLU.*"), PatternRuleBuilderHelper.posRegex((String)"VER.*PLU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"wir|sie|die|alle|diese|einige|manche|viele|sonstige"), PatternRuleBuilderHelper.posRegex((String)"ART.*|PRO:(POS|DEM|IND).*"), new PatternTokenBuilder().posRegex("(ADJ|PA[12]).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*SIN.*"), PatternRuleBuilderHelper.posRegex((String)"VER.*PLU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"wir|sie|die|alle|diese|einige|manche|viele|sonstige"), PatternRuleBuilderHelper.posRegex((String)"ART.*|PRO:(POS|DEM|IND).*"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*|ADV.*"), PatternRuleBuilderHelper.posRegex((String)"(ADJ|PA[12]).*"), PatternRuleBuilderHelper.posRegex((String)"SUB.*SIN.*"), PatternRuleBuilderHelper.posRegex((String)"VER.*PLU.*")));
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private German language;

    public SubjectVerbAgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        for (SingularPluralPair pair : PAIRS) {
            this.singular.add(pair.singular);
            this.plural.add(pair.plural);
        }
        this.addExamplePair(Example.wrong((String)"Die Autos <marker>ist</marker> schnell."), Example.fixed((String)"Die Autos <marker>sind</marker> schnell."));
        this.antiPatterns = SubjectVerbAgreementRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "DE_SUBJECT_VERB_AGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (unvollst\u00e4ndig)";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://dict.leo.org/grammatik/deutsch/Wort/Verb/Kategorien/Numerus-Person/ProblemNum.html");
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch pluralMatch;
            if (tokens[i].isImmunized()) continue;
            String tokenStr = tokens[i].getToken();
            RuleMatch singularMatch = this.getSingularMatchOrNull(tokens, i, tokens[i], tokenStr, sentence);
            if (singularMatch != null) {
                ruleMatches.add(singularMatch);
            }
            if ((pluralMatch = this.getPluralMatchOrNull(tokens, i, tokens[i], tokenStr, sentence)) == null) continue;
            ruleMatches.add(pluralMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private RuleMatch getSingularMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr, AnalyzedSentence sentence) throws IOException {
        if (this.singular.contains(tokenStr)) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            AnalyzedTokenReadings nextToken = i + 1 < tokens.length ? tokens[i + 1] : null;
            List prevChunkTags = prevToken.getChunkTags();
            boolean bl = match = prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !prevToken.getToken().equals("Uhr") && !this.isCurrency(prevToken) && (nextToken == null || !nextToken.getToken().equals("es")) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasQuestionPronounToTheLeft(tokens, i - 1) && !this.hasVerbToTheLeft(tokens, i - 1) && !this.containsRegexToTheLeft("wer|(?i)alle[nr]?|(?i)jede[rs]?|(?i)manche[nrs]?", tokens, i - 1) && !this.containsOnlyInfinitivesToTheLeft(tokens, i - 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + this.getPluralFor(tokenStr) + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    @Nullable
    private RuleMatch getPluralMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr, AnalyzedSentence sentence) {
        if (this.plural.contains(tokenStr)) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            List prevChunkTags = prevToken.getChunkTags();
            AnalyzedTokenReadings nextToken = i + 1 < tokens.length ? tokens[i + 1] : null;
            boolean bl = match = prevChunkTags.contains(NPS) && (nextToken == null || !nextToken.getToken().equals("Sie")) && !prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !this.isCurrency(prevToken) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasUnknownTokenToTheRight(tokens, i + 1) && !StringUtils.equalsAny((CharSequence)tokens[1].getToken(), (CharSequence[])new CharSequence[]{"Alle", "Viele"}) && !this.isFollowedByNominativePlural(tokens, i + 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + this.getSingularFor(tokenStr) + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    private boolean isCurrency(AnalyzedTokenReadings token) {
        return CURRENCIES.contains(token.getToken());
    }

    boolean prevChunkIsNominative(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            List chunkTags = tokens[i].getChunkTags();
            if (chunkTags.contains(NPS) || chunkTags.contains(NPP)) {
                if (!tokens[i].hasPartialPosTag("NOM")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasUnknownTokenToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, 0, startPos);
    }

    private boolean hasUnknownTokenToTheRight(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, startPos, tokens.length - 1);
    }

    private boolean hasUnknownTokenAt(AnalyzedTokenReadings[] tokens, int startPos, int endPos) {
        for (int i = startPos; i < endPos; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            for (AnalyzedToken analyzedToken : token.getReadings()) {
                if (!analyzedToken.hasNoTag()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasQuestionPronounToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            if (!QUESTION_PRONOUNS.contains(tokens[i].getToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean hasVerbToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            if (!tokens[i].matchesPosTagRegex("VER:[1-3]:.+")) continue;
            return true;
        }
        return false;
    }

    private boolean containsRegexToTheLeft(String regex, AnalyzedTokenReadings[] tokens, int startPos) {
        Pattern p = Pattern.compile(regex);
        for (int i = startPos; i > 0; --i) {
            if (!p.matcher(tokens[i].getToken()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyInfinitivesToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) throws IOException {
        int infinitives = 0;
        for (int i = startPos; i > 0; --i) {
            String token = tokens[i].getToken();
            if (!tokens[i].hasPartialPosTag("SUB:")) continue;
            AnalyzedTokenReadings lookup = ((GermanTagger)this.language.getTagger()).lookup(token.toLowerCase());
            if (lookup != null && lookup.hasPosTagStartingWith("VER:INF")) {
                ++infinitives;
                continue;
            }
            return false;
        }
        return infinitives >= 2;
    }

    boolean isFollowedByNominativePlural(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i < tokens.length; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            if (!token.hasAnyPartialPosTag(new String[]{"SUB", "PRO"}) || !token.hasPartialPosTag("NOM:PLU") && !token.getChunkTags().contains(NPP)) continue;
            return true;
        }
        return false;
    }

    private String getSingularFor(String token) {
        for (SingularPluralPair pair : PAIRS) {
            if (!pair.plural.equals(token)) continue;
            return pair.singular;
        }
        throw new RuntimeException("No singular found for '" + token + "'");
    }

    private String getPluralFor(String token) {
        for (SingularPluralPair pair : PAIRS) {
            if (!pair.singular.equals(token)) continue;
            return pair.plural;
        }
        throw new RuntimeException("No plural found for '" + token + "'");
    }

    private static class SingularPluralPair {
        String singular;
        String plural;

        SingularPluralPair(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }
    }
}

