/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;

public class GermanConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<Pattern> SENTENCE_EXCEPTION_PATTERNS = Arrays.asList(Pattern.compile("wir \\("), Pattern.compile("Wie .*?en Sie"), Pattern.compile("fiel(e|en)? .* (aus|auf|anheim)"), Pattern.compile("(regnet|schneit)e? es viel"), Pattern.compile("(regnet|schneit)e? es (im|jeden) [A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\\-\u00df]+ viel"), Pattern.compile("viel in [A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\\-\u00df]+ unterwegs"), Pattern.compile("viel am [A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\\-\u00df]+"), Pattern.compile("[Ii]hr .* seht"), Pattern.compile("fiel .*in die Kategorie"), Pattern.compile("fiel .*nicht leicht"), Pattern.compile("wie fiel das ins Gewicht"));
    private static final List<String> EXCEPTIONS = Arrays.asList("wir bei der", "seht ihr", "seht zu, dass", "seht zu dass", "seht es euch", "seht selbst", "seht an", "viel hin und her", "m\u00f6glichkeit wei\u00dft", "du doch trotzdem", "wir stark ausgelastet sind", "wir entwickeln f\u00fcr", "nutzen wir Google", "vertreiben wir", "wir auch nicht", ", dir bei", "fiel hinaus", "setz dir", "du hast dir", "vielen als held", "seht gut", "so viel das", "wie erinnern sie sich", "d\u00fcrfen wir nicht", "kann dich auch", "wie schicken wir", "wie benutzen sie", "wir ja nicht", "wie wir oder", "eine uhrzeit hatten", "damit wir das", "damit wir die", "damit wir dir", "was wird in", "warum wird da", "da mir der", "das wir uns", "so wir k\u00f6nnen", "bestellt Botschafter ein", "bestellt Botschafterin ein", "wie zahlen sie", "unser business", "journalisten gefiltert worden", "f\u00fcr uns filtern", "leinwand gezeigte", "war sich f\u00fcr nichts", "dover corporation", "bringt dich ein", "bringt dich eine", "womit arbeitet", "womit arbeiten", "ich drei bin", "was wird unser", "die wird wieder", "damit wir f\u00fcr", "wie finden sie", "ach die armen", "wie stehen da die", "wir w\u00fcrden sie", "damit wir ihre daten", "kannst du doch gerne", "wie ist hier der Stand", "wie ist der Stand", "dass da Potenzial zu", "das auch hergibt", "hat mich angeschrieben", "sehe gerade", "hole dich auch ab", "w\u00fcrdest du dich vorstellen", "daten wir \u00fcber", "anders seht", "weit fallendem", "weit fallenden", "weit fallendes", "weit fallende", "weit fallender", "wir ja.", "wei\u00dft, wie", "wei\u00dft ja, wie", "wei\u00dft, dass", "wei\u00dft ja, dass", "viel Spass", "viel Bock", "so viel", "viel laenger", "voll viel", "fasst nichts an", "fasst mit an", "kann das wer best\u00e4tigen", "fasst keiner an", "fasst keine mehr an", "fasst keiner mehr an", "Vorgestern und Gestern");
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().token("im").setSkip(8).build(), PatternRuleBuilderHelper.posRegex((String)"PA[12].*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER.*"), new PatternTokenBuilder().token("es").min(0).build(), PatternRuleBuilderHelper.token((String)"viel")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER.*"), PatternRuleBuilderHelper.posRegex((String)"(EIG|SUB).*"), PatternRuleBuilderHelper.token((String)"viel")), Arrays.asList(new PatternTokenBuilder().token("viel").setSkip(8).build(), PatternRuleBuilderHelper.posRegex((String)"PA2.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"viel"), new PatternTokenBuilder().posRegex("ADJ.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Wie"), PatternRuleBuilderHelper.posRegex((String)"VER.*")), Arrays.asList(new PatternTokenBuilder().token("weist").setSkip(8).build(), PatternRuleBuilderHelper.token((String)"den"), PatternRuleBuilderHelper.csToken((String)"Weg")), Arrays.asList(PatternRuleBuilderHelper.regex((String)".*tank|.*bus|.*zug|.*flieger|.*flugzeug|.*container|.*beh\u00e4lter|.*sch\u00fcssel|.*festplatte|Platte|SSD|.*speicher|.*glas|.*tasse|.*batterie"), PatternRuleBuilderHelper.token((String)"fasst")), Arrays.asList(new PatternTokenBuilder().token("fasst").setSkip(-1).build(), PatternRuleBuilderHelper.token((String)"zusammen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wer"), PatternRuleBuilderHelper.regex((String)"['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.token((String)"s"), PatternRuleBuilderHelper.regex((String)"glaubt|will|mag")), Arrays.asList(new PatternTokenBuilder().token("sieht").setSkip(-1).build(), PatternRuleBuilderHelper.regex((String)"gedeckt|best\u00e4tigt|aus")));

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams, EXCEPTIONS, ANTI_PATTERNS);
        this.addExamplePair(Example.wrong((String)"W\u00e4hrend Sie das Ganze <marker>mir</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"), Example.fixed((String)"W\u00e4hrend Sie das Ganze <marker>mit</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"));
    }

    protected boolean isException(String sentenceText, int startPos, int endPos) {
        for (Pattern pattern : SENTENCE_EXCEPTION_PATTERNS) {
            Matcher m = pattern.matcher(sentenceText);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    protected boolean isCommonWord(String token) {
        return token.matches("[\\w\u00f6\u00e4\u00fc\u00df\u00d6\u00c4\u00dc]+");
    }
}

