/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.tools.Tools;

public class GermanUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> DE_START_SYMBOLS = Arrays.asList("[", "(", "{", "\u201e", "\u00bb", "\u00ab", "\"");
    private static final List<String> DE_END_SYMBOLS = Arrays.asList("]", ")", "}", "\u201c", "\u00ab", "\u00bb", "\"");

    public GermanUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, DE_START_SYMBOLS, DE_END_SYMBOLS);
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/klammern/"));
        this.addExamplePair(Example.wrong((String)"Dem Pr\u00e4sidenten des Deutschen Bauernverbands <marker>(</marker>DBV zufolge habe die D\u00fcrre einen Schaden von 1,4 Millionen verursacht."), Example.fixed((String)"Dem Pr\u00e4sidenten des Deutschen Bauernverbands <marker>(</marker>DBV) zufolge habe die D\u00fcrre einen Schaden von 1,4 Millionen verursacht."));
    }

    public String getId() {
        return "UNPAIRED_BRACKETS";
    }

    protected List<String> getSuggestions(Supplier<String> text, int startPos, int endPos, GenericUnpairedBracketsRule.Symbol symbol, String otherSymbol) {
        String ch;
        if (startPos > 0 && endPos <= text.get().length()) {
            String prevCh = text.get().substring(startPos - 1, endPos - 1);
            String ch2 = text.get().substring(startPos, endPos);
            if (prevCh.equals(" ") && ch2.equals("\u201c")) {
                return Arrays.asList("\u201e");
            }
            if (prevCh.equals("\u00a0") && ch2.equals("\u201c")) {
                return Arrays.asList("\u201e");
            }
        }
        if (startPos == 0 && endPos <= text.get().length() && (ch = text.get().substring(startPos, endPos)).equals("\u201c")) {
            return Arrays.asList("\u201e");
        }
        return null;
    }
}

