/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.Rule;

public class StyleTooOftenUsedNounRule
extends AbstractStyleTooOftenUsedWordRule {
    private static final int DEFAULT_MIN_PERCENT = 5;
    String sentenceMessage = null;

    public StyleTooOftenUsedNounRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 5);
        LinguServices linguServices;
        if (userConfig != null && (linguServices = userConfig.getLinguServices()) != null) {
            linguServices.setThesaurusRelevantRule((Rule)this);
        }
    }

    protected String getLimitMessage(int limit) {
        return "Das Substantiv wird h\u00e4ufiger verwendet als " + limit + "% aller Substantive. M\u00f6glicherweise ist es besser es durch ein Synonym zu ersetzen.";
    }

    public String getId() {
        return "TOO_OFTEN_USED_NOUN_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: Zu h\u00e4ufig genutztes Substantiv";
    }

    public String getConfigureText() {
        return "Anzeigen wenn ein Substantiv h\u00e4ufiger verwendet wird als ...% aller Substantive:";
    }

    protected boolean isToCountedWord(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("SUB:");
    }

    protected boolean isException(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("PRO:") || token.getToken().equals("Ja");
    }

    private String getLemmaForPosTagStartsWith(String startPos, AnalyzedTokenReadings token) {
        List readings = token.getReadings();
        for (AnalyzedToken reading : readings) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith(startPos)) continue;
            return reading.getLemma();
        }
        return null;
    }

    protected String toAddedLemma(AnalyzedTokenReadings token) {
        return this.getLemmaForPosTagStartsWith("SUB:", token);
    }
}

