/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.Example;

public class UnnecessaryPhraseRule
extends AbstractStatisticStyleRule {
    private static final int DEFAULT_MIN_PER_MILL = 8;
    private static final String[][] unnecessaryPhrases = new String[][]{{"dann", "und", "wann"}, {"des", "Ungeachtet"}, {"ganz", "und", "gar"}, {"hie", "und", "da"}, {"im", "Allgemeinen"}, {"in", "der", "Tat"}, {"in", "diesem", "Zusammenhang"}, {"mehr", "oder", "weniger"}, {"meines", "Erachtens"}, {"ohne", "weiteres"}, {"ohne", "Zweifel"}, {"samt", "und", "sonders"}, {"sowohl", "als", "auch"}, {"voll", "und", "ganz"}, {"von", "Neuem"}, {"allem", "Anschein", "nach"}, {"aufs", "Neue"}, {"ein", "bisschen"}, {"ein", "wenig"}, {"des", "\u00d6fteren"}, {"bei", "weitem"}, {"an", "sich"}};

    public UnnecessaryPhraseRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 8);
        this.addExamplePair(Example.wrong((String)"Das ist <marker>allem Anschein nach</marker> eine Phrase."), Example.fixed((String)"Das ist eine Phrase."));
    }

    public double denominator() {
        return 10000.0;
    }

    private static String firstCharToLower(AnalyzedTokenReadings[] tokens, int nToken) {
        String token = tokens[nToken].getToken();
        return nToken != 1 || token.length() < 2 ? token : token.substring(0, 1).toLowerCase() + token.substring(1);
    }

    protected int conditionFulfilled(AnalyzedTokenReadings[] tokens, int nAnalysedToken) {
        for (int i = 0; i < unnecessaryPhrases.length; ++i) {
            int j;
            for (j = 0; j < unnecessaryPhrases[i].length && nAnalysedToken + j < tokens.length && unnecessaryPhrases[i][j].equals(UnnecessaryPhraseRule.firstCharToLower(tokens, nAnalysedToken + j)); ++j) {
            }
            if (j != unnecessaryPhrases[i].length) continue;
            return nAnalysedToken + unnecessaryPhrases[i].length - 1;
        }
        return -1;
    }

    protected boolean sentenceConditionFulfilled(AnalyzedTokenReadings[] tokens, int nToken) {
        return false;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Der Ausdruck gilt als Phrase. Es wird empfohlen ihn zu l\u00f6schen, falls m\u00f6glich.";
        }
        return "Mehr als " + limit + "\u2031 potenzielle Phrasen {" + (int)(percent + 0.5) + "\u2031} gefunden. Es wird empfohlen den Ausdruck zu l\u00f6schen, falls m\u00f6glich.";
    }

    protected String getSentenceMessage() {
        return null;
    }

    public String getId() {
        return "UNNECESSARY_PHRASES_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: Potenzielle Phrasen";
    }

    public String getConfigurePercentText() {
        return "Anzeigen wenn mehr als ...\u2031 eines Kapitels potenzielle Phrasen sind:";
    }

    public String getConfigureWithoutDirectSpeachText() {
        return "Keine direkte Rede und Zitate ber\u00fccksichtigen";
    }
}

